/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.disassembly;

import java.io.IOException;
import java.util.Collection;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.debugger.common.disassembly.RegisterValue;
import org.netbeans.modules.cnd.debugger.gdb.GdbContext;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public class DisToolTipAnnotation
extends Annotation
implements Runnable {
    private Line.Part lp;
    private EditorCookie ec;

    public String getShortDescription() {
        Disassembly dis = Disassembly.getCurrent();
        if (dis == null) {
            return null;
        }
        Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
        if (lp == null) {
            return null;
        }
        Line line = lp.getLine();
        DataObject dob = DataEditorSupport.findDataObject((Line)line);
        if (dob == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        this.lp = lp;
        this.ec = ec;
        GdbUtils.getGdbRequestProcessor().post((Runnable)this);
        return null;
    }

    @Override
    public void run() {
        StyledDocument doc;
        if (this.lp == null || this.ec == null) {
            return;
        }
        try {
            doc = this.ec.openDocument();
        }
        catch (IOException ex) {
            return;
        }
        JEditorPane ep = EditorContextDispatcher.getDefault().getCurrentEditor();
        if (ep == null) {
            return;
        }
        String register = DisToolTipAnnotation.getRegister(doc, ep, NbDocument.findLineOffset((StyledDocument)doc, (int)this.lp.getLine().getLineNumber()) + this.lp.getColumn());
        if (register == null) {
            return;
        }
        String toolTipText = null;
        Collection regValues = (Collection)GdbContext.getInstance().getProperty("Registers");
        if (regValues != null) {
            for (RegisterValue value : regValues) {
                if (!register.equals(value.getName())) continue;
                toolTipText = value.getValue();
            }
        }
        this.firePropertyChange("shortDescription", null, toolTipText);
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getRegister(StyledDocument doc, JEditorPane ep, int offset) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            for (identStart = col; identStart > 0 && (Character.isJavaIdentifierPart(t.charAt(identStart - 1)) || t.charAt(identStart - 1) == '.'); --identStart) {
            }
            if (identStart == 0 || t.charAt(identStart - 1) != '%') {
                return null;
            }
            for (identEnd = col; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
            }
            if (identStart == identEnd) {
                return null;
            }
            return t.substring(identStart, identEnd);
        }
        catch (BadLocationException e) {
            return null;
        }
    }
}

