/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointImpl;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;

public class LineBreakpointImpl
extends BreakpointImpl<LineBreakpoint> {
    private String lastPath = null;

    public LineBreakpointImpl(LineBreakpoint breakpoint, GdbDebugger debugger) {
        super(breakpoint, debugger);
        this.set();
    }

    @Override
    protected String getBreakpointCommand() {
        int lineNumber = ((LineBreakpoint)this.getBreakpoint()).getLineNumber();
        String bppath = ((LineBreakpoint)this.getBreakpoint()).getPath();
        String path = null;
        if (this.lastPath == null && bppath.indexOf(32) == -1) {
            path = this.debugger.getPathMap().getRemotePath(bppath, true);
        } else if (this.lastPath == null) {
            path = this.debugger.getBestPath(bppath);
        } else if (this.lastPath.length() > 0) {
            if (this.lastPath.equals(bppath)) {
                path = this.debugger.getBestPath(bppath);
            } else {
                int pos = this.lastPath.lastIndexOf(47);
                if (pos >= 0) {
                    path = this.lastPath.substring(pos + 1);
                }
            }
        }
        this.lastPath = path;
        if (path == null) {
            return null;
        }
        if (this.debugger.isCygwin()) {
            path = WindowsSupport.getInstance().convertToCygwinPath(path);
        }
        return path + ':' + lineNumber;
    }

    @Override
    protected boolean alternateSourceRootAvailable() {
        return this.err != null && this.err.startsWith("No source file named ") && this.lastPath != null && this.lastPath.length() > 0;
    }
}

