/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;

public class GdbContext
implements PropertyChangeListener {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Map<String, Request> requests = new HashMap<String, Request>();
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private final Map<String, Object> waitLocks = new HashMap<String, Object>();
    private static final int SYNC_UPDATE_TIMEOUT = 30000;
    public static final String PROP_REGISTERS = "Registers";
    public static final String PROP_STEP = "Step";
    public static final String PROP_EXIT = "Exit";
    private static GdbContext instance = null;

    private GdbContext() {
        this.requests.put(PROP_REGISTERS, new Request(){

            @Override
            protected void request(GdbProxy gdb) {
                gdb.data_list_register_values("");
                gdb.data_list_changed_registers();
            }
        });
        this.pcs.addPropertyChangeListener(this);
    }

    public void gdbExit() {
        this.invalidate(true);
        this.pcs.firePropertyChange(PROP_EXIT, 0, 1);
    }

    private void invalidate(boolean fireUpdates) {
        this.cache.clear();
        if (fireUpdates) {
            for (String propertyName : this.requests.keySet()) {
                if (!this.hasListeners(propertyName)) continue;
                this.pcs.firePropertyChange(propertyName, 0, 1);
            }
        }
    }

    public void gdbStep() {
        this.invalidate(false);
        for (Map.Entry<String, Request> entry : this.requests.entrySet()) {
            if (!this.hasListeners(entry.getKey())) continue;
            entry.getValue().run();
        }
        this.pcs.firePropertyChange(PROP_STEP, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object lock = this.waitLocks.get(evt.getPropertyName());
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String name) {
        Object res = this.cache.get(name);
        if (res == null) {
            boolean child = true;
            Object lock = this.waitLocks.get(name);
            if (lock == null) {
                child = false;
                lock = "Lock for " + name;
            }
            Object object = lock;
            synchronized (object) {
                this.waitLocks.put(name, lock);
                if (child || this.requests.get(name).run()) {
                    try {
                        lock.wait(30000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                this.waitLocks.remove(name);
            }
            return this.cache.get(name);
        }
        return res;
    }

    public void setProperty(String name, Object value) {
        this.cache.put(name, value);
        this.pcs.firePropertyChange(name, 0, 1);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Request request;
        this.pcs.addPropertyChangeListener(propertyName, listener);
        if (!this.cache.containsKey(propertyName) && (request = this.requests.get(propertyName)) != null) {
            request.run();
        }
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    private synchronized boolean hasListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName).length > 0;
    }

    public static synchronized GdbContext getInstance() {
        if (instance == null) {
            instance = new GdbContext();
        }
        return instance;
    }

    private static abstract class Request {
        private Request() {
        }

        public boolean run() {
            GdbDebugger debugger = GdbDebugger.getGdbDebugger();
            if (debugger == null) {
                return false;
            }
            GdbProxy gdb = debugger.getGdbProxy();
            if (gdb != null) {
                if (debugger.isStopped()) {
                    this.request(gdb);
                }
                return true;
            }
            return false;
        }

        protected abstract void request(GdbProxy var1);
    }
}

