/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.indent;

import java.awt.Toolkit;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.modules.editor.indent.FormatterWriterImpl;
import org.netbeans.modules.editor.indent.IndentImpl;
import org.netbeans.modules.editor.indent.TaskHandler;
import org.netbeans.modules.editor.indent.api.IndentUtils;

public final class FormatterImpl
extends ExtFormatter {
    private final Document doc;
    private final Formatter defaultFormatter;
    private final IndentImpl indentImpl;
    private final boolean tabSizeOverriden;
    private final boolean shiftWidthOverriden;
    private final boolean expandTabsOverriden;

    FormatterImpl(Formatter defaultFormatter, Document doc) {
        super(defaultFormatter.getKitClass());
        this.defaultFormatter = defaultFormatter;
        this.tabSizeOverriden = FormatterImpl.isOverriden(defaultFormatter.getClass(), "getTabSize");
        this.shiftWidthOverriden = FormatterImpl.isOverriden(defaultFormatter.getClass(), "getShiftWidth");
        this.expandTabsOverriden = FormatterImpl.isOverriden(defaultFormatter.getClass(), "expandTabs");
        this.doc = doc;
        assert (doc != null);
        this.indentImpl = IndentImpl.get(doc);
        this.indentImpl.setDefaultFormatter(defaultFormatter);
    }

    public int[] getReformatBlock(JTextComponent target, String typedText) {
        return this.defaultFormatter instanceof ExtFormatter ? ((ExtFormatter)this.defaultFormatter).getReformatBlock(target, typedText) : null;
    }

    public void indentLock() {
        this.indentImpl.indentLock();
    }

    public void indentUnlock() {
        this.indentImpl.indentUnlock();
    }

    public void reformatLock() {
        this.indentImpl.reformatLock();
    }

    public void reformatUnlock() {
        this.indentImpl.reformatUnlock();
    }

    public int getTabSize() {
        if (this.tabSizeOverriden) {
            return this.defaultFormatter.getTabSize();
        }
        return IndentUtils.tabSize(this.doc);
    }

    public int getSpacesPerTab() {
        return this.defaultFormatter.getSpacesPerTab();
    }

    public int getShiftWidth() {
        if (this.shiftWidthOverriden) {
            return this.defaultFormatter.getShiftWidth();
        }
        return IndentUtils.indentLevelSize(this.doc);
    }

    public boolean expandTabs() {
        if (this.expandTabsOverriden) {
            return this.defaultFormatter.expandTabs();
        }
        return IndentUtils.isExpandTabs(this.doc);
    }

    public int indentLine(Document doc, int offset) {
        return this.indentLine(doc, offset, false);
    }

    public int indentNewLine(Document doc, int offset) {
        return this.indentLine(doc, offset, true);
    }

    private int indentLine(Document doc, int offset, boolean indentNewLine) {
        try {
            return this.indentImpl.reindent(offset, offset, offset, indentNewLine);
        }
        catch (GuardedException e) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
        return offset;
    }

    public Writer reformat(BaseDocument doc, int startOffset, int endOffset, boolean indentOnly) throws BadLocationException, IOException {
        return this.defaultFormatter instanceof ExtFormatter ? ((ExtFormatter)this.defaultFormatter).reformat(doc, startOffset, endOffset, indentOnly) : null;
    }

    public int reformat(BaseDocument doc, int startOffset, int endOffset) throws BadLocationException {
        if (doc != this.indentImpl.document()) {
            return endOffset - startOffset;
        }
        this.indentImpl.reformat(startOffset, endOffset);
        TaskHandler handler = this.indentImpl.reformatHandler();
        return handler != null && handler.hasItems() ? Math.max(handler.endPos().getOffset() - startOffset, 0) : endOffset - startOffset;
    }

    public Writer createWriter(Document doc, int offset, Writer writer) {
        if (doc != this.indentImpl.document()) {
            throw new IllegalStateException("Unexpected document doc=" + doc);
        }
        return new FormatterWriterImpl(this.indentImpl, offset, writer);
    }

    private static boolean isOverriden(Class clazz, String methodName) {
        while (clazz != Formatter.class && clazz != ExtFormatter.class) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equals(methodName) || m.getParameterTypes().length != 0) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }
}

