/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.utils.filters.CCSourceFileFilter;
import org.netbeans.modules.cnd.utils.filters.CSourceFileFilter;
import org.netbeans.modules.cnd.utils.filters.FortranSourceFileFilter;
import org.netbeans.modules.cnd.utils.filters.HeaderSourceFileFilter;
import org.netbeans.modules.cnd.utils.filters.QtFileFilter;
import org.netbeans.modules.cnd.utils.filters.ResourceFileFilter;
import org.netbeans.modules.cnd.utils.filters.SourceFileFilter;
import org.netbeans.modules.openfile.OpenFileDialogFilter;

public class CndOpenFileDialogFilter {
    private CndOpenFileDialogFilter() {
    }

    private static String convertDescription(String description) {
        int from = description.indexOf(40);
        int to = description.indexOf(41);
        if (from >= 0 && to > from) {
            description = description.substring(0, from) + description.substring(to + 1);
        }
        return description;
    }

    private static String[] convertSuffixes(String suffixes) {
        StringTokenizer st = new StringTokenizer(suffixes, " ");
        ArrayList<String> res = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            res.add(st.nextToken().trim());
        }
        return res.toArray(new String[res.size()]);
    }

    public static final class QtFilter
    extends Adapter {
        public QtFilter() {
            super(QtFileFilter.getInstance());
        }
    }

    public static final class ResourceFilter
    extends Adapter {
        public ResourceFilter() {
            super(ResourceFileFilter.getInstance());
        }
    }

    public static final class FortranFilter
    extends Adapter {
        public FortranFilter() {
            super(FortranSourceFileFilter.getInstance());
        }
    }

    public static final class HeaderFilter
    extends Adapter {
        public HeaderFilter() {
            super(HeaderSourceFileFilter.getInstance());
        }
    }

    public static final class CppFilter
    extends Adapter {
        public CppFilter() {
            super(CCSourceFileFilter.getInstance());
        }
    }

    public static final class CFilter
    extends Adapter {
        public CFilter() {
            super(CSourceFileFilter.getInstance());
        }
    }

    private static class Adapter
    extends OpenFileDialogFilter {
        private SourceFileFilter delegate;

        public Adapter(SourceFileFilter delegate) {
            this.delegate = delegate;
        }

        public String getDescriptionString() {
            return CndOpenFileDialogFilter.convertDescription(this.delegate.getDescription());
        }

        public boolean accept(File file) {
            return this.delegate.accept(file);
        }

        public String[] getSuffixes() {
            return CndOpenFileDialogFilter.convertSuffixes(this.delegate.getSuffixesAsString());
        }
    }
}

