/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundJarURLStreamHandler
extends URLStreamHandler {
    public static final String PROTOCOL = "compoundjar";
    private static final CompoundJarURLStreamHandler instance = new CompoundJarURLStreamHandler();

    public static URL createUrl(URL base, List<String> path2) throws MalformedURLException {
        return CompoundJarURLStreamHandler.createUrl(base, path2.toArray(new String[0]));
    }

    public static URL createUrl(URL base, String ... path2) throws MalformedURLException {
        StringBuilder pathBuilder = new StringBuilder();
        if (base.getProtocol().equals("jar")) {
            pathBuilder.append(base.getFile());
        } else {
            pathBuilder.append(base.toExternalForm());
        }
        for (String entry : path2) {
            pathBuilder.append("!");
            if (!entry.startsWith("/")) {
                pathBuilder.append("/");
            }
            pathBuilder.append(entry);
        }
        return new URL(PROTOCOL, null, -1, pathBuilder.toString(), instance);
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new CompoundJarURLConnection(url);
    }

    static class CompoundJarURLConnection
    extends URLConnection {
        private final URL baseJarUrl;
        private final String[] path;

        CompoundJarURLConnection(URL url) throws MalformedURLException {
            super(url);
            String spec = url.getPath();
            this.path = spec.split("\\!\\/");
            this.baseJarUrl = new URL(this.path[0]);
        }

        public void connect() throws IOException {
            this.connected = true;
        }

        private InputStream openEntry(String[] path2, JarInputStream currentJar, int currentDepth) throws IOException {
            String localPath = path2[currentDepth];
            JarEntry entry = currentJar.getNextJarEntry();
            while (entry != null) {
                if (entry.getName().equals(localPath)) {
                    if (currentDepth + 1 < path2.length) {
                        JarInputStream embeddedJar = new JarInputStream(currentJar);
                        return this.openEntry(path2, embeddedJar, currentDepth + 1);
                    }
                    return currentJar;
                }
                entry = currentJar.getNextJarEntry();
            }
            return null;
        }

        private static void close(Closeable resource2) {
            if (resource2 != null) {
                try {
                    resource2.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public InputStream getInputStream() throws IOException {
            InputStream result;
            InputStream baseInputStream = this.baseJarUrl.openStream();
            if (this.path.length > 1) {
                try {
                    JarInputStream baseJar = new JarInputStream(baseInputStream);
                    result = this.openEntry(this.path, baseJar, 1);
                }
                catch (IOException ex) {
                    CompoundJarURLConnection.close(baseInputStream);
                    throw ex;
                }
                catch (RuntimeException ex) {
                    CompoundJarURLConnection.close(baseInputStream);
                    throw ex;
                }
            } else {
                result = baseInputStream;
            }
            if (result == null) {
                throw new FileNotFoundException(this.url.toExternalForm());
            }
            return result;
        }
    }
}

