/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Array;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Java::JavaArray"}, parent="Java::JavaObject")
public class JavaArray
extends JavaObject {
    private JavaUtil.JavaConverter javaConverter;

    public JavaArray(Ruby runtime2, Object array) {
        super(runtime2, runtime2.getJavaSupport().getJavaArrayClass(), array);
        assert (array.getClass().isArray());
        this.javaConverter = JavaUtil.getJavaConverter(array.getClass().getComponentType());
    }

    public static RubyClass createJavaArrayClass(Ruby runtime2, RubyModule javaModule) {
        return javaModule.defineClassUnder("JavaArray", javaModule.fastGetClass("JavaObject"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
    }

    public Class getComponentType() {
        return this.getValue().getClass().getComponentType();
    }

    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.getLength());
    }

    private int getLength() {
        return Array.getLength(this.getValue());
    }

    public boolean equals(Object other) {
        return other instanceof JavaArray && this.getValue() == ((JavaArray)other).getValue();
    }

    @Deprecated
    public IRubyObject aref(IRubyObject index2) {
        if (!(index2 instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(index2, this.getRuntime().getInteger());
        }
        int intIndex = (int)((RubyInteger)index2).getLongValue();
        if (intIndex < 0 || intIndex >= this.getLength()) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + intIndex + " for length " + this.getLength() + ")");
        }
        Object result = Array.get(this.getValue(), intIndex);
        if (result == null) {
            return this.getRuntime().getNil();
        }
        return JavaObject.wrap(this.getRuntime(), result);
    }

    public IRubyObject arefDirect(int intIndex) {
        return JavaArray.arefDirect(this.getRuntime(), this.javaConverter, this.getValue(), intIndex);
    }

    public static IRubyObject arefDirect(Ruby runtime2, JavaUtil.JavaConverter converter, Object array, int intIndex) {
        int length2 = Array.getLength(array);
        if (intIndex < 0 || intIndex >= length2) {
            throw runtime2.newArgumentError("index out of bounds for java array (" + intIndex + " for length " + length2 + ")");
        }
        return JavaUtil.convertJavaArrayElementToRuby(runtime2, converter, array, intIndex);
    }

    @Deprecated
    public IRubyObject at(int index2) {
        Object result = Array.get(this.getValue(), index2);
        if (result == null) {
            return this.getRuntime().getNil();
        }
        return JavaObject.wrap(this.getRuntime(), result);
    }

    public IRubyObject aset(IRubyObject index2, IRubyObject value2) {
        if (!(index2 instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(index2, this.getRuntime().getInteger());
        }
        int intIndex = (int)((RubyInteger)index2).getLongValue();
        if (!(value2 instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + value2);
        }
        Object javaObject = ((JavaObject)value2).getValue();
        this.setWithExceptionHandling(intIndex, javaObject);
        return value2;
    }

    public void setWithExceptionHandling(int intIndex, Object javaObject) {
        try {
            Array.set(this.getValue(), intIndex, javaObject);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + intIndex + " for length " + this.getLength() + ")");
        }
        catch (ArrayStoreException e) {
            throw this.getRuntime().newTypeError("wrong element type " + javaObject.getClass() + "(array contains " + this.getValue().getClass().getComponentType().getName() + ")");
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newArgumentError("wrong element type " + javaObject.getClass() + "(array contains " + this.getValue().getClass().getComponentType().getName() + ")");
        }
    }

    public IRubyObject afill(IRubyObject beginIndex, IRubyObject endIndex, IRubyObject value2) {
        if (!(beginIndex instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(beginIndex, this.getRuntime().getInteger());
        }
        int intIndex = (int)((RubyInteger)beginIndex).getLongValue();
        if (!(endIndex instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(endIndex, this.getRuntime().getInteger());
        }
        int intEndIndex = (int)((RubyInteger)endIndex).getLongValue();
        if (!(value2 instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + value2);
        }
        Object javaObject = ((JavaObject)value2).getValue();
        this.fillWithExceptionHandling(intIndex, intEndIndex, javaObject);
        return value2;
    }

    public void fillWithExceptionHandling(int intIndex, int intEndIndex, Object javaObject) {
        try {
            while (intIndex < intEndIndex) {
                Array.set(this.getValue(), intIndex, javaObject);
                ++intIndex;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + intIndex + " for length " + this.getLength() + ")");
        }
        catch (ArrayStoreException e) {
            throw this.getRuntime().newArgumentError("wrong element type " + javaObject.getClass() + "(array is " + this.getValue().getClass() + ")");
        }
    }
}

