/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import jnr.netdb.Service;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.ext.socket.RubySocket;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"UDPSocket"}, parent="IPSocket")
public class RubyUDPSocket
extends RubyIPSocket {
    private static ObjectAllocator UDPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyUDPSocket(runtime2, klass);
        }
    };

    static void createUDPSocket(Ruby runtime2) {
        RubyClass rb_cUDPSocket = runtime2.defineClass("UDPSocket", runtime2.fastGetClass("IPSocket"), UDPSOCKET_ALLOCATOR);
        rb_cUDPSocket.includeModule(runtime2.fastGetClass("Socket").fastGetConstant("Constants"));
        rb_cUDPSocket.defineAnnotatedMethods(RubyUDPSocket.class);
        runtime2.getObject().fastSetConstant("UDPsocket", rb_cUDPSocket);
    }

    public RubyUDPSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        try {
            DatagramChannel channel = DatagramChannel.open();
            this.initSocket(context.getRuntime(), new ChannelDescriptor(channel, RubyIO.getNewFileno(), new ModeFlags(ModeFlags.RDWR), new FileDescriptor()));
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (ConnectException e) {
            throw context.getRuntime().newErrnoECONNREFUSEDError();
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(context.getRuntime(), "initialize: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(context.getRuntime(), "initialize: name or service not known");
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject protocol) {
        return this.initialize(context);
    }

    @Deprecated
    public IRubyObject bind(IRubyObject host, IRubyObject port) {
        return this.bind(this.getRuntime().getCurrentContext(), host, port);
    }

    @JRubyMethod
    public IRubyObject bind(ThreadContext context, IRubyObject host, IRubyObject port) {
        InetSocketAddress addr2 = null;
        try {
            if (host.isNil() || host instanceof RubyString && ((RubyString)host).isEmpty()) {
                addr2 = new InetSocketAddress(RubyNumeric.fix2int(port));
            } else if (host instanceof RubyFixnum) {
                RubyModule socketMod;
                int intAddr = RubyNumeric.fix2int(host);
                if (intAddr == RubyNumeric.fix2int((socketMod = context.getRuntime().getModule("Socket")).fastGetConstant("INADDR_ANY"))) {
                    addr2 = new InetSocketAddress(InetAddress.getByName("0.0.0.0"), RubyNumeric.fix2int(port));
                }
            } else {
                addr2 = new InetSocketAddress(InetAddress.getByName(host.convertToString().toString()), RubyNumeric.fix2int(port));
            }
            ((DatagramChannel)this.getChannel()).socket().bind(addr2);
            return RubyFixnum.zero(context.getRuntime());
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(context.getRuntime(), "bind: name or service not known");
        }
        catch (SocketException e) {
            throw RubyUDPSocket.sockerr(context.getRuntime(), "bind: name or service not known");
        }
        catch (Error e) {
            if (e.getCause() instanceof SocketException) {
                throw RubyUDPSocket.sockerr(context.getRuntime(), "bind: name or service not known");
            }
            throw e;
        }
    }

    @Deprecated
    public IRubyObject connect(IRubyObject host, IRubyObject port) {
        return this.connect(this.getRuntime().getCurrentContext(), host, port);
    }

    @JRubyMethod
    public IRubyObject connect(ThreadContext context, IRubyObject host, IRubyObject port) {
        try {
            InetSocketAddress addr2 = new InetSocketAddress(InetAddress.getByName(host.convertToString().toString()), RubyNumeric.fix2int(port));
            ((DatagramChannel)this.getChannel()).connect(addr2);
            return RubyFixnum.zero(context.getRuntime());
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(context.getRuntime(), "connect: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(context.getRuntime(), "connect: name or service not known");
        }
    }

    @Deprecated
    public IRubyObject recvfrom(IRubyObject[] args2) {
        return this.recvfrom(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject recvfrom(ThreadContext context, IRubyObject[] args2) {
        try {
            int length2 = RubyNumeric.fix2int(args2[0]);
            ByteBuffer buf = ByteBuffer.allocate(length2);
            ((DatagramChannel)this.getChannel()).configureBlocking(false);
            context.getThread().select(this, 1);
            InetSocketAddress sender = (InetSocketAddress)((DatagramChannel)this.getChannel()).receive(buf);
            if (sender == null) {
                throw context.getRuntime().newErrnoECONNRESETError();
            }
            RubyArray addressArray = context.getRuntime().newArray(context.getRuntime().newString("AF_INET"), context.getRuntime().newFixnum(sender.getPort()), context.getRuntime().newString(sender.getHostName()), context.getRuntime().newString(sender.getAddress().getHostAddress()));
            RubyString result = context.getRuntime().newString(new ByteList(buf.array(), 0, buf.position()));
            return context.getRuntime().newArray(new IRubyObject[]{result, addressArray});
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(context.getRuntime(), "recvfrom: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(context.getRuntime(), "recvfrom: name or service not known");
        }
    }

    public IRubyObject recv(ThreadContext context, IRubyObject[] args2) {
        try {
            int length2 = RubyNumeric.fix2int(args2[0]);
            ByteBuffer buf = ByteBuffer.allocate(length2);
            ((DatagramChannel)this.getChannel()).configureBlocking(false);
            context.getThread().select(this, 1);
            InetSocketAddress sender = (InetSocketAddress)((DatagramChannel)this.getChannel()).receive(buf);
            if (sender == null) {
                throw context.getRuntime().newErrnoECONNRESETError();
            }
            return context.getRuntime().newString(new ByteList(buf.array(), 0, buf.position()));
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(context.getRuntime(), "recv: name or service not known");
        }
    }

    @Deprecated
    public IRubyObject send(IRubyObject[] args2) {
        return this.send(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject send(ThreadContext context, IRubyObject[] args2) {
        try {
            int written;
            if (args2.length >= 3) {
                Service service;
                RubyString nameStr = args2[2].convertToString();
                RubyString data = args2[0].convertToString();
                ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
                int port = args2[3] instanceof RubyString ? ((service = Service.getServiceByName(args2[3].asJavaString(), "udp")) != null ? service.getPort() : (int)args2[3].convertToInteger("to_i").getLongValue()) : (int)args2[3].convertToInteger().getLongValue();
                InetAddress address2 = RubySocket.getRubyInetAddress(nameStr.getByteList());
                InetSocketAddress addr2 = new InetSocketAddress(address2, port);
                written = ((DatagramChannel)this.getChannel()).send(buf, addr2);
            } else {
                RubyString data = args2[0].convertToString();
                ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
                written = ((DatagramChannel)this.getChannel()).write(buf);
            }
            return context.getRuntime().newFixnum(written);
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(context.getRuntime(), "send: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(context.getRuntime(), "send: name or service not known");
        }
    }

    @Deprecated
    public static IRubyObject open(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyUDPSocket.open(recv2.getRuntime().getCurrentContext(), recv2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true, frame=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyUDPSocket sock = (RubyUDPSocket)recv2.callMethod(context, "new", args2);
        if (!block.isGiven()) {
            return sock;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, sock);
            return iRubyObject;
        }
        finally {
            if (sock.openFile.isOpen()) {
                sock.close();
            }
        }
    }
}

