/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::AbstractInvoker"}, parent="Object")
public abstract class AbstractInvoker
extends Pointer {
    static final String CLASS_NAME = "AbstractInvoker";
    private static final Map<DynamicMethod, AbstractInvoker> refmap = Collections.synchronizedMap(new WeakHashMap());
    protected final Arity arity;

    public static RubyClass createAbstractInvokerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder(CLASS_NAME, module.fastGetClass("Pointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(AbstractInvoker.class);
        result.defineAnnotatedConstants(AbstractInvoker.class);
        return result;
    }

    protected AbstractInvoker(Ruby runtime2, RubyClass klass, int arity2, DirectMemoryIO io2) {
        super(runtime2, klass, io2, 0L);
        this.arity = Arity.fixed(arity2);
    }

    @JRubyMethod(name={"attach"})
    public IRubyObject attach(ThreadContext context, IRubyObject obj, IRubyObject methodName) {
        DynamicMethod m = this.createDynamicMethod(obj.getSingletonClass());
        obj.getSingletonClass().addMethod(methodName.asJavaString(), m);
        if (obj instanceof RubyModule) {
            ((RubyModule)obj).addMethod(methodName.asJavaString(), m);
        }
        refmap.put(m, this);
        return this;
    }

    protected abstract DynamicMethod createDynamicMethod(RubyModule var1);

    public final Arity getArity() {
        return this.arity;
    }
}

