/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.compiler.ir.IR_Class;
import org.jruby.compiler.ir.operands.KeyValuePair;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hash
extends Operand {
    public final List<KeyValuePair> _pairs;

    public Hash(List<KeyValuePair> pairs) {
        this._pairs = pairs;
    }

    public boolean isBlank() {
        return this._pairs == null || this._pairs.size() == 0;
    }

    @Override
    public boolean isConstant() {
        for (KeyValuePair kp : this._pairs) {
            if (kp._key.isConstant() && kp._value.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNonAtomicValue() {
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap) {
        int i = 0;
        for (KeyValuePair kv : this._pairs) {
            kv._key = kv._key.getSimplifiedOperand(valueMap);
            kv._value = kv._value.getSimplifiedOperand(valueMap);
            ++i;
        }
        return this;
    }

    @Override
    public IR_Class getTargetClass() {
        return IR_Class.getCoreClass("Hash");
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (KeyValuePair kv : this._pairs) {
            kv._key.addUsedVariables(l);
            kv._value.addUsedVariables(l);
        }
    }
}

