/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import org.jruby.compiler.ir.IR_Class;
import org.jruby.compiler.ir.operands.Constant;
import org.jruby.compiler.ir.operands.Fixnum;
import org.jruby.compiler.ir.operands.Nil;
import org.jruby.compiler.ir.operands.Operand;

public class Float
extends Constant {
    public final Double _value;

    public Float(Double val) {
        this._value = val;
    }

    public String toString() {
        return this._value + ":float";
    }

    public Operand fetchCompileTimeArrayElement(int argIndex, boolean getSubArray) {
        return argIndex == 0 ? this : Nil.NIL;
    }

    public IR_Class getTargetClass() {
        return IR_Class.getCoreClass("Float");
    }

    public Constant computeValue(String methodName, Constant arg2) {
        Double v1 = this._value;
        Double v2 = arg2 instanceof Fixnum ? 1.0 * (double)((Fixnum)arg2)._value.longValue() : ((Float)arg2)._value;
        if (methodName.equals("+")) {
            return new Float(v1 + v2);
        }
        if (methodName.equals("-")) {
            return new Float(v1 - v2);
        }
        if (methodName.equals("*")) {
            return new Float(v1 * v2);
        }
        if (methodName.equals("/")) {
            return v2 == 0.0 ? null : new Float(v1 / v2);
        }
        return null;
    }
}

