/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow.analyses;

import java.util.HashSet;
import java.util.Set;
import org.jruby.compiler.ir.IR_Closure;
import org.jruby.compiler.ir.dataflow.DataFlowConstants;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.dataflow.FlowGraphNode;
import org.jruby.compiler.ir.dataflow.analyses.FrameLoadPlacementNode;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameLoadPlacementProblem
extends DataFlowProblem {
    private Set<Variable> _initLoadsOnExit = new HashSet<Variable>();
    private Set<Variable> _defVars = new HashSet<Variable>();
    private Set<Variable> _usedVars = new HashSet<Variable>();

    public FrameLoadPlacementProblem() {
        super(DataFlowProblem.DF_Direction.BACKWARD);
    }

    @Override
    public String getName() {
        return "Frame Loads Placement Analysis";
    }

    @Override
    public FlowGraphNode buildFlowGraphNode(BasicBlock bb) {
        return new FrameLoadPlacementNode(this, bb);
    }

    @Override
    public String getDataFlowVarsForOutput() {
        return "";
    }

    public void initLoadsOnScopeExit(Set<Variable> loads) {
        this._initLoadsOnExit = loads;
    }

    public Set<Variable> getLoadsOnScopeExit() {
        return this._initLoadsOnExit;
    }

    public void recordDefVar(Variable v) {
        this._defVars.add(v);
    }

    public void recordUsedVar(Variable v) {
        this._usedVars.add(v);
    }

    public boolean scopeDefinesVariable(Variable v) {
        if (this._defVars.contains(v)) {
            return true;
        }
        for (IR_Closure cl : this.getCFG().getScope().getClosures()) {
            FrameLoadPlacementProblem nestedProblem = (FrameLoadPlacementProblem)cl.getCFG().getDataFlowSolution(DataFlowConstants.FLP_NAME);
            if (!nestedProblem.scopeDefinesVariable(v)) continue;
            return true;
        }
        return false;
    }

    public boolean scopeUsesVariable(Variable v) {
        if (this._usedVars.contains(v)) {
            return true;
        }
        for (IR_Closure cl : this.getCFG().getScope().getClosures()) {
            FrameLoadPlacementProblem nestedProblem = (FrameLoadPlacementProblem)cl.getCFG().getDataFlowSolution(DataFlowConstants.FLP_NAME);
            if (!nestedProblem.scopeUsesVariable(v)) continue;
            return true;
        }
        return false;
    }

    public void addLoads() {
        for (FlowGraphNode n : this._fgNodes) {
            FrameLoadPlacementNode flpn = (FrameLoadPlacementNode)n;
            flpn.addLoads();
        }
    }
}

