/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrNode
extends Node
implements ILiteralNode {
    private final ByteList value;

    public StrNode(ISourcePosition position, ByteList value2) {
        super(position);
        this.value = value2;
    }

    public StrNode(ISourcePosition position, StrNode head, StrNode tail) {
        super(position);
        ByteList headBL = head.getValue();
        ByteList tailBL = tail.getValue();
        ByteList myValue = new ByteList(headBL.getRealSize() + tailBL.getRealSize());
        myValue.append(headBL);
        myValue.append(tailBL);
        this.value = myValue;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.STRNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitStrNode(this);
    }

    public ByteList getValue() {
        return this.value;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return RubyString.newStringShared(runtime2, this.value);
    }
}

