/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.unsafe.UnsafeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RescueNode
extends Node {
    private final Node bodyNode;
    private final RescueBodyNode rescueNode;
    private final Node elseNode;

    public RescueNode(ISourcePosition position, Node bodyNode, RescueBodyNode rescueNode, Node elseNode) {
        super(position);
        this.bodyNode = bodyNode;
        this.rescueNode = rescueNode;
        this.elseNode = elseNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.RESCUENODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitRescueNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getElseNode() {
        return this.elseNode;
    }

    public RescueBodyNode getRescueNode() {
        return this.rescueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.rescueNode, this.bodyNode, this.elseNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return this.interpretWithJavaExceptions(runtime2, context, self, aBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject interpretWithJavaExceptions(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        while (true) {
            IRubyObject globalExceptionState = runtime2.getGlobalVariables().get("$!");
            boolean anotherExceptionRaised = false;
            try {
                IRubyObject iRubyObject = this.executeBody(runtime2, context, self, aBlock);
                return iRubyObject;
            }
            catch (RaiseException raiseJump) {
                try {
                    IRubyObject iRubyObject = this.handleException(runtime2, context, self, aBlock, raiseJump);
                    return iRubyObject;
                }
                catch (JumpException.RetryJump rj) {
                    continue;
                }
                catch (RaiseException je) {
                    anotherExceptionRaised = true;
                    throw je;
                }
            }
            catch (JumpException.FlowControlException flow) {
                throw flow;
            }
            catch (Throwable t) {
                if (t instanceof Unrescuable) {
                    UnsafeFactory.getUnsafe().throwException(t);
                }
                try {
                    IRubyObject je = this.handleJavaException(runtime2, context, self, aBlock, t);
                    return je;
                }
                catch (JumpException.RetryJump rj) {
                    continue;
                }
                catch (RaiseException je) {
                    anotherExceptionRaised = true;
                    throw je;
                }
            }
            finally {
                if (anotherExceptionRaised) continue;
                runtime2.getGlobalVariables().set("$!", globalExceptionState);
                continue;
            }
            break;
        }
    }

    private IRubyObject handleException(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock, RaiseException raiseJump) {
        RubyException raisedException = raiseJump.getException();
        runtime2.getGlobalVariables().set("$!", raisedException);
        for (RescueBodyNode cRescueNode = this.rescueNode; cRescueNode != null; cRescueNode = cRescueNode.getOptRescueNode()) {
            IRubyObject[] exceptions = this.getExceptions(cRescueNode, runtime2, context, self, aBlock);
            if (!RuntimeHelpers.isExceptionHandled(raisedException, exceptions, context).isTrue()) continue;
            return cRescueNode.interpret(runtime2, context, self, aBlock);
        }
        throw raiseJump;
    }

    private IRubyObject handleJavaException(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock, Throwable throwable) {
        for (RescueBodyNode cRescueNode = this.rescueNode; cRescueNode != null; cRescueNode = cRescueNode.getOptRescueNode()) {
            IRubyObject[] exceptions = this.getExceptions(cRescueNode, runtime2, context, self, aBlock);
            if (!RuntimeHelpers.isJavaExceptionHandled(throwable, exceptions, context).isTrue()) continue;
            runtime2.getGlobalVariables().set("$!", JavaUtil.convertJavaToUsableRubyObject(runtime2, throwable));
            return cRescueNode.interpret(runtime2, context, self, aBlock);
        }
        UnsafeFactory.getUnsafe().throwException(throwable);
        throw new RuntimeException("Unsafe.throwException failed");
    }

    private IRubyObject executeBody(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.bodyNode == null) {
            return runtime2.getNil();
        }
        IRubyObject result = this.bodyNode.interpret(runtime2, context, self, aBlock);
        if (this.elseNode != null) {
            if (this.rescueNode == null) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.ELSE_WITHOUT_RESCUE, this.elseNode.getPosition(), "else without rescue is useless", new Object[0]);
            }
            result = this.elseNode.interpret(runtime2, context, self, aBlock);
        }
        return result;
    }

    private IRubyObject[] getExceptions(RescueBodyNode cRescueNode, Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        Node exceptionNodes = cRescueNode.getExceptionNodes();
        IRubyObject[] exceptions = exceptionNodes == null ? new IRubyObject[]{runtime2.getStandardError()} : ASTInterpreter.setupArgs(runtime2, context, exceptionNodes, self, aBlock);
        return exceptions;
    }
}

