/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.view.widget.HotKeyAction;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;

public class ButtonWidget
extends ImageLabelWidget
implements PropertyChangeListener {
    private Action action;
    private char mnemonics_key = (char)65535;
    private HotKeyAction mnemAction;
    public static int BORDER_RADIUS = 3;
    private Object key = new Object();
    private Object selectedImage;
    private boolean selected;
    protected static final Color BORDER_COLOR = new Color(8363449);
    private static final Color HOVER_COLOR = new Color(0xFF9900);
    private static final Color BACKGROUND_COLOR_1 = new Color(0xD2D2DD);
    private static final Color BACKGROUND_COLOR_2 = new Color(0xF8F8F8);
    private static final Color BACKGROUND_COLOR_PRESSED = new Color(0xCCCCCC);
    private static final Color BACKGROUND_COLOR_DISABLED = new Color(0xE4E4E4);

    public ButtonWidget(Scene scene, String text) {
        this(scene, null, text);
    }

    public ButtonWidget(Scene scene, Image image) {
        this(scene, image, null);
    }

    public ButtonWidget(Scene scene, Image image, String text) {
        super(scene, image, text);
        this.setRoundedBorder(BORDER_RADIUS, 0, 0, null);
        this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)ButtonSelectProvider.DEFAULT));
        this.getActions().addAction(scene.createWidgetHoverAction());
    }

    public ButtonWidget(Scene scene, Action action) {
        this(scene, null, ButtonWidget.getActionName(action));
        this.setAction(action);
        this.setToolTipText(ButtonWidget.getActionTooltip(action));
        this.setMnemonics(ButtonWidget.getActionMnemonics(action));
    }

    public void setRoundedBorder(int radius, int hgap, int vgap, Color borderColor) {
        this.setBorder(new ButtonBorder(this, new Insets(radius + vgap, radius + hgap, radius + vgap, radius + hgap), radius, borderColor));
    }

    public void setAction(Action action) {
        if (this.action != null) {
            this.action.removePropertyChangeListener(this);
        }
        this.action = action;
        if (this.action != null) {
            this.action.addPropertyChangeListener(this);
            this.setButtonEnabled(action.isEnabled());
        }
    }

    public void setMnemonics(char c) {
        this.mnemonics_key = Character.toUpperCase(c);
        if (this.mnemonics_key != '\uffff' && this.mnemAction == null) {
            this.mnemAction = new HotKeyAction(new ButtonHotKeyProvider(this));
            this.getScene().getActions().addAction((WidgetAction)this.mnemAction);
        }
    }

    public char getMnemonics() {
        return this.mnemonics_key;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.action && "enabled".equals(evt.getPropertyName())) {
            this.setButtonEnabled((Boolean)evt.getNewValue());
        }
    }

    public void setButtonEnabled(boolean v) {
        this.setEnabled(v);
        this.setPaintAsDisabled(!v);
        this.revalidate(true);
    }

    public boolean isButtonEnabled() {
        return this.isEnabled();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean flag) {
        if (this.selected != flag) {
            this.selected = flag;
            if (this.selectedImage != null) {
                this.setImage(this.selectedImage);
            }
            this.revalidate(true);
        }
    }

    public final void setImage(Object image) {
        this.selectedImage = this.getImage();
        if (this.selectedImage == null) {
            this.selectedImage = this.getImageWidget();
        }
        if (image instanceof Image) {
            super.setImage((Image)image);
        }
        if (image instanceof Widget) {
            super.setImage((Widget)image);
        }
    }

    public final void setSelectedImage(Object selectedImage) {
        this.selectedImage = selectedImage;
    }

    public void performAction() {
        if (this.isButtonEnabled() && this.action != null) {
            this.action.actionPerformed(new ActionEvent(this, 0, this.getActionCommand()));
        }
    }

    public String getActionCommand() {
        return (String)this.action.getValue("ActionCommandKey");
    }

    @Override
    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        if (previousState.isWidgetAimed() != state.isWidgetAimed() || previousState.isWidgetHovered() != state.isWidgetHovered() || previousState.isFocused() != state.isFocused()) {
            this.revalidate(true);
        }
    }

    protected boolean isAimingAllowed() {
        return true;
    }

    protected Object hashKey() {
        return this.key;
    }

    protected void notifyAdded() {
        super.notifyAdded();
        Scene scene = this.getScene();
        if (scene instanceof ObjectScene) {
            ObjectScene objectScene = (ObjectScene)scene;
            objectScene.addObject(this.hashKey(), new Widget[]{this});
        }
    }

    protected void notifyRemoved() {
        super.notifyRemoved();
        Scene scene = this.getScene();
        if (scene instanceof ObjectScene) {
            ((ObjectScene)scene).removeObject(this.hashKey());
        }
    }

    private static String getActionName(Action action) {
        return (String)action.getValue("Name");
    }

    private static Image getActionIcon(Action action) {
        Object icon = action.getValue("SmallIcon");
        return icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : null;
    }

    private static String getActionTooltip(Action action) {
        return (String)action.getValue("ShortDescription");
    }

    private static char getActionMnemonics(Action action) {
        String name = ButtonWidget.getActionName(action);
        if (name == null) {
            return '\uffff';
        }
        Integer mKey = (Integer)action.getValue("MnemonicKey");
        if (mKey == null) {
            return '\uffff';
        }
        if (mKey < 0 || name.length() < mKey) {
            return '\uffff';
        }
        return name.charAt(mKey);
    }

    private static Color grayFilter(Color color) {
        int y = Math.round(0.299f * (float)color.getRed() + 0.587f * (float)color.getGreen() + 0.114f * (float)color.getBlue());
        if (y < 0) {
            y = 0;
        } else if (y > 255) {
            y = 255;
        }
        return new Color(y, y, y);
    }

    public static final class ButtonHotKeyProvider
    implements HotKeyAction.HotKeyProvider {
        private ButtonWidget widget;

        public ButtonHotKeyProvider(ButtonWidget widget) {
            this.widget = widget;
        }

        @Override
        public boolean processHotKey(Widget w, char mnemonics) {
            if (this.widget.isVisible() && this.widget.getMnemonics() == mnemonics) {
                this.widget.performAction();
                return true;
            }
            return false;
        }
    }

    private static final class ButtonSelectProvider
    implements SelectProvider {
        public static ButtonSelectProvider DEFAULT = new ButtonSelectProvider();

        public boolean isAimingAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return widget instanceof ButtonWidget && ((ButtonWidget)widget).isAimingAllowed() && widget.isHitAt(localLocation);
        }

        public boolean isSelectionAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return widget instanceof ButtonWidget && widget.isHitAt(localLocation);
        }

        public void select(Widget widget, Point localLocation, boolean invertSelection) {
            if (widget instanceof ButtonWidget) {
                ((ButtonWidget)widget).performAction();
            }
        }
    }

    protected static class ButtonBorder
    implements Border {
        private ButtonWidget button;
        private Color borderColor;
        private Insets insets;
        private int radius;

        public ButtonBorder(ButtonWidget button, Insets insets, int radius, Color borderColor) {
            this.button = button;
            this.insets = insets;
            this.radius = radius;
            this.borderColor = borderColor != null ? borderColor : BORDER_COLOR;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public void paint(Graphics2D g2, Rectangle rect) {
            Paint oldPaint = g2.getPaint();
            RoundRectangle2D.Double buttonRect = new RoundRectangle2D.Double((float)rect.x + 0.5f, (float)rect.y + 0.5f, (float)rect.width - 1.0f, (float)rect.height - 1.0f, this.radius * 2, this.radius * 2);
            if (this.button.isButtonEnabled()) {
                if (this.button.isOpaque()) {
                    g2.setPaint(this.button.isSelected() ? BACKGROUND_COLOR_PRESSED : new GradientPaint(0.0f, rect.y, BACKGROUND_COLOR_1, 0.0f, (float)rect.y + (float)rect.height * 0.5f, BACKGROUND_COLOR_2, true));
                    g2.fill(buttonRect);
                }
                if (this.button.getState().isWidgetAimed()) {
                    g2.setPaint(BACKGROUND_COLOR_PRESSED);
                    g2.fill(buttonRect);
                } else {
                    Area s = new Area(buttonRect);
                    Area inner = new Area(new RoundRectangle2D.Double((float)rect.x + 2.5f, (float)rect.y + 2.5f, (float)rect.width - 5.0f, (float)rect.height - 5.0f, this.radius * 2, this.radius * 2));
                    s.subtract(inner);
                    if (this.button.getState().isHovered()) {
                        g2.setPaint(HOVER_COLOR);
                        g2.fill(s);
                    } else if (this.button.getState().isFocused()) {
                        g2.setPaint(BORDER_COLOR);
                        g2.fill(s);
                    }
                }
                g2.setPaint(BORDER_COLOR);
                g2.draw(buttonRect);
            } else {
                if (this.button.isOpaque()) {
                    g2.setPaint(BACKGROUND_COLOR_DISABLED);
                    g2.fill(buttonRect);
                }
                g2.setPaint(ButtonWidget.grayFilter(BORDER_COLOR));
                g2.draw(buttonRect);
            }
            g2.setPaint(oldPaint);
        }

        public boolean isOpaque() {
            return false;
        }
    }
}

