/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;
import org.netbeans.api.diff.PatchUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.issuetable.ColumnDescriptor;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugtracking.issuetable.IssueTable;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.TextUtils;
import org.netbeans.modules.bugtracking.util.UIUtils;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.commands.AddAttachmentCommand;
import org.netbeans.modules.bugzilla.commands.GetAttachmentCommand;
import org.netbeans.modules.bugzilla.commands.SubmitCommand;
import org.netbeans.modules.bugzilla.issue.AttachmentsPanel;
import org.netbeans.modules.bugzilla.issue.BugzillaIssueNode;
import org.netbeans.modules.bugzilla.issue.IssueController;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.IssueField;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BugzillaIssue
extends Issue
implements IssueTable.NodeProvider {
    public static final String RESOLVE_FIXED = "FIXED";
    public static final String RESOLVE_DUPLICATE = "DUPLICATE";
    public static final String VCSHOOK_BUGZILLA_FIELD = "netbeans.vcshook.bugzilla.";
    private static final SimpleDateFormat CC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final SimpleDateFormat MODIFIED_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat CREATED_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final int SHORTENED_SUMMARY_LENGTH = 22;
    private TaskData data;
    private BugzillaRepository repository;
    private IssueController controller;
    private IssueNode node;
    static final String LABEL_NAME_ID = "bugzilla.issue.id";
    static final String LABEL_NAME_SEVERITY = "bugzilla.issue.severity";
    static final String LABEL_NAME_ISSUE_TYPE = "bugzilla.issue.issue_type";
    static final String LABEL_NAME_PRIORITY = "bugzilla.issue.priority";
    static final String LABEL_NAME_STATUS = "bugzilla.issue.status";
    static final String LABEL_NAME_RESOLUTION = "bugzilla.issue.resolution";
    static final String LABEL_NAME_ASSIGNED_TO = "bugzilla.issue.assigned";
    static final String LABEL_NAME_PRODUCT = "bugzilla.issue.product";
    static final String LABEL_NAME_COMPONENT = "bugzilla.issue.component";
    static final String LABEL_NAME_VERSION = "bugzilla.issue.version";
    static final String LABEL_NAME_OS = "bugzilla.issue.os";
    static final String LABEL_NAME_PLATFORM = "bugzilla.issue.platform";
    static final String LABEL_NAME_MILESTONE = "bugzilla.issue.milestone";
    static final String LABEL_NAME_REPORTER = "bugzilla.issue.reporter";
    static final String LABEL_NAME_MODIFICATION = "bugzilla.issue.modified";
    static final String LABEL_NAME_QA_CONTACT = "bugzilla.issue.qa_contact";
    static final String LABEL_NAME_KEYWORDS = "bugzilla.issue.keywords";
    static final String LABEL_NAME_WHITEBOARD = "bugzilla.issue.whiteboard";
    static final int FIELD_STATUS_IRELEVANT = -1;
    static final int FIELD_STATUS_UPTODATE = 1;
    static final int FIELD_STATUS_NEW = 2;
    static final int FIELD_STATUS_MODIFIED = 4;
    private Map<String, String> seenAtributes;
    private String initialProduct = null;
    private Map<String, String> attributes;
    private Map<String, TaskOperation> availableOperations;

    public BugzillaIssue(TaskData data, BugzillaRepository repo) {
        super((Repository)repo);
        this.data = data;
        this.repository = repo;
    }

    public boolean isNew() {
        return this.data == null || this.data.isNew();
    }

    void opened() {
        String refresh;
        if (Bugzilla.LOG.isLoggable(Level.FINE)) {
            Bugzilla.LOG.log(Level.FINE, "issue {0} open start", new Object[]{this.getID()});
        }
        if (!this.data.isNew()) {
            this.seenAtributes = this.repository.getIssueCache().getSeenAttributes(this.getID());
        }
        if ((refresh = System.getProperty("org.netbeans.modules.bugzilla.noIssueRefresh")) != null && refresh.equals("true")) {
            return;
        }
        this.repository.scheduleForRefresh(this.getID());
        if (Bugzilla.LOG.isLoggable(Level.FINE)) {
            Bugzilla.LOG.log(Level.FINE, "issue {0} open finish", new Object[]{this.getID()});
        }
    }

    void closed() {
        if (Bugzilla.LOG.isLoggable(Level.FINE)) {
            Bugzilla.LOG.log(Level.FINE, "issue {0} close start", new Object[]{this.getID()});
        }
        this.repository.stopRefreshing(this.getID());
        this.seenAtributes = null;
        if (Bugzilla.LOG.isLoggable(Level.FINE)) {
            Bugzilla.LOG.log(Level.FINE, "issue {0} close finish", new Object[]{this.getID()});
        }
    }

    public String getDisplayName() {
        return BugzillaIssue.getDisplayName(this.data);
    }

    public static String getDisplayName(TaskData taskData) {
        return taskData.isNew() ? NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_NewIssue") : NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue", (Object[])new Object[]{BugzillaIssue.getID(taskData), BugzillaIssue.getSummary(taskData)});
    }

    public String getShortenedDisplayName() {
        if (this.data.isNew()) {
            return this.getDisplayName();
        }
        String shortSummary = TextUtils.shortenText((String)this.getSummary(), (int)2, (int)22);
        return NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue", (Object[])new Object[]{this.getID(), shortSummary});
    }

    public String getTooltip() {
        return this.getDisplayName();
    }

    public static ColumnDescriptor[] getColumnDescriptors(BugzillaRepository repository) {
        ResourceBundle loc = NbBundle.getBundle(BugzillaIssue.class);
        JTable t = new JTable();
        LinkedList<ColumnDescriptor> ret = new LinkedList<ColumnDescriptor>();
        ret.add(new ColumnDescriptor(LABEL_NAME_ID, String.class, loc.getString("CTL_Issue_ID_Title"), loc.getString("CTL_Issue_ID_Desc"), UIUtils.getColumnWidthInPixels((int)6, (JComponent)t)));
        ret.add(new ColumnDescriptor("issue.summary", String.class, loc.getString("CTL_Issue_Summary_Title"), loc.getString("CTL_Issue_Summary_Desc")));
        ret.add(BugzillaUtil.isNbRepository(repository) ? new ColumnDescriptor(LABEL_NAME_ISSUE_TYPE, String.class, loc.getString("CTL_Issue_Issue_Type_Title"), loc.getString("CTL_Issue_Issue_Type_Desc"), 0) : new ColumnDescriptor(LABEL_NAME_SEVERITY, String.class, loc.getString("CTL_Issue_Severity_Title"), loc.getString("CTL_Issue_Severity_Desc"), 0));
        ret.add(new ColumnDescriptor(LABEL_NAME_PRIORITY, String.class, loc.getString("CTL_Issue_Priority_Title"), loc.getString("CTL_Issue_Priority_Desc"), 0));
        ret.add(new ColumnDescriptor(LABEL_NAME_STATUS, String.class, loc.getString("CTL_Issue_Status_Title"), loc.getString("CTL_Issue_Status_Desc"), 0));
        ret.add(new ColumnDescriptor(LABEL_NAME_RESOLUTION, String.class, loc.getString("CTL_Issue_Resolution_Title"), loc.getString("CTL_Issue_Resolution_Desc"), 0));
        ret.add(new ColumnDescriptor(LABEL_NAME_ASSIGNED_TO, String.class, loc.getString("CTL_Issue_Assigned_Title"), loc.getString("CTL_Issue_Assigned_Desc"), 0));
        ret.add(new ColumnDescriptor(LABEL_NAME_PRODUCT, String.class, loc.getString("CTL_Issue_Product_Title"), loc.getString("CTL_Issue_Product_Desc"), 0, false));
        ret.add(new ColumnDescriptor(LABEL_NAME_COMPONENT, String.class, loc.getString("CTL_Issue_Component_Title"), loc.getString("CTL_Issue_Component_Desc"), 0, false));
        ret.add(new ColumnDescriptor(LABEL_NAME_VERSION, String.class, loc.getString("CTL_Issue_Version_Title"), loc.getString("CTL_Issue_Version_Desc"), 0, false));
        ret.add(new ColumnDescriptor(LABEL_NAME_OS, String.class, loc.getString("CTL_Issue_OS_Title"), loc.getString("CTL_Issue_OS_Desc"), 0, false));
        ret.add(new ColumnDescriptor(LABEL_NAME_PLATFORM, String.class, loc.getString("CTL_Issue_Platform_Title"), loc.getString("CTL_Issue_Platform_Desc"), 0, false));
        ret.add(new ColumnDescriptor(LABEL_NAME_MILESTONE, String.class, loc.getString("CTL_Issue_Milestone_Title"), loc.getString("CTL_Issue_Milestone_Desc"), 0, false));
        ret.add(new ColumnDescriptor(LABEL_NAME_REPORTER, String.class, loc.getString("CTL_Issue_Reporter_Title"), loc.getString("CTL_Issue_Reporter_Desc"), 0, false));
        ret.add(new ColumnDescriptor(LABEL_NAME_MODIFICATION, String.class, loc.getString("CTL_Issue_Modification_Title"), loc.getString("CTL_Issue_Modification_Desc"), 0, false));
        if (BugzillaUtil.showQAContact(repository)) {
            ret.add(new ColumnDescriptor(LABEL_NAME_QA_CONTACT, String.class, loc.getString("CTL_Issue_QA_Contact_Title"), loc.getString("CTL_Issue_QA_Contact_Desc"), 0, false));
        }
        ret.add(new ColumnDescriptor(LABEL_NAME_KEYWORDS, String.class, loc.getString("CTL_Issue_Keywords_Title"), loc.getString("CTL_Issue_Keywords_Desc"), 0, false));
        if (BugzillaUtil.showStatusWhiteboard(repository)) {
            ret.add(new ColumnDescriptor(LABEL_NAME_WHITEBOARD, String.class, loc.getString("CTL_Issue_Whiteboard_Title"), loc.getString("CTL_Issue_Whiteboard_Desc"), 0, false));
        }
        return ret.toArray(new ColumnDescriptor[ret.size()]);
    }

    public BugtrackingController getController() {
        if (this.controller == null) {
            this.controller = new IssueController(this);
        }
        return this.controller;
    }

    public String toString() {
        String str = this.getID() + " : " + this.getSummary();
        return str;
    }

    public IssueNode getNode() {
        if (this.node == null) {
            this.node = this.createNode();
        }
        return this.node;
    }

    public Node[] getSelection() {
        return super.getSelection();
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
            for (IssueField field : this.getBugzillaRepository().getConfiguration().getFields()) {
                String value = this.getFieldValue(field);
                if (value == null || value.trim().equals("")) continue;
                this.attributes.put(field.getKey(), value);
            }
        }
        return this.attributes;
    }

    public void setSeen(boolean seen) throws IOException {
        IssueCacheUtils.setSeen((Issue)this, (boolean)seen);
    }

    private boolean wasSeen() {
        return IssueCacheUtils.wasSeen((Issue)this);
    }

    public Date getLastModifyDate() {
        String value = this.getFieldValue(IssueField.MODIFICATION);
        if (value != null && !value.equals("")) {
            try {
                return MODIFIED_DATE_FORMAT.parse(value);
            }
            catch (ParseException ex) {
                Bugzilla.LOG.log(Level.WARNING, null, ex);
            }
        }
        return null;
    }

    public long getLastModify() {
        Date lastModifyDate = this.getLastModifyDate();
        if (lastModifyDate != null) {
            return lastModifyDate.getTime();
        }
        return -1L;
    }

    public Date getCreatedDate() {
        String value = this.getFieldValue(IssueField.CREATION);
        if (value != null && !value.equals("")) {
            try {
                return CREATED_DATE_FORMAT.parse(value);
            }
            catch (ParseException ex) {
                Bugzilla.LOG.log(Level.WARNING, null, ex);
            }
        }
        return null;
    }

    public long getCreated() {
        Date createdDate = this.getCreatedDate();
        if (createdDate != null) {
            return createdDate.getTime();
        }
        return -1L;
    }

    public String getRecentChanges() {
        if (this.wasSeen()) {
            return "";
        }
        int status = this.repository.getIssueCache().getStatus(this.getID());
        if (status == 4) {
            return NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_NEW_STATUS");
        }
        if (status == 8) {
            String ret;
            ArrayList<IssueField> changedFields = new ArrayList<IssueField>();
            assert (this.getSeenAttributes() != null);
            for (IssueField f : this.getBugzillaRepository().getConfiguration().getFields()) {
                if (f == IssueField.MODIFICATION || f == IssueField.REPORTER_NAME || f == IssueField.QA_CONTACT_NAME || f == IssueField.ASSIGNED_TO_NAME) continue;
                String value = this.getFieldValue(f);
                String seenValue = this.getSeenValue(f);
                if (value.trim().equals(seenValue)) continue;
                changedFields.add(f);
            }
            int changedCount = changedFields.size();
            if (changedCount == 1) {
                ret = null;
                for (IssueField changedField : changedFields) {
                    if (changedField == IssueField.SUMMARY) {
                        ret = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_SUMMARY_CHANGED_STATUS");
                        continue;
                    }
                    if (changedField == IssueField.CC) {
                        ret = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CC_FIELD_CHANGED_STATUS");
                        continue;
                    }
                    if (changedField == IssueField.KEYWORDS) {
                        ret = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_KEYWORDS_CHANGED_STATUS");
                        continue;
                    }
                    if (changedField == IssueField.DEPENDS_ON || changedField == IssueField.BLOCKS) {
                        ret = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_DEPENDENCE_CHANGED_STATUS");
                        continue;
                    }
                    if (changedField == IssueField.COMMENT_COUNT) {
                        String value = this.getFieldValue(changedField);
                        String seenValue = this.getSeenValue(changedField);
                        if (seenValue.equals("")) {
                            seenValue = "0";
                        }
                        int count = 0;
                        try {
                            count = Integer.parseInt(value) - Integer.parseInt(seenValue);
                        }
                        catch (NumberFormatException ex) {
                            Bugzilla.LOG.log(Level.WARNING, ret, ex);
                        }
                        ret = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_COMMENTS_CHANGED", (Object[])new Object[]{count});
                        continue;
                    }
                    if (changedField == IssueField.ATTACHEMENT_COUNT) {
                        ret = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_ATTACHMENTS_CHANGED");
                        continue;
                    }
                    ret = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGED_TO", (Object[])new Object[]{changedField.getDisplayName(), this.getFieldValue(changedField)});
                }
                return ret;
            }
            ret = null;
            Iterator i$ = changedFields.iterator();
            if (i$.hasNext()) {
                IssueField changedField;
                changedField = (IssueField)i$.next();
                String key = changedField == IssueField.SUMMARY ? "LBL_CHANGES_INCL_SUMMARY" : (changedField == IssueField.PRIORITY ? "LBL_CHANGES_INCL_PRIORITY" : (changedField == IssueField.SEVERITY ? "LBL_CHANGES_INCL_SEVERITY" : (changedField == IssueField.ISSUE_TYPE ? "LBL_CHANGES_INCL_ISSUE_TYPE" : (changedField == IssueField.PRODUCT ? "LBL_CHANGES_INCL_PRODUCT" : (changedField == IssueField.COMPONENT ? "LBL_CHANGES_INCL_COMPONENT" : (changedField == IssueField.PLATFORM ? "LBL_CHANGES_INCL_PLATFORM" : (changedField == IssueField.VERSION ? "LBL_CHANGES_INCL_VERSION" : (changedField == IssueField.MILESTONE ? "LBL_CHANGES_INCL_MILESTONE" : (changedField == IssueField.KEYWORDS ? "LBL_CHANGES_INCL_KEYWORDS" : (changedField == IssueField.URL ? "LBL_CHANGES_INCL_URL" : (changedField == IssueField.ASSIGNED_TO ? "LBL_CHANGES_INCL_ASSIGNEE" : (changedField == IssueField.QA_CONTACT ? "LBL_CHANGES_INCL_QA_CONTACT" : (changedField == IssueField.DEPENDS_ON || changedField == IssueField.BLOCKS ? "LBL_CHANGES_INCLUSIVE_DEPENDENCE" : "LBL_CHANGES")))))))))))));
                return NbBundle.getMessage(BugzillaIssue.class, (String)key, (Object[])new Object[]{changedCount});
            }
        }
        return "";
    }

    public static String getID(TaskData taskData) {
        if (taskData.isNew()) {
            return null;
        }
        return taskData.getTaskId();
    }

    public static String getSummary(TaskData taskData) {
        if (taskData.isNew()) {
            return null;
        }
        return BugzillaIssue.getFieldValue(IssueField.SUMMARY, taskData);
    }

    TaskRepository getTaskRepository() {
        return this.repository.getTaskRepository();
    }

    BugzillaRepository getBugzillaRepository() {
        return this.repository;
    }

    public String getID() {
        return BugzillaIssue.getID(this.data);
    }

    public String getSummary() {
        return this.getFieldValue(IssueField.SUMMARY);
    }

    public void setTaskData(TaskData taskData) {
        assert (!taskData.isPartial());
        this.data = taskData;
        this.attributes = null;
        this.availableOperations = null;
        Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                ((BugzillaIssueNode)BugzillaIssue.this.getNode()).fireDataChanged();
                BugzillaIssue.this.fireDataChanged();
                BugzillaIssue.this.refreshViewData(false);
            }
        });
    }

    TaskData getTaskData() {
        return this.data;
    }

    public String getFieldValue(IssueField f) {
        return BugzillaIssue.getFieldValue(f, this.data);
    }

    private static String getFieldValue(IssueField f, TaskData taskData) {
        if (f.isSingleAttribute()) {
            TaskAttribute a = taskData.getRoot().getMappedAttribute(f.getKey());
            if (a != null && a.getValues().size() > 1) {
                return BugzillaIssue.listValues(a);
            }
            return a != null ? a.getValue() : "";
        }
        List attrs = taskData.getAttributeMapper().getAttributesByType(taskData, f.getKey());
        return "" + (attrs != null && attrs.size() > 0 ? Integer.valueOf(attrs.size()) : "");
    }

    private static String listValues(TaskAttribute a) {
        if (a == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List l = a.getValues();
        for (int i = 0; i < l.size(); ++i) {
            String s = (String)l.get(i);
            sb.append(s);
            if (i >= l.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    void setFieldValue(IssueField f, String value) {
        if (f.isReadOnly()) {
            assert (false) : "can't set value into IssueField " + f.getKey();
            return;
        }
        TaskAttribute a = this.data.getRoot().getMappedAttribute(f.getKey());
        if (a == null) {
            a = new TaskAttribute(this.data.getRoot(), f.getKey());
        }
        if (f == IssueField.PRODUCT) {
            this.handleProductChange(a);
        }
        Bugzilla.LOG.log(Level.FINER, "setting value [{0}] on field [{1}]", new Object[]{value, f.getKey()});
        a.setValue(value);
    }

    void setFieldValues(IssueField f, List<String> ccs) {
        TaskAttribute a = this.data.getRoot().getMappedAttribute(f.getKey());
        if (a == null) {
            a = new TaskAttribute(this.data.getRoot(), f.getKey());
        }
        a.setValues(ccs);
    }

    List<String> getFieldValues(IssueField f) {
        if (f.isSingleAttribute()) {
            TaskAttribute a = this.data.getRoot().getMappedAttribute(f.getKey());
            if (a != null) {
                return a.getValues();
            }
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(this.getFieldValue(f));
        return ret;
    }

    int getFieldStatus(IssueField f) {
        String seenValue = this.getSeenValue(f);
        if (seenValue.equals("") && !seenValue.equals(this.getFieldValue(f))) {
            return 2;
        }
        if (!seenValue.equals(this.getFieldValue(f))) {
            return 4;
        }
        return 1;
    }

    private IssueNode createNode() {
        return new BugzillaIssueNode(this);
    }

    private void handleProductChange(TaskAttribute a) {
        if (!this.data.isNew() && this.initialProduct == null) {
            this.initialProduct = a.getValue();
        }
    }

    void resolve(String resolution) {
        assert (!this.data.isNew());
        String value = this.getFieldValue(IssueField.STATUS);
        if (!value.equals("RESOLVED")) {
            this.setOperation(BugzillaOperation.resolve);
            TaskAttribute rta = this.data.getRoot();
            TaskAttribute ta = rta.getMappedAttribute(BugzillaOperation.resolve.getInputId());
            if (ta != null) {
                ta.setValue(resolution);
            }
        }
    }

    void accept() {
        this.setOperation(BugzillaOperation.accept);
    }

    void duplicate(String id) {
        this.setOperation(BugzillaOperation.duplicate);
        TaskAttribute rta = this.data.getRoot();
        TaskAttribute ta = rta.getMappedAttribute(BugzillaOperation.duplicate.getInputId());
        ta.setValue(id);
    }

    boolean canReassign() {
        boolean oldRepository;
        BugzillaVersion installedVersion;
        BugzillaConfiguration rc = this.getBugzillaRepository().getConfiguration();
        BugzillaVersion bugzillaVersion = installedVersion = rc != null ? rc.getInstalledVersion() : null;
        boolean bl = installedVersion != null ? installedVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_2) < 0 : (oldRepository = false);
        if (oldRepository) {
            TaskAttribute rta = this.data.getRoot();
            TaskAttribute ta = rta.getMappedAttribute(BugzillaOperation.reassign.getInputId());
            return ta != null;
        }
        return true;
    }

    void reassign(String user) {
        this.setOperation(BugzillaOperation.reassign);
        TaskAttribute rta = this.data.getRoot();
        TaskAttribute ta = rta.getMappedAttribute(BugzillaOperation.reassign.getInputId());
        if (ta != null) {
            ta.setValue(user);
        }
        if ((ta = rta.getMappedAttribute(BugzillaAttribute.ASSIGNED_TO.getKey())) != null) {
            ta.setValue(user);
        }
    }

    void verify() {
        this.setOperation(BugzillaOperation.verify);
    }

    void close() {
        this.setOperation(BugzillaOperation.close);
    }

    void reopen() {
        this.setOperation(BugzillaOperation.reopen);
    }

    private void setOperation(BugzillaOperation operation) {
        TaskAttribute rta = this.data.getRoot();
        TaskAttribute ta = rta.getMappedAttribute("task.common.operation");
        ta.setValue(operation.name());
    }

    List<Attachment> getAttachments() {
        List attrs = this.data.getAttributeMapper().getAttributesByType(this.data, "attachment");
        if (attrs == null) {
            return Collections.emptyList();
        }
        ArrayList<Attachment> attachments = new ArrayList<Attachment>(attrs.size());
        for (TaskAttribute taskAttribute : attrs) {
            attachments.add(new Attachment(taskAttribute));
        }
        return attachments;
    }

    void addAttachment(File file, String comment, String desc, String contentType, boolean patch) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        FileTaskAttachmentSource attachmentSource = new FileTaskAttachmentSource(file);
        if (contentType == null) {
            String ct = FileUtil.getMIMEType((FileObject)FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file))));
            contentType = ct != null && !"content/unknown".equals(ct) ? ct : FileTaskAttachmentSource.getContentTypeFromFilename((String)file.getName());
        }
        attachmentSource.setContentType(contentType);
        TaskAttribute attAttribute = new TaskAttribute(this.data.getRoot(), "attachment");
        TaskAttributeMapper mapper = attAttribute.getTaskData().getAttributeMapper();
        TaskAttribute a = attAttribute.createMappedAttribute("task.common.attachment.description");
        a.setValue(desc);
        a = attAttribute.createMappedAttribute("task.common.attachment.patch");
        mapper.setBooleanValue(a, Boolean.valueOf(patch));
        a = attAttribute.createMappedAttribute("task.common.attachment.ctype");
        a.setValue(contentType);
        this.refresh();
        AddAttachmentCommand cmd = new AddAttachmentCommand(this.getID(), this.repository, comment, attachmentSource, file, attAttribute);
        this.repository.getExecutor().execute(cmd);
        if (!cmd.hasFailed()) {
            this.refresh(this.getID(), true);
        }
    }

    Comment[] getComments() {
        List attrs = this.data.getAttributeMapper().getAttributesByType(this.data, "comment");
        if (attrs == null) {
            return new Comment[0];
        }
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (TaskAttribute taskAttribute : attrs) {
            comments.add(new Comment(taskAttribute));
        }
        return comments.toArray(new Comment[comments.size()]);
    }

    public void addComment(String comment, boolean close) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        if (comment == null && !close) {
            return;
        }
        this.refresh();
        if (close) {
            Bugzilla.LOG.log(Level.FINER, "resolving issue #{0} as fixed", new Object[]{this.getID()});
            this.resolve(RESOLVE_FIXED);
            Properties p = System.getProperties();
            Enumeration<Object> keys = p.keys();
            LinkedList<String> keyList = new LinkedList<String>();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (!key.toString().startsWith(VCSHOOK_BUGZILLA_FIELD)) continue;
                keyList.add(key.toString());
            }
            for (String key : keyList) {
                String fieldName = key.substring(VCSHOOK_BUGZILLA_FIELD.length());
                String value = p.getProperty(key);
                IssueField issueField = this.repository.getConfiguration().getField(fieldName);
                if (issueField != null) {
                    if (issueField.isReadOnly()) {
                        Bugzilla.LOG.log(Level.WARNING, "field [{0}] is read-only.", new Object[]{this.repository.getUrl(), fieldName});
                        continue;
                    }
                    this.setFieldValue(issueField, value);
                    continue;
                }
                Bugzilla.LOG.log(Level.WARNING, "Repsitory [{0}] has no field [{1}]", new Object[]{this.repository.getUrl(), fieldName});
            }
        }
        if (comment != null) {
            this.addComment(comment);
        }
        this.submitAndRefresh();
    }

    public void addComment(String comment) {
        if (comment != null) {
            Bugzilla.LOG.log(Level.FINER, "adding comment [{0}] to issue #{1}", new Object[]{comment, this.getID()});
            TaskAttribute ta = this.data.getRoot().createMappedAttribute("task.common.comment.new");
            ta.setValue(comment);
        }
    }

    public void attachPatch(File file, String description) {
        boolean isPatch = true;
        isPatch = !file.getName().endsWith(".hg");
        this.addAttachment(file, null, description, null, isPatch);
    }

    private void prepareSubmit() {
        if (this.initialProduct != null) {
            TaskAttribute ta = this.data.getRoot().getMappedAttribute(BugzillaAttribute.CONFIRM_PRODUCT_CHANGE.getKey());
            if (ta == null) {
                ta = BugzillaTaskDataHandler.createAttribute((TaskAttribute)this.data.getRoot(), (BugzillaAttribute)BugzillaAttribute.CONFIRM_PRODUCT_CHANGE);
            }
            ta.setValue("1");
        }
    }

    boolean submitAndRefresh() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        this.prepareSubmit();
        boolean wasNew = this.data.isNew();
        boolean wasSeenAlready = wasNew || this.repository.getIssueCache().wasSeen(this.getID());
        SubmitCommand submitCmd = new SubmitCommand(this.getTaskRepository(), this.data);
        this.repository.getExecutor().execute(submitCmd);
        if (!wasNew) {
            this.refresh();
        } else {
            RepositoryResponse rr = submitCmd.getRepositoryResponse();
            if (!submitCmd.hasFailed()) {
                assert (rr != null);
                String id = rr.getTaskId();
                Bugzilla.LOG.log(Level.FINE, "created issue #{0}", id);
                this.refresh(id, true);
            } else {
                Bugzilla.LOG.log(Level.FINE, "submiting failed");
                if (rr != null) {
                    Bugzilla.LOG.log(Level.FINE, "repository response {0}", rr.getReposonseKind());
                } else {
                    Bugzilla.LOG.log(Level.FINE, "no repository response available");
                }
            }
        }
        if (submitCmd.hasFailed()) {
            return false;
        }
        if (wasSeenAlready) {
            try {
                this.repository.getIssueCache().setSeen(this.getID(), true);
            }
            catch (IOException ex) {
                Bugzilla.LOG.log(Level.SEVERE, null, ex);
            }
        }
        if (wasNew) {
            this.repository.refreshAllQueries();
        }
        try {
            this.seenAtributes = null;
            this.setSeen(true);
        }
        catch (IOException ex) {
            Bugzilla.LOG.log(Level.SEVERE, null, ex);
        }
        return true;
    }

    public boolean refresh() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        return this.refresh(this.getID(), false);
    }

    private boolean refresh(String id, boolean afterSubmitRefresh) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        try {
            Bugzilla.LOG.log(Level.FINE, "refreshing issue #{0}", id);
            TaskData td = BugzillaUtil.getTaskData(this.repository, id);
            if (td == null) {
                return false;
            }
            this.getBugzillaRepository().getIssueCache().setIssueData((Issue)this, (Object)td);
            this.refreshViewData(afterSubmitRefresh);
        }
        catch (IOException ex) {
            Bugzilla.LOG.log(Level.SEVERE, null, ex);
        }
        return true;
    }

    private void refreshViewData(boolean force) {
        if (this.controller != null) {
            this.controller.refreshViewData(force);
        }
    }

    Map<String, TaskOperation> getAvailableOperations() {
        if (this.availableOperations == null) {
            HashMap<String, TaskOperation> operations = new HashMap<String, TaskOperation>(5);
            List allOperations = this.data.getAttributeMapper().getAttributesByType(this.data, "operation");
            for (TaskAttribute operation : allOperations) {
                if (!operation.getId().startsWith("task.common.operation-")) continue;
                operations.put(operation.getId().substring("task.common.operation-".length()), TaskOperation.createFrom((TaskAttribute)operation));
            }
            this.availableOperations = operations;
        }
        return this.availableOperations;
    }

    boolean isResolveAvailable() {
        Map<String, TaskOperation> operations = this.getAvailableOperations();
        return operations.containsKey(BugzillaOperation.resolve.name());
    }

    private Map<String, String> getSeenAttributes() {
        if (this.seenAtributes == null) {
            this.seenAtributes = this.repository.getIssueCache().getSeenAttributes(this.getID());
            if (this.seenAtributes == null) {
                this.seenAtributes = new HashMap<String, String>();
            }
        }
        return this.seenAtributes;
    }

    String getSeenValue(IssueField f) {
        String seenValue;
        Map<String, String> attr = this.getSeenAttributes();
        String string = seenValue = attr != null ? attr.get(f.getKey()) : null;
        if (seenValue == null) {
            seenValue = "";
        }
        return seenValue;
    }

    private String getMappedValue(TaskAttribute a, String key) {
        TaskAttribute ma = a.getMappedAttribute(key);
        if (ma != null) {
            return ma.getValue();
        }
        return null;
    }

    class Attachment {
        private final String desc;
        private final String filename;
        private final String author;
        private final Date date;
        private final String id;
        private String contentType;
        private String isDeprected;
        private String size;
        private String isPatch;
        private String url;

        public Attachment(TaskAttribute ta) {
            this.id = ta.getValue();
            Date d = null;
            try {
                String s = BugzillaIssue.this.getMappedValue(ta, "task.common.attachment.date");
                if (s != null && !s.trim().equals("")) {
                    d = CC_DATE_FORMAT.parse(s);
                }
            }
            catch (ParseException ex) {
                Bugzilla.LOG.log(Level.SEVERE, null, ex);
            }
            this.date = d;
            this.filename = BugzillaIssue.this.getMappedValue(ta, "filename");
            this.desc = BugzillaIssue.this.getMappedValue(ta, "task.common.attachment.description");
            String who = null;
            TaskAttribute authorAttr = ta.getMappedAttribute("task.common.attachment.author");
            if (authorAttr != null) {
                TaskAttribute nameAttr = authorAttr.getMappedAttribute("task.common.person.name");
                String string = who = nameAttr != null ? nameAttr.getValue() : null;
            }
            if ((who == null || who.trim().equals("")) && authorAttr != null) {
                who = authorAttr.getValue();
            }
            this.author = who;
            this.contentType = BugzillaIssue.this.getMappedValue(ta, "task.common.attachment.ctype");
            this.isDeprected = BugzillaIssue.this.getMappedValue(ta, "task.common.attachment.deprecated");
            this.isPatch = BugzillaIssue.this.getMappedValue(ta, "task.common.attachment.patch");
            this.size = BugzillaIssue.this.getMappedValue(ta, "task.common.attachment.size");
            this.url = BugzillaIssue.this.getMappedValue(ta, "task.common.attachment.url");
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getDate() {
            return this.date;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getId() {
            return this.id;
        }

        public String getIsDeprected() {
            return this.isDeprected;
        }

        public String getIsPatch() {
            return this.isPatch;
        }

        public String getSize() {
            return this.size;
        }

        public String getUrl() {
            return this.url;
        }

        public void getAttachementData(OutputStream os) {
            assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
            BugzillaIssue.this.repository.getExecutor().execute(new GetAttachmentCommand(BugzillaIssue.this.repository, this.id, os));
        }

        void open() {
            String progressFormat = NbBundle.getMessage(DefaultAttachmentAction.class, (String)"Attachment.open.progress");
            String progressMessage = MessageFormat.format(progressFormat, this.getFilename());
            final ProgressHandle handle = ProgressHandleFactory.createHandle((String)progressMessage);
            handle.start();
            handle.switchToIndeterminate();
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        File file = Attachment.this.saveToTempFile();
                        String contentType = Attachment.this.getContentType();
                        if ("image/png".equals(contentType) || "image/gif".equals(contentType) || "image/jpeg".equals(contentType)) {
                            HtmlBrowser.URLDisplayer.getDefault().showURL(file.toURI().toURL());
                        } else {
                            FileObject fob = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file)));
                            DataObject dob = DataObject.find((FileObject)fob);
                            OpenCookie open = (OpenCookie)dob.getCookie(OpenCookie.class);
                            if (open != null) {
                                open.open();
                            }
                        }
                    }
                    catch (DataObjectNotFoundException dnfex) {
                        Bugzilla.LOG.log(Level.INFO, dnfex.getMessage(), dnfex);
                    }
                    catch (IOException ioex) {
                        Bugzilla.LOG.log(Level.INFO, ioex.getMessage(), ioex);
                    }
                    finally {
                        handle.finish();
                    }
                }
            });
        }

        void saveToFile() {
            final File file = new FileChooserBuilder(AttachmentsPanel.class).setFilesOnly(true).showSaveDialog();
            if (file != null) {
                String progressFormat = NbBundle.getMessage(SaveAttachmentAction.class, (String)"Attachment.saveToFile.progress");
                String progressMessage = MessageFormat.format(progressFormat, this.getFilename());
                final ProgressHandle handle = ProgressHandleFactory.createHandle((String)progressMessage);
                handle.start();
                handle.switchToIndeterminate();
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Attachment.this.getAttachementData(new FileOutputStream(file));
                        }
                        catch (IOException ioex) {
                            Bugzilla.LOG.log(Level.INFO, ioex.getMessage(), ioex);
                        }
                        finally {
                            handle.finish();
                        }
                    }
                });
            }
        }

        void applyPatch() {
            final File context = BugtrackingUtil.selectPatchContext();
            if (context != null) {
                String progressFormat = NbBundle.getMessage(ApplyPatchAction.class, (String)"Attachment.applyPatch.progress");
                String progressMessage = MessageFormat.format(progressFormat, this.getFilename());
                final ProgressHandle handle = ProgressHandleFactory.createHandle((String)progressMessage);
                handle.start();
                handle.switchToIndeterminate();
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            File file = Attachment.this.saveToTempFile();
                            PatchUtils.applyPatch((File)file, (File)context);
                        }
                        catch (IOException ioex) {
                            Bugzilla.LOG.log(Level.INFO, ioex.getMessage(), ioex);
                        }
                        finally {
                            handle.finish();
                        }
                    }
                });
            }
        }

        private File saveToTempFile() throws IOException {
            String suffix;
            int index = this.filename.lastIndexOf(46);
            String prefix = index == -1 ? this.filename : this.filename.substring(0, index);
            String string = suffix = index == -1 ? null : this.filename.substring(index);
            if (prefix.length() < 3) {
                prefix = prefix + "tmp";
            }
            File file = File.createTempFile(prefix, suffix);
            this.getAttachementData(new FileOutputStream(file));
            return file;
        }

        class ApplyPatchAction
        extends AbstractAction {
            public ApplyPatchAction() {
                this.putValue("Name", NbBundle.getMessage(ApplyPatchAction.class, (String)"Attachment.ApplyPatchAction.name"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Attachment.this.applyPatch();
            }
        }

        class SaveAttachmentAction
        extends AbstractAction {
            public SaveAttachmentAction() {
                this.putValue("Name", NbBundle.getMessage(SaveAttachmentAction.class, (String)"Attachment.SaveAction.name"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Attachment.this.saveToFile();
            }
        }

        class DefaultAttachmentAction
        extends AbstractAction {
            public DefaultAttachmentAction() {
                this.putValue("Name", NbBundle.getMessage(DefaultAttachmentAction.class, (String)"Attachment.DefaultAction.name"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Attachment.this.open();
            }
        }
    }

    class Comment {
        private final Date when;
        private final String author;
        private final String authorName;
        private final Long number;
        private final String text;

        public Comment(TaskAttribute a) {
            Date d = null;
            try {
                String s = BugzillaIssue.this.getMappedValue(a, "task.common.comment.date");
                if (s != null && !s.trim().equals("")) {
                    d = CC_DATE_FORMAT.parse(s);
                }
            }
            catch (ParseException ex) {
                Bugzilla.LOG.log(Level.SEVERE, null, ex);
            }
            this.when = d;
            TaskAttribute authorAttr = a.getMappedAttribute("task.common.comment.author");
            if (authorAttr != null) {
                this.author = authorAttr.getValue();
                TaskAttribute nameAttr = authorAttr.getMappedAttribute("task.common.person.name");
                this.authorName = nameAttr != null ? nameAttr.getValue() : null;
            } else {
                this.authorName = null;
                this.author = null;
            }
            String n = BugzillaIssue.this.getMappedValue(a, "task.common.comment.number");
            this.number = n != null ? Long.valueOf(Long.parseLong(n)) : null;
            this.text = BugzillaIssue.this.getMappedValue(a, "task.common.comment.text");
        }

        public Long getNumber() {
            return this.number;
        }

        public String getText() {
            return this.text;
        }

        public Date getWhen() {
            return this.when;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getAuthorName() {
            return this.authorName;
        }
    }
}

