/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.AnnotationsHolder;
import org.netbeans.modules.java.editor.overridden.ComputeOverriders;
import org.netbeans.modules.java.editor.overridden.ComputeOverriding;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotation;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class ComputeAnnotations
extends JavaParserResultTask<Parser.Result> {
    private final AtomicBoolean cancel = new AtomicBoolean();

    public ComputeAnnotations() {
        super(JavaSource.Phase.RESOLVED);
    }

    public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
        this.cancel.set(false);
        CompilationInfo compilationInfo = CompilationInfo.get((Parser.Result)result);
        if (compilationInfo.getChangedTree() != null) {
            return;
        }
        long l = System.currentTimeMillis();
        StyledDocument styledDocument = (StyledDocument)result.getSnapshot().getSource().getDocument(false);
        if (styledDocument == null) {
            return;
        }
        List<IsOverriddenAnnotation> list = this.computeAnnotations(compilationInfo, styledDocument);
        if (this.cancel.get()) {
            return;
        }
        AnnotationsHolder.get(compilationInfo.getFileObject()).setNewAnnotations(list);
        long l2 = System.currentTimeMillis();
        Logger.getLogger("TIMER").log(Level.FINE, "Is Overridden Annotations", new Object[]{compilationInfo.getFileObject(), l2 - l});
    }

    List<IsOverriddenAnnotation> computeAnnotations(CompilationInfo compilationInfo, StyledDocument styledDocument) {
        LinkedList<IsOverriddenAnnotation> linkedList = new LinkedList<IsOverriddenAnnotation>();
        this.createAnnotations(compilationInfo, styledDocument, new ComputeOverriding(this.cancel).process(compilationInfo), false, linkedList);
        this.createAnnotations(compilationInfo, styledDocument, new ComputeOverriders(this.cancel).process(compilationInfo, null, null, false), true, linkedList);
        return linkedList;
    }

    private void createAnnotations(CompilationInfo compilationInfo, StyledDocument styledDocument, Map<ElementHandle<? extends Element>, List<ElementDescription>> map, boolean bl, List<IsOverriddenAnnotation> list) {
        if (map != null) {
            for (Map.Entry<ElementHandle<? extends Element>, List<ElementDescription>> entry : map.entrySet()) {
                Object object;
                String string;
                AnnotationType annotationType;
                Element element = entry.getKey().resolve(compilationInfo);
                Tree tree = compilationInfo.getTrees().getTree(element);
                if (tree == null) continue;
                if (bl) {
                    if (element.getEnclosingElement().getKind().isInterface() || element.getKind().isInterface()) {
                        annotationType = AnnotationType.HAS_IMPLEMENTATION;
                        string = NbBundle.getMessage(ComputeAnnotations.class, (String)"TP_HasImplementations");
                    } else {
                        annotationType = AnnotationType.IS_OVERRIDDEN;
                        string = NbBundle.getMessage(ComputeAnnotations.class, (String)"TP_IsOverridden");
                    }
                } else {
                    object = new StringBuffer();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    for (ElementDescription elementDescription : entry.getValue()) {
                        if (bl3) {
                            ((StringBuffer)object).append("\n");
                        }
                        bl3 = true;
                        if (elementDescription.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                            ((StringBuffer)object).append(NbBundle.getMessage(ComputeAnnotations.class, (String)"TP_Implements", (Object)elementDescription.getDisplayName()));
                            continue;
                        }
                        ((StringBuffer)object).append(NbBundle.getMessage(ComputeAnnotations.class, (String)"TP_Overrides", (Object)elementDescription.getDisplayName()));
                        bl2 = true;
                    }
                    annotationType = bl2 ? AnnotationType.OVERRIDES : AnnotationType.IMPLEMENTS;
                    string = ((StringBuffer)object).toString();
                }
                object = ComputeAnnotations.getPosition(styledDocument, (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree));
                if (object == null) continue;
                list.add(new IsOverriddenAnnotation(styledDocument, (Position)object, annotationType, string, entry.getValue()));
            }
        }
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancel.set(true);
    }

    private static Position getPosition(final StyledDocument styledDocument, final int n) {
        class Impl
        implements Runnable {
            private Position pos;

            Impl() {
            }

            @Override
            public void run() {
                if (n < 0 || n >= styledDocument.getLength()) {
                    return;
                }
                try {
                    this.pos = styledDocument.createPosition(n - NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n));
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(ComputeAnnotations.class.getName()).log(Level.FINE, null, badLocationException);
                }
            }
        }
        Impl impl = new Impl();
        styledDocument.render(impl);
        return impl.pos;
    }

    public static final class FactoryImpl
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singleton(new ComputeAnnotations());
        }
    }
}

