/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator.impl.dynamic;

import java.lang.reflect.Method;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.netbeans.modules.identity.profile.api.configurator.TrustAuthorityConfigurator;
import org.netbeans.modules.identity.profile.api.configurator.impl.dynamic.ProviderConfigImpl;
import org.netbeans.modules.identity.profile.api.configurator.impl.dynamic.TrustAuthorityConfigImpl;
import org.netbeans.modules.identity.profile.api.configurator.spi.DiscoveryConfig;
import org.netbeans.modules.identity.profile.api.configurator.spi.ProviderConfig;

public class DiscoveryConfigImpl
extends TrustAuthorityConfigImpl
implements DiscoveryConfig {
    private static final String AM_DISCOVERY_CONFIG_CLASS = "com.sun.identity.wss.provider.DiscoveryConfig";
    private static final String AM_REGISTER_PROVIDER_WITH_TA_METHOD = "registerProviderWithTA";
    private static final String AM_UNREGISTER_PROVIDER_WITH_TA_METHOD = "unregisterProviderWithTA";
    private Class discoveryConfigClass;

    public DiscoveryConfigImpl(String name, TrustAuthorityConfigurator.Type type, ServerProperties properties) {
        super(name, type, properties);
    }

    private Class getDiscoveryConfigClass() {
        if (this.discoveryConfigClass == null) {
            try {
                this.discoveryConfigClass = this.getClassLoader().loadClass(AM_DISCOVERY_CONFIG_CLASS);
            }
            catch (Exception ex) {
                throw this.createConfiguratorException(ex);
            }
        }
        return this.discoveryConfigClass;
    }

    @Override
    public void registerProvider(ProviderConfig providerConfig) {
        try {
            ProviderConfigImpl providerConfigImpl = (ProviderConfigImpl)providerConfig;
            Method method = this.getDiscoveryConfigClass().getMethod(AM_REGISTER_PROVIDER_WITH_TA_METHOD, providerConfigImpl.getProviderConfigClass(), String.class);
            method.invoke(this.getTrustAuthorityConfig(), ((ProviderConfigImpl)providerConfig).getProviderConfig(), providerConfig.getServiceType());
        }
        catch (Exception ex) {
            throw this.createConfiguratorException(ex);
        }
    }

    @Override
    public void unregisterProvider(ProviderConfig providerConfig) {
        ClassLoader threadContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            Method method = this.getDiscoveryConfigClass().getMethod(AM_UNREGISTER_PROVIDER_WITH_TA_METHOD, String.class);
            method.invoke(this.getTrustAuthorityConfig(), providerConfig.getServiceType());
        }
        catch (Exception ex) {
            System.out.println("unregister failed " + ex.getMessage());
            throw this.createConfiguratorException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContextClassLoader);
        }
    }
}

