/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.netbeans.modules.identity.profile.api.configurator.Configurator;
import org.netbeans.modules.identity.profile.api.configurator.Modifier;

class MultiSelectTableModifier
extends Modifier {
    private JTable table;

    public MultiSelectTableModifier(final Enum configurable, final JTable table, final Configurator configurator) {
        super(configurable, table, configurator);
        this.table = table;
        this.setValue(configurator.getValue(configurable));
        final ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (selectionModel.isSelectionEmpty()) {
                    configurator.setValue(configurable, Collections.EMPTY_LIST);
                } else {
                    int[] selectedRows = table.getSelectedRows();
                    TableModel model = table.getModel();
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        int row = selectedRows[i];
                        Object value = model.getValueAt(row, 0);
                        values.add(value);
                    }
                    configurator.setValue(configurable, values);
                }
            }
        });
    }

    @Override
    public void setValue(Object value) {
        this.table.clearSelection();
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            TableModel model = this.table.getModel();
            int rowCount = model.getRowCount();
            block0: for (int i = 0; i < rowCount; ++i) {
                Object rowValue = model.getValueAt(i, 0);
                Iterator iter = ((Collection)value).iterator();
                while (iter.hasNext()) {
                    if (!rowValue.equals(iter.next())) continue;
                    this.table.changeSelection(i, 0, true, false);
                    continue block0;
                }
            }
        }
    }

    @Override
    public Object getValue() {
        int[] indices = this.table.getSelectedRows();
        ArrayList<String> rows = new ArrayList<String>();
        TableModel model = this.table.getModel();
        for (int i : indices) {
            rows.add((String)model.getValueAt(i, 0));
        }
        return rows;
    }
}

