/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.presenters.actions.ConfirmDeletionPanel;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeletableState;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeleteDependencyPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeletePresenter;

public final class DeleteSupport {
    private DeleteSupport() {
    }

    private static DeletableState canDelete(Collection<DesignComponent> components) {
        boolean disallowedForUserOnly = false;
        for (DesignComponent component : components) {
            for (DeletePresenter presenter : component.getPresenters(DeletePresenter.class)) {
                DeletableState state = presenter.canDelete();
                switch (state) {
                    case DISALLOWED: {
                        return DeletableState.DISALLOWED;
                    }
                    case DISALLOWED_FOR_USER_ONLY: {
                        disallowedForUserOnly = true;
                    }
                }
            }
        }
        return disallowedForUserOnly ? DeletableState.DISALLOWED_FOR_USER_ONLY : DeletableState.ALLOWED;
    }

    static boolean isSilent(DesignComponent component) {
        for (DeletePresenter presenter : component.getPresenters(DeletePresenter.class)) {
            if (!presenter.isSilent()) continue;
            return true;
        }
        return false;
    }

    private static Collection<DesignComponent> gatherAllComponentsToDelete(DesignDocument document, Collection<DesignComponent> baseComponents) {
        HashSet<DesignComponent> componentsToDelete = new HashSet<DesignComponent>(baseComponents);
        Collection<DesignComponent> componentsToDeleteUm = Collections.unmodifiableCollection(componentsToDelete);
        while (DeleteSupport.findNewlyRequired(document.getRootComponent(), componentsToDelete, componentsToDeleteUm)) {
        }
        return componentsToDelete;
    }

    private static boolean findNewlyRequired(DesignComponent component, Collection<DesignComponent> componentsToDelete, Collection<DesignComponent> componentsToDeleteUm) {
        boolean changed = false;
        if (!componentsToDelete.contains(component) && DeleteSupport.requiresToLive(component, componentsToDeleteUm)) {
            componentsToDelete.add(component);
            changed = true;
        }
        for (DesignComponent child : component.getComponents()) {
            if (!DeleteSupport.findNewlyRequired(child, componentsToDelete, componentsToDeleteUm)) continue;
            changed = true;
        }
        return changed;
    }

    private static boolean requiresToLive(DesignComponent component, Collection<DesignComponent> componentsToDelete) {
        for (DeleteDependencyPresenter presenter : component.getPresenters(DeleteDependencyPresenter.class)) {
            if (!presenter.requiresToLive(componentsToDelete)) continue;
            return true;
        }
        return false;
    }

    private static void notifyComponentsDeleting(DesignComponent component, Collection<DesignComponent> componentsToDeleteUm) {
        for (DeleteDependencyPresenter presenter : component.getPresenters(DeleteDependencyPresenter.class)) {
            presenter.componentsDeleting(componentsToDeleteUm);
        }
        for (DesignComponent child : component.getComponents()) {
            DeleteSupport.notifyComponentsDeleting(child, componentsToDeleteUm);
        }
    }

    public static boolean canDeleteAsUser(DesignDocument document, Collection<DesignComponent> componentsToDelete) {
        if (DeleteSupport.canDelete(componentsToDelete) != DeletableState.ALLOWED) {
            return false;
        }
        Collection<DesignComponent> allComponentsToDelete = DeleteSupport.gatherAllComponentsToDelete(document, componentsToDelete);
        return DeleteSupport.canDelete(allComponentsToDelete) != DeletableState.DISALLOWED;
    }

    public static void invokeDirectUserDeletion(DesignDocument document, Collection<DesignComponent> componentsToDelete, boolean showConfirmation) {
        if (DeleteSupport.canDelete(componentsToDelete) != DeletableState.ALLOWED) {
            return;
        }
        Collection<DesignComponent> allComponentsToDelete = DeleteSupport.gatherAllComponentsToDelete(document, componentsToDelete);
        if (DeleteSupport.canDelete(allComponentsToDelete) == DeletableState.DISALLOWED) {
            return;
        }
        if (showConfirmation && !ConfirmDeletionPanel.show(componentsToDelete, allComponentsToDelete)) {
            return;
        }
        DeleteSupport.notifyComponentsDeleting(document.getRootComponent(), Collections.unmodifiableCollection(allComponentsToDelete));
        for (DesignComponent component : allComponentsToDelete) {
            for (DeletePresenter presenter : component.getPresenters(DeletePresenter.class)) {
                presenter.delete();
            }
        }
        document.deleteComponents(allComponentsToDelete);
    }
}

