/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistryListener;
import org.netbeans.modules.vmd.api.model.GlobalDescriptorRegistry;
import org.netbeans.modules.vmd.api.model.TypeDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.WeakSet;

public final class DescriptorRegistry {
    private final Mutex mutex = new Mutex();
    private final WeakSet<DescriptorRegistryListener> listeners = new WeakSet();
    private HashMap<TypeID, ComponentDescriptor> descriptors = new HashMap();
    private ArrayList<ComponentProducer> producers = new ArrayList();
    private GlobalDescriptorRegistry globalDescriptorRegistry;
    private DescriptorRegistryListener listener = new DescriptorRegistryListener(){

        @Override
        public void descriptorRegistryUpdated() {
            DescriptorRegistry.this.reload();
        }
    };

    public static DescriptorRegistry getDescriptorRegistry(String projectType, String projectID) {
        return GlobalDescriptorRegistry.getGlobalDescriptorRegistry(projectType).getProjectRegistry(projectID);
    }

    DescriptorRegistry(GlobalDescriptorRegistry globalDescriptorRegistry) {
        assert (Debug.isFriend(GlobalDescriptorRegistry.class, "getProjectRegistry"));
        this.globalDescriptorRegistry = globalDescriptorRegistry;
        globalDescriptorRegistry.addRegistryListener(this.listener);
        this.reload();
    }

    private boolean isAccess() {
        return this.mutex.isReadAccess() || this.mutex.isWriteAccess();
    }

    public void readAccess(final Runnable runnable) {
        this.globalDescriptorRegistry.readAccess(new Runnable(){

            @Override
            public void run() {
                DescriptorRegistry.this.mutex.readAccess(runnable);
            }
        });
    }

    private void writeAccess(final Runnable runnable) {
        this.globalDescriptorRegistry.readAccess(new Runnable(){

            @Override
            public void run() {
                DescriptorRegistry.this.mutex.writeAccess(runnable);
            }
        });
    }

    private void reload() {
        this.writeAccess(new Runnable(){

            @Override
            public void run() {
                DescriptorRegistry.this.reloadCore();
            }
        });
    }

    private void reloadCore() {
        HashMap<TypeID, ComponentDescriptor> tempDescriptors = new HashMap<TypeID, ComponentDescriptor>();
        ArrayList<ComponentProducer> tempProducers = new ArrayList<ComponentProducer>();
        Collection<ComponentDescriptor> _descriptors = this.globalDescriptorRegistry.getComponentDescriptors();
        for (ComponentDescriptor descriptor : _descriptors) {
            tempDescriptors.put(descriptor.getTypeDescriptor().getThisType(), descriptor);
        }
        tempProducers.addAll(this.globalDescriptorRegistry.getComponentProducers());
        this.descriptors = tempDescriptors;
        this.producers = tempProducers;
        for (DescriptorRegistryListener _listener : this.listeners) {
            try {
                _listener.descriptorRegistryUpdated();
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public ComponentDescriptor getComponentDescriptor(TypeID componentType) {
        assert (this.isAccess()) : "No Mutex acess";
        if (componentType == null) {
            return null;
        }
        return this.descriptors.get(componentType);
    }

    public void removeComponentDescriptor(TypeID componentType) {
        if (componentType != null) {
            this.globalDescriptorRegistry.writeAccess(new RemoveComponentDescriptorTask(componentType));
        }
    }

    public Collection<ComponentDescriptor> getComponentDescriptors() {
        assert (this.isAccess());
        return Collections.unmodifiableCollection(this.descriptors.values());
    }

    public List<ComponentProducer> getComponentProducers() {
        assert (this.isAccess());
        return Collections.unmodifiableList(this.producers);
    }

    public void addRegistryListener(final DescriptorRegistryListener listener) {
        this.writeAccess(new Runnable(){

            @Override
            public void run() {
                DescriptorRegistry.this.listeners.add((Object)listener);
                listener.descriptorRegistryUpdated();
            }
        });
    }

    public void removeRegistryListener(final DescriptorRegistryListener listener) {
        this.writeAccess(new Runnable(){

            @Override
            public void run() {
                DescriptorRegistry.this.listeners.remove((Object)listener);
            }
        });
    }

    private boolean isComponentDescriptorCompatibleWithTypeID(TypeID typeID, ComponentDescriptor componentDescriptor) {
        assert (this.isAccess());
        if (typeID == null) {
            return false;
        }
        while (componentDescriptor != null) {
            TypeDescriptor typeDescriptor = componentDescriptor.getTypeDescriptor();
            TypeID checked = typeDescriptor.getThisType();
            if (checked == null) {
                return false;
            }
            if (checked.equals(typeID)) {
                return true;
            }
            componentDescriptor = this.getComponentDescriptor(typeDescriptor.getSuperType());
        }
        return false;
    }

    public boolean isInHierarchy(TypeID superTypeID, TypeID derivedTypeID) {
        return this.isComponentDescriptorCompatibleWithTypeID(superTypeID, this.getComponentDescriptor(derivedTypeID));
    }

    final class RemoveComponentDescriptorTask
    implements Runnable {
        private TypeID componentType;

        public RemoveComponentDescriptorTask(TypeID componentType) {
            this.componentType = componentType;
        }

        @Override
        public void run() {
            DescriptorRegistry.this.globalDescriptorRegistry.removeComponentDescriptor(this.componentType);
        }
    }
}

