/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;

public abstract class ComponentProducer {
    private String producerID;
    private TypeID typeID;
    private PaletteDescriptor paletteDescriptor;

    protected ComponentProducer(String producerID, TypeID typeID, PaletteDescriptor paletteDescriptor) {
        assert (producerID != null && typeID != null && paletteDescriptor != null);
        this.producerID = producerID;
        this.typeID = typeID;
        this.paletteDescriptor = paletteDescriptor;
    }

    public final String getProducerID() {
        return this.producerID;
    }

    public final TypeID getMainComponentTypeID() {
        return this.typeID;
    }

    public final PaletteDescriptor getPaletteDescriptor() {
        return this.paletteDescriptor;
    }

    public final Result createComponent(DesignDocument document) {
        DesignComponent mainComponent = this.createMainComponent(document);
        assert (mainComponent != null);
        Result result = this.postInitialize(document, mainComponent);
        assert (result != null);
        assert (result.getMainComponent() == mainComponent);
        return result;
    }

    protected DesignComponent createMainComponent(DesignDocument document) {
        return document.createComponent(this.getMainComponentTypeID());
    }

    public Result postInitialize(DesignDocument document, DesignComponent mainComponent) {
        return new Result(mainComponent);
    }

    public abstract Boolean checkValidity(DesignDocument var1, boolean var2);

    static ComponentProducer createDefault(ComponentDescriptor descriptor) {
        PaletteDescriptor paletteDescriptor = descriptor.getPaletteDescriptor();
        TypeID typeid = descriptor.getTypeDescriptor().getThisType();
        if (paletteDescriptor == null) {
            return null;
        }
        return new ComponentProducer(typeid.toString(), typeid, paletteDescriptor){

            @Override
            public Boolean checkValidity(DesignDocument document, boolean useCachedValue) {
                return true;
            }
        };
    }

    public static final class Result {
        private DesignComponent mainComponent;
        private List<DesignComponent> components;

        public Result(DesignComponent ... components) {
            this.mainComponent = components.length > 0 ? components[0] : null;
            this.components = Arrays.asList(components);
            assert (!this.components.contains(null));
        }

        public Result(DesignComponent mainComponent, List<DesignComponent> components) {
            this.mainComponent = mainComponent;
            this.components = components;
        }

        public DesignComponent getMainComponent() {
            return this.mainComponent;
        }

        public List<DesignComponent> getComponents() {
            return this.components;
        }
    }
}

