/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.project.ExtraProjectJavadocForBinaryQueryImpl;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

public final class ExtraProjectSourceForBinaryQueryImpl
extends ProjectOpenedHook
implements SourceForBinaryQueryImplementation2 {
    private static final String REF_START = "file.reference.";
    private static final String SOURCE_START = "source.reference.";
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final Map<URL, ExtraResult> cache = new HashMap<URL, ExtraResult>();
    private PropertyChangeListener listener;
    private Map<URL, URL> mappings = new HashMap<URL, URL>();
    private final Object MAPPINGS_LOCK = new Object();
    private Project project;

    public ExtraProjectSourceForBinaryQueryImpl(Project prj, AntProjectHelper helper, PropertyEvaluator evaluator) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.project = prj;
        this.listener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == null || evt.getPropertyName().startsWith(ExtraProjectSourceForBinaryQueryImpl.SOURCE_START)) {
                    ExtraProjectSourceForBinaryQueryImpl.this.checkAndRegisterExtraSources(ExtraProjectSourceForBinaryQueryImpl.this.getExtraSources());
                    ArrayList results = null;
                    Map map = ExtraProjectSourceForBinaryQueryImpl.this.cache;
                    synchronized (map) {
                        results = new ArrayList(ExtraProjectSourceForBinaryQueryImpl.this.cache.values());
                    }
                    for (ExtraResult res : results) {
                        res.fire();
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL binaryRoot) {
        Map<URL, ExtraResult> map = this.cache;
        synchronized (map) {
            ExtraResult res = this.cache.get(binaryRoot);
            if (res != null) {
                return res;
            }
            if (this.mappings.containsKey(binaryRoot)) {
                res = new ExtraResult(binaryRoot);
                this.cache.put(binaryRoot, res);
                return res;
            }
        }
        return null;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        return this.findSourceRoots2(binaryRoot);
    }

    protected void projectOpened() {
        this.checkAndRegisterExtraSources(this.getExtraSources());
        this.evaluator.addPropertyChangeListener(this.listener);
    }

    protected void projectClosed() {
        this.checkAndRegisterExtraSources(new HashMap<URL, URL>());
        this.evaluator.removePropertyChangeListener(this.listener);
    }

    private Map<URL, URL> getExtraSources() {
        HashMap<URL, URL> result = new HashMap<URL, URL>();
        Map props = this.evaluator.getProperties();
        if (props != null) {
            for (Map.Entry entry : props.entrySet()) {
                File src;
                if (!((String)entry.getKey()).startsWith(REF_START)) continue;
                String val = ((String)entry.getKey()).substring(REF_START.length());
                String sourceKey = SOURCE_START + val;
                String[] source = ExtraProjectJavadocForBinaryQueryImpl.stripJARPath((String)props.get(sourceKey));
                File bin = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.helper.getProjectDirectory()), (String)((String)entry.getValue()));
                URL binURL = FileUtil.urlForArchiveOrDir((File)bin);
                if (source[0] == null || binURL == null || !(src = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.helper.getProjectDirectory()), (String)source[0])).exists()) continue;
                try {
                    URL url = src.toURI().toURL();
                    if (FileUtil.isArchiveFile((URL)url)) {
                        url = FileUtil.getArchiveRoot((URL)url);
                    }
                    if (source[1] != null) {
                        assert (url.toExternalForm().endsWith("!/")) : url.toExternalForm();
                        url = new URL(url.toExternalForm() + source[1]);
                    }
                    result.put(binURL, url);
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndRegisterExtraSources(Map<URL, URL> newvalues) {
        URL jaradd;
        HashSet<URL> added;
        HashSet<URL> removed;
        Object object = this.MAPPINGS_LOCK;
        synchronized (object) {
            removed = new HashSet<URL>(this.mappings.keySet());
            removed.removeAll(newvalues.keySet());
            added = new HashSet<URL>(newvalues.keySet());
            added.removeAll(this.mappings.keySet());
            this.mappings = newvalues;
        }
        for (URL rem : removed) {
            Map<URL, ExtraResult> map = this.cache;
            synchronized (map) {
                ExtraResult res = this.cache.remove(rem);
                if (res != null) {
                    res.fire();
                }
            }
            try {
                jaradd = FileUtil.getArchiveFile((URL)rem);
                if (jaradd != null) {
                    rem = jaradd;
                }
                FileOwnerQuery.markExternalOwner((URI)rem.toURI(), null, (int)0);
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        for (URL add : added) {
            try {
                jaradd = FileUtil.getArchiveFile((URL)add);
                if (jaradd != null) {
                    add = jaradd;
                }
                FileOwnerQuery.markExternalOwner((URI)add.toURI(), (Project)this.project, (int)0);
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class ExtraResult
    implements SourceForBinaryQueryImplementation2.Result {
        private URL binaryroot;
        private ChangeSupport chs = new ChangeSupport((Object)this);

        public ExtraResult(URL binary) {
            this.binaryroot = binary;
        }

        public FileObject[] getRoots() {
            FileObject fo;
            URL source = (URL)ExtraProjectSourceForBinaryQueryImpl.this.mappings.get(this.binaryroot);
            if (source != null && (fo = URLMapper.findFileObject((URL)source)) != null) {
                return new FileObject[]{fo};
            }
            return new FileObject[0];
        }

        public void fire() {
            this.chs.fireChange();
        }

        public void addChangeListener(ChangeListener l) {
            this.chs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.chs.removeChangeListener(l);
        }

        public boolean preferSources() {
            return false;
        }
    }
}

