/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.lexer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.ruby.lexer.RubyCommentTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.openide.util.NbPreferences;

public final class RubyCommentLexer
implements Lexer<RubyCommentTokenId> {
    private static final int EOF = -1;
    private static final String[] RDOC_DIRECTIVES = new String[]{"arg", "args", "yield", "yields", "notnew", "not-new", "not_new", "doc", "nodoc", "stopdoc", "startdoc", "enddoc", "main", "title", "section", "include"};
    private final LexerInput input;
    private final TokenFactory<RubyCommentTokenId> tokenFactory;
    private String[] markers;

    public RubyCommentLexer(LexerRestartInfo<RubyCommentTokenId> info) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        assert (info.state() == null);
    }

    public Object state() {
        return null;
    }

    private synchronized String[] getTodoMarkers() {
        if (this.markers == null) {
            String TODO_MARKERS_KEY = "patterns";
            Preferences preferences = NbPreferences.root().node("/org/netbeans/modules/tasklist/todo");
            preferences.addPreferenceChangeListener(new PreferenceChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    RubyCommentLexer rubyCommentLexer = RubyCommentLexer.this;
                    synchronized (rubyCommentLexer) {
                        RubyCommentLexer.access$002(RubyCommentLexer.this, null);
                    }
                }
            });
            ArrayList<String> markerList = new ArrayList<String>();
            markerList.addAll(Arrays.asList(preferences.get("patterns", "").split("\\|")));
            if (!markerList.isEmpty()) {
                markerList.remove("@todo");
                Iterator it = markerList.iterator();
                while (it.hasNext()) {
                    if (!((String)it.next()).trim().isEmpty()) continue;
                    it.remove();
                }
                this.markers = markerList.toArray(new String[markerList.size()]);
            } else {
                this.markers = new String[]{"TODO", "FIXME", "XXX", "PENDING"};
            }
        }
        return this.markers;
    }

    public Preferences getDocscanPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/tasklist/docscan");
    }

    public Token<RubyCommentTokenId> nextToken() {
        boolean inWord = false;
        block16: while (true) {
            int ch = this.input.read();
            block0 : switch (ch) {
                case -1: {
                    if (this.input.readLength() > 0) {
                        return this.token(RubyCommentTokenId.COMMENT_TEXT);
                    }
                    return null;
                }
                case 92: {
                    this.input.read();
                    continue block16;
                }
                case 10: {
                    return this.token(RubyCommentTokenId.COMMENT_TEXT);
                }
                case 35: {
                    int next;
                    CharSequence s = this.input.readText();
                    int classIndex = s.length() - 1;
                    assert (s.charAt(classIndex) == '#');
                    --classIndex;
                    while (classIndex >= 0) {
                        char c = s.charAt(classIndex);
                        if (!Character.isJavaIdentifierPart(c) && c != '_' && c != ':') {
                            assert (classIndex < s.length() - 1);
                            char next2 = s.charAt(classIndex + 1);
                            if (next2 == '#' || Character.isUpperCase(next2)) break;
                            continue block16;
                        }
                        --classIndex;
                    }
                    if (classIndex == -1) {
                        next = s.charAt(0);
                        if (next != 35 && !Character.isUpperCase((char)next)) {
                            break;
                        }
                    } else {
                        this.input.backup(this.input.readLength() - (classIndex + 1));
                        return this.token(RubyCommentTokenId.COMMENT_TEXT);
                    }
                    int originalLength = this.input.readLength();
                    boolean seenSuffixChar = false;
                    boolean seenPrefixChar = false;
                    while (ch != -1) {
                        ch = this.input.read();
                        if (ch == 36 || ch == 64) {
                            seenPrefixChar = true;
                            continue;
                        }
                        if (ch == 63 || ch == 61 || ch == 33) {
                            seenSuffixChar = true;
                            continue;
                        }
                        if (ch == 58 || Character.isJavaIdentifierPart(ch)) {
                            if (!seenSuffixChar) continue;
                            break;
                        }
                        this.input.backup(1);
                        break;
                    }
                    if (!Character.isWhitespace(ch) && ch != -1 && ch != 46 && ch != 44 && ch != 41 && ch != 125 && ch != 40 || this.input.readLength() <= 2 || this.input.readLength() <= originalLength) break;
                    return this.token(RubyCommentTokenId.COMMENT_LINK);
                }
                case 102: 
                case 104: 
                case 109: 
                case 119: {
                    int next;
                    if (inWord) break;
                    int originalLength = this.input.readLength();
                    boolean foundLinkBegin = false;
                    if (ch == 104) {
                        if (this.input.read() == 116) {
                            if (this.input.read() == 116) {
                                if (this.input.read() == 112) {
                                    next = this.input.read();
                                    switch (next) {
                                        case 58: {
                                            foundLinkBegin = true;
                                            break;
                                        }
                                        case 115: {
                                            if (this.input.read() == 58) {
                                                foundLinkBegin = true;
                                                break;
                                            }
                                            this.input.backup(5);
                                            break;
                                        }
                                        default: {
                                            this.input.backup(4);
                                            break;
                                        }
                                    }
                                } else {
                                    this.input.backup(3);
                                }
                            } else {
                                this.input.backup(2);
                            }
                        } else {
                            this.input.backup(1);
                        }
                    } else if (ch == 102) {
                        if (this.input.read() == 116) {
                            if (this.input.read() == 112) {
                                if (this.input.read() == 58) {
                                    foundLinkBegin = true;
                                } else {
                                    this.input.backup(3);
                                }
                            } else {
                                this.input.backup(2);
                            }
                        } else {
                            this.input.backup(1);
                        }
                    } else if (ch == 109) {
                        if (this.input.read() == 97) {
                            if (this.input.read() == 105) {
                                if (this.input.read() == 108) {
                                    if (this.input.read() == 116) {
                                        if (this.input.read() == 111) {
                                            if (this.input.read() == 58) {
                                                foundLinkBegin = true;
                                            } else {
                                                this.input.backup(6);
                                            }
                                        } else {
                                            this.input.backup(5);
                                        }
                                    } else {
                                        this.input.backup(4);
                                    }
                                } else {
                                    this.input.backup(3);
                                }
                            } else {
                                this.input.backup(2);
                            }
                        } else {
                            this.input.backup(1);
                        }
                    } else if (ch == 119) {
                        if (this.input.read() == 119) {
                            if (this.input.read() == 119) {
                                if (this.input.read() == 46) {
                                    foundLinkBegin = true;
                                } else {
                                    this.input.backup(3);
                                }
                            } else {
                                this.input.backup(2);
                            }
                        } else {
                            this.input.backup(1);
                        }
                    }
                    if (!foundLinkBegin) break;
                    while (ch != -1) {
                        ch = this.input.read();
                        if (ch != 93 && ch != 41 && !Character.isWhitespace(ch) && ch != 39 && ch != 34) continue;
                        this.input.backup(1);
                        break;
                    }
                    if (originalLength > 1) {
                        this.input.backup(this.input.readLengthEOF() - originalLength + 1);
                        return this.token(RubyCommentTokenId.COMMENT_TEXT);
                    }
                    if (this.input.readLength() <= 2) break;
                    return this.token(RubyCommentTokenId.COMMENT_LINK);
                }
                case 95: {
                    if (inWord) break;
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(RubyCommentTokenId.COMMENT_TEXT);
                    }
                    while (ch != -1) {
                        ch = this.input.read();
                        if (ch == 95) {
                            int next = this.input.read();
                            this.input.backup(1);
                            if (Character.isLetter(next) || next == 95 || this.input.readLength() <= 2) continue;
                            return this.token(RubyCommentTokenId.COMMENT_ITALIC);
                        }
                        if (Character.isLetter(ch) || ch == 95) continue;
                        this.input.backup(1);
                        break block0;
                    }
                    break;
                }
                case 42: {
                    if (inWord) break;
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(RubyCommentTokenId.COMMENT_TEXT);
                    }
                    while (ch != -1) {
                        ch = this.input.read();
                        if (ch == 42 && this.input.readLength() > 2) {
                            return this.token(RubyCommentTokenId.COMMENT_BOLD);
                        }
                        if (Character.isLetter(ch) || ch == 95) continue;
                        this.input.backup(1);
                        break block0;
                    }
                    break;
                }
                case 43: {
                    if (inWord) break;
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(RubyCommentTokenId.COMMENT_TEXT);
                    }
                    while (ch != -1) {
                        ch = this.input.read();
                        if (ch == 43 && this.input.readLength() > 2) {
                            return this.token(RubyCommentTokenId.COMMENT_HTMLTAG);
                        }
                        if (Character.isLetter(ch) || ch == 95 || ch == 58) continue;
                        this.input.backup(1);
                        break block0;
                    }
                    break;
                }
                case 60: {
                    int next = this.input.read();
                    this.input.backup(1);
                    if (next != 47 && !Character.isLetter(next)) break;
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(RubyCommentTokenId.COMMENT_TEXT);
                    }
                    while (ch != -1 && (ch = this.input.read()) != 10) {
                        if (ch != 62) continue;
                        return this.token(RubyCommentTokenId.COMMENT_HTMLTAG);
                    }
                    break;
                }
                case 58: {
                    ch = this.input.read();
                    if (ch == 58) continue block16;
                    this.input.backup(1);
                    if (((Object)this.input.readText()).toString().endsWith("::")) continue block16;
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(RubyCommentTokenId.COMMENT_TEXT);
                    }
                    int backup = 0;
                    do {
                        if (ch == -1) continue block16;
                        ch = this.input.read();
                        ++backup;
                    } while (ch != 10 && (Character.isLetter(ch) || ch == 95 || ch == 45));
                    if (ch == 58 && this.input.readLength() > 2) {
                        String seen = ((Object)this.input.readText()).toString();
                        String directive = seen.substring(1, seen.length() - 1);
                        for (String keyword : RDOC_DIRECTIVES) {
                            if (!keyword.equals(directive)) continue;
                            return this.token(RubyCommentTokenId.COMMENT_RDOC);
                        }
                    }
                    this.input.backup(backup);
                    continue block16;
                }
                default: {
                    if (inWord) break;
                    String[] todoMarkers = this.getTodoMarkers();
                    for (int i = 0; i < todoMarkers.length; ++i) {
                        if (todoMarkers[i].charAt(0) != ch) continue;
                        if (this.input.readLength() > 1) {
                            this.input.backup(1);
                            return this.token(RubyCommentTokenId.COMMENT_TEXT);
                        }
                        int backup = 0;
                        String marker = todoMarkers[i];
                        int n = marker.length();
                        for (int c = 1; c < n; ++c) {
                            ++backup;
                            if (this.input.read() == marker.charAt(c)) continue;
                            this.input.backup(backup);
                            break;
                        }
                        if (backup != marker.length() - 1) continue;
                        boolean separate = !Character.isJavaIdentifierPart(this.input.read());
                        this.input.backup(1);
                        if (!separate) continue;
                        return this.tokenFactory.createToken((TokenId)RubyCommentTokenId.COMMENT_TODO, this.input.readLength());
                    }
                }
            }
            inWord = Character.isJavaIdentifierPart(ch);
        }
    }

    private Token<RubyCommentTokenId> token(RubyCommentTokenId id) {
        return this.tokenFactory.createToken((TokenId)id);
    }

    public void release() {
    }

    static /* synthetic */ String[] access$002(RubyCommentLexer x0, String[] x1) {
        x0.markers = x1;
        return x1;
    }
}

