/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.elements;

import java.util.Set;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.elements.ClassElement;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.openide.filesystems.FileObject;

public final class IndexedClass
extends IndexedElement
implements ClassElement {
    public static final int MODULE = 64;
    private String in;

    protected IndexedClass(RubyIndex index, IndexResult result, String fqn, String clz, String require, String attributes, int flags, FileObject context) {
        super(index, result, fqn, clz, require, attributes, flags, context);
    }

    public static IndexedClass create(RubyIndex index, String clz, String fqn, IndexResult result, String require, String attributes, int flags, FileObject context) {
        IndexedClass c = new IndexedClass(index, result, fqn, clz, require, attributes, flags, context);
        return c;
    }

    @Override
    public String getIn() {
        if (this.in == null) {
            if (this.fqn.endsWith("::" + this.clz)) {
                this.in = this.fqn.substring(0, this.fqn.length() - (this.clz.length() + 2));
            } else if (this.require != null && this.require.length() > 0) {
                this.in = this.require;
            }
        }
        return this.in;
    }

    @Override
    public RubyType getType() {
        return RubyType.unknown();
    }

    @Override
    public String getSignature() {
        return this.fqn;
    }

    @Override
    public String getName() {
        return this.getClz();
    }

    @Override
    public ElementKind getKind() {
        return (this.flags & 0x40) != 0 ? ElementKind.MODULE : ElementKind.CLASS;
    }

    @Override
    public Set<String> getIncludes() {
        return null;
    }

    @Override
    public int getDocumentationLength() {
        if (this.docLength == -1) {
            if (this.attributes != null) {
                int docIndex = this.attributes.indexOf(59);
                if (docIndex != -1) {
                    int end = this.attributes.indexOf(59, docIndex + 1);
                    if (end == -1) {
                        end = this.attributes.length();
                    }
                    this.docLength = Integer.parseInt(this.attributes.substring(docIndex + 1, end));
                    return this.docLength;
                }
                this.docLength = 1;
            }
            this.docLength = super.getDocumentationLength();
        }
        return this.docLength;
    }

    public static String decodeFlags(int flags) {
        StringBuilder sb = new StringBuilder();
        sb.append(IndexedElement.decodeFlags(flags));
        if ((flags & 0x40) != 0) {
            sb.append("|MODULE");
        }
        if (sb.length() > 0) {
            sb.append("|");
        }
        return sb.toString();
    }

    public static int stringToFlags(String string) {
        int flags = IndexedElement.stringToFlags(string);
        if (string.indexOf("|MODULE") != -1) {
            flags += 64;
        }
        return flags;
    }
}

