/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.CommentNode;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.DefsNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.MultipleAsgnNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.ActiveRecordAssociationFinder;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeAnalyzer;
import org.netbeans.modules.ruby.RubyTypeInferencer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.TestNameResolver;
import org.netbeans.modules.ruby.elements.AstAttributeElement;
import org.netbeans.modules.ruby.elements.AstClassElement;
import org.netbeans.modules.ruby.elements.AstDynamicMethodElement;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.AstFieldElement;
import org.netbeans.modules.ruby.elements.AstMethodElement;
import org.netbeans.modules.ruby.elements.AstModuleElement;
import org.netbeans.modules.ruby.elements.AstNameElement;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.modules.ruby.platform.gems.Gems;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class RubyStructureAnalyzer
implements StructureScanner {
    private static final String ACTIVE_RECORD_NAMED_SCOPE = "ActiveRecord::NamedScope::Scope";
    private static final String CLASSMETHODS = "ClassMethods";
    private Set<AstClassElement> haveAccessModifiers;
    private List<AstElement> structure;
    private Map<AstClassElement, Set<InstAsgnNode>> fields;
    private Map<String, GlobalAsgnNode> globals;
    private Set<String> requires;
    private List<AstMethodElement> methods;
    private Map<AstClassElement, Set<AstAttributeElement>> attributes;
    private RubyParseResult result;
    private RubyIndex index;
    private RubyTypeInferencer typeInferencer;
    private boolean isTestFile;
    private static final String RUBY_KEYWORD = "org/netbeans/modules/ruby/jruby.png";
    private static ImageIcon keywordIcon;
    private static final String ALIAS_METHOD = "alias_method";
    private static final String DEFINE_METHOD = "define_method";
    private AstElement lastClassElement;
    static final String[] DYNAMIC_METHODS;
    private static Set<FileObject> currentlyAnalyzingWithIndex;
    private static final int MAX_RUBY_LABEL_LENGTH = 30;
    private static final String DEFAULT_LABEL = "<% %>";

    public List<? extends StructureItem> scan(ParserResult result) {
        if (RubyUtils.isRhtmlOrYamlFile(RubyUtils.getFileObject((Parser.Result)result))) {
            return this.scanRhtml(result);
        }
        this.result = AstUtilities.getParseResult((Parser.Result)result);
        if (this.result == null) {
            return Collections.emptyList();
        }
        AnalysisResult ar = this.result.getStructure();
        List<? extends AstElement> elements = ar.getElements();
        ArrayList<RubyStructureItem> itemList = new ArrayList<RubyStructureItem>(elements.size());
        for (AstElement astElement : elements) {
            if (astElement.isHidden()) continue;
            itemList.add(new RubyStructureItem(astElement, result));
        }
        return itemList;
    }

    private AnalysisResult scan(RubyParseResult result) {
        AnalysisResult analysisResult = new AnalysisResult();
        Node root = AstUtilities.getRoot((Parser.Result)result);
        if (root == null) {
            return analysisResult;
        }
        this.isTestFile = false;
        String name = RubyUtils.getFileObject((Parser.Result)result).getNameExt();
        int dot = name.lastIndexOf(46);
        if (dot != -1) {
            name = name.substring(0, dot);
        }
        if (name.startsWith("test_") || name.endsWith("_test") || name.endsWith("_spec")) {
            this.isTestFile = true;
        }
        this.structure = new ArrayList<AstElement>();
        this.fields = new HashMap<AstClassElement, Set<InstAsgnNode>>();
        this.attributes = new HashMap<AstClassElement, Set<AstAttributeElement>>();
        this.requires = new HashSet<String>();
        this.methods = new ArrayList<AstMethodElement>();
        this.haveAccessModifiers = new HashSet<AstClassElement>();
        AstPath path = new AstPath();
        path.descend(root);
        ContextKnowledge knowledge = new ContextKnowledge(this.index, root, result);
        knowledge.setAnalyzedMethods(this.methods);
        this.typeInferencer = RubyTypeInferencer.create(knowledge);
        this.scan(root, path, null, null, null);
        path.ascend();
        HashMap<String, InstAsgnNode> names = new HashMap<String, InstAsgnNode>();
        for (AstClassElement clz : this.fields.keySet()) {
            Set<InstAsgnNode> assignments = this.fields.get(clz);
            if (assignments == null) continue;
            for (InstAsgnNode assignment : assignments) {
                names.put(assignment.getName(), assignment);
            }
            for (InstAsgnNode field : names.values()) {
                AstFieldElement co = new AstFieldElement(result, (Node)field);
                co.setIn(clz.getFqn());
                String fieldName = field.getName();
                co.setType(knowledge.getType(fieldName));
                if (fieldName.startsWith("@@")) {
                    fieldName = fieldName.substring(2);
                } else if (fieldName.startsWith("@")) {
                    fieldName = fieldName.substring(1);
                }
                boolean found = false;
                for (AstElement member : clz.getChildren()) {
                    if (member.getKind() != ElementKind.ATTRIBUTE || !member.getName().equals(fieldName)) continue;
                    member.setType(co.getType());
                    found = true;
                    break;
                }
                if (found) {
                    co.setHidden(true);
                }
                clz.addChild(co);
            }
            names.clear();
        }
        if (this.globals != null) {
            ArrayList<String> sortedNames = new ArrayList<String>(this.globals.keySet());
            Collections.sort(sortedNames);
            for (String globalName : sortedNames) {
                GlobalAsgnNode global = this.globals.get(globalName);
                AstNameElement co = new AstNameElement(result, (Node)global, globalName, ElementKind.GLOBAL);
                this.structure.add(co);
            }
            names.clear();
        }
        for (AstClassElement clz : this.haveAccessModifiers) {
            AstMethodElement jn;
            HashSet<Node> protectedMethods = new HashSet<Node>();
            HashSet<Node> privateMethods = new HashSet<Node>();
            AstUtilities.findPrivateMethods(clz.getNode(), protectedMethods, privateMethods);
            if (privateMethods.size() > 0) {
                for (AstMethodElement o : this.methods) {
                    if (!(o instanceof AstMethodElement) || !privateMethods.contains((jn = o).getNode())) continue;
                    jn.setAccess(Modifier.PRIVATE);
                }
            }
            if (protectedMethods.size() <= 0) continue;
            for (AstMethodElement o : this.methods) {
                if (!(o instanceof AstMethodElement) || !protectedMethods.contains((jn = o).getNode())) continue;
                jn.setAccess(Modifier.PROTECTED);
            }
        }
        analysisResult.setElements(this.structure);
        analysisResult.setAttributes(this.attributes);
        analysisResult.setRequires(this.requires);
        return analysisResult;
    }

    private boolean isRails3File() {
        FileObject file = RubyUtils.getFileObject((Parser.Result)this.result);
        for (String railsGem : Gems.getRailsGems()) {
            if (file.getPath().indexOf(railsGem + "-3.") <= 0) continue;
            return true;
        }
        return false;
    }

    private AnalysisResult getCachedAnalysis(RubyParseResult result) {
        return null;
    }

    private void cacheAnalysis(RubyParseResult result, AnalysisResult scan) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<OffsetRange>> folds(ParserResult result) {
        HashMap<String, List<OffsetRange>> folds;
        block7: {
            if (RubyUtils.isRhtmlFile(RubyUtils.getFileObject((Parser.Result)result))) {
                return Collections.emptyMap();
            }
            Node root = AstUtilities.getRoot((Parser.Result)result);
            if (root == null) {
                return Collections.emptyMap();
            }
            RubyParseResult rpr = AstUtilities.getParseResult((Parser.Result)result);
            AnalysisResult analysisResult = rpr.getStructure();
            folds = new HashMap<String, List<OffsetRange>>();
            ArrayList<OffsetRange> codefolds = new ArrayList<OffsetRange>();
            folds.put("codeblocks", codefolds);
            try {
                BaseDocument doc = RubyUtils.getDocument((Parser.Result)result);
                if (doc == null) break block7;
                try {
                    doc.readLock();
                    this.addFolds(doc, analysisResult.getElements(), folds, codefolds);
                }
                finally {
                    doc.readUnlock();
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return folds;
    }

    private void addFolds(BaseDocument doc, List<? extends AstElement> elements, Map<String, List<OffsetRange>> folds, List<OffsetRange> codeblocks) throws BadLocationException {
        for (AstElement astElement : elements) {
            List<AstElement> children;
            ElementKind kind = astElement.getKind();
            switch (kind) {
                case METHOD: 
                case CONSTRUCTOR: 
                case CLASS: 
                case MODULE: {
                    Node node = astElement.getNode();
                    OffsetRange range = AstUtilities.getRange(node);
                    int start = range.getStart();
                    start = Utilities.getRowEnd((BaseDocument)doc, (int)start);
                    int end = range.getEnd();
                    if (start == -1 || end == -1 || start >= end || end > doc.getLength()) break;
                    range = new OffsetRange(start, end);
                    codeblocks.add(range);
                    break;
                }
                case TEST: {
                    Node node = astElement.getNode();
                    OffsetRange range = AstUtilities.getRange(node);
                    int start = range.getStart();
                    start = Utilities.getRowEnd((BaseDocument)doc, (int)start);
                    int end = range.getEnd();
                    if (start == -1 || end == -1 || start >= end || end > doc.getLength()) break;
                    range = new OffsetRange(start, end);
                    codeblocks.add(range);
                    break;
                }
            }
            if ((children = astElement.getChildren()) == null || children.size() <= 0) continue;
            this.addFolds(doc, children, folds, codeblocks);
        }
    }

    private void addToParent(AstElement parent, AstElement child) {
        if (parent != null) {
            parent.addChild(child);
        } else {
            this.structure.add(child);
        }
        if (child.getKind() == ElementKind.CLASS || child.getKind() == ElementKind.MODULE) {
            this.lastClassElement = child;
        }
    }

    private void scan(Node node, AstPath path, String in, Set<String> includes, AstElement parent) {
        switch (node.getNodeType()) {
            case CLASSNODE: {
                AstElement co = new AstClassElement(this.result, node);
                co.setIn(in);
                String fqn = AstUtilities.getFqnName(path);
                ((AstClassElement)co).setFqn(fqn);
                in = AstUtilities.getClassOrModuleName((IScopingNode)((ClassNode)node));
                includes = new HashSet<String>();
                ((AstClassElement)co).setIncludes(includes);
                this.addToParent(parent, co);
                parent = co;
                break;
            }
            case MODULENODE: {
                AstElement co = new AstModuleElement(this.result, node);
                co.setIn(in);
                String moduleFqn = AstUtilities.getFqnName(path);
                ((AstModuleElement)co).setFqn(moduleFqn);
                in = AstUtilities.getClassOrModuleName((IScopingNode)((ModuleNode)node));
                if (CLASSMETHODS.equals(in) && parent instanceof AstModuleElement && this.isRails3File()) {
                    ((AstModuleElement)parent).setExtendWith(moduleFqn);
                }
                this.addToParent(parent, co);
                parent = co;
                includes = new HashSet<String>();
                ((AstModuleElement)co).setIncludes(includes);
                break;
            }
            case SCLASSNODE: {
                AstElement co = new AstClassElement(this.result, node);
                co.setIn(in);
                ((AstClassElement)co).setFqn(AstUtilities.getFqnName(path));
                Node receiver = ((SClassNode)node).getReceiverNode();
                in = receiver instanceof INameNode ? AstUtilities.getName(receiver) : null;
                includes = new HashSet<String>();
                ((AstClassElement)co).setIncludes(includes);
                this.addToParent(parent, co);
                parent = co;
                break;
            }
            case DEFNNODE: 
            case DEFSNODE: {
                String extendWith;
                AstElement co = new AstMethodElement(this.result, node);
                this.methods.add((AstMethodElement)co);
                String clzFqn = AstUtilities.getFqnName(path);
                co.setIn(clzFqn);
                if (node instanceof DefnNode && "initialize".equals(AstUtilities.getName(node))) {
                    ((AstMethodElement)co).setAccess(Modifier.PRIVATE);
                } else if (parent != null && parent.getNode() instanceof SClassNode) {
                    ((AstMethodElement)co).setModifiers(EnumSet.of(Modifier.STATIC));
                }
                if (node instanceof DefsNode && parent instanceof AstModuleElement && "included".equals(AstUtilities.getName(node)) && (extendWith = this.getExtendWith((MethodDefNode)((DefsNode)node))) != null) {
                    if (extendWith.indexOf(58) == -1) {
                        String fqn = AstUtilities.getFqnName(path);
                        extendWith = fqn + "::" + extendWith;
                    }
                    ((AstModuleElement)parent).setExtendWith(extendWith);
                }
                if (node instanceof DefnNode || node instanceof DefsNode) {
                    RubyType type = new RubyType();
                    type.append(this.typeInferencer.inferType(node));
                    co.setType(type);
                }
                this.addToParent(parent, co);
                break;
            }
            case CONSTDECLNODE: {
                ConstDeclNode constNode = (ConstDeclNode)node;
                AstNameElement co = new AstNameElement(this.result, node, AstUtilities.getName(node), ElementKind.CONSTANT);
                co.setType(this.typeInferencer.inferTypesOfRHS((Node)constNode));
                co.setIn(in);
                this.addToParent(parent, co);
                break;
            }
            case CLASSVARDECLNODE: {
                AstElement co = new AstFieldElement(this.result, node);
                co.setIn(in);
                this.addToParent(parent, co);
                break;
            }
            case GLOBALASGNNODE: {
                if (this.globals == null) {
                    this.globals = new HashMap<String, GlobalAsgnNode>();
                }
                GlobalAsgnNode global = (GlobalAsgnNode)node;
                this.globals.put(global.getName(), global);
                break;
            }
            case INSTASGNNODE: {
                AstClassElement classParent = this.findClassParent(parent);
                if (classParent == null) break;
                Set<InstAsgnNode> assignments = this.fields.get(classParent);
                if (assignments == null) {
                    assignments = new HashSet<InstAsgnNode>();
                    this.fields.put(classParent, assignments);
                }
                assignments.add((InstAsgnNode)node);
                break;
            }
            case VCALLNODE: {
                String name = AstUtilities.getName(node);
                if (!"private".equals(name) && !"protected".equals(name) || !(parent instanceof AstClassElement)) break;
                this.haveAccessModifiers.add((AstClassElement)parent);
                break;
            }
            case MULTIPLEASGNNODE: {
                HashMap<Node, RubyType> vars = new HashMap<Node, RubyType>();
                RubyTypeAnalyzer.collectMultipleAsgnVars((MultipleAsgnNode)node, this.typeInferencer, vars);
                block19: for (Node each : vars.keySet()) {
                    switch (each.getNodeType()) {
                        case LOCALASGNNODE: {
                            if (parent != null || AstUtilities.findMethod(path) != null) break;
                            String name = AstUtilities.getName(each);
                            if (this.findExistingVariable(name) != null) continue block19;
                            AstNameElement co = new AstNameElement(this.result, each, name, ElementKind.VARIABLE);
                            co.setType((RubyType)vars.get(each));
                            co.setIn(in);
                            this.structure.add(co);
                            break;
                        }
                        case INSTASGNNODE: {
                            AstClassElement classParent = this.findClassParent(parent);
                            if (classParent == null) break;
                            Set<InstAsgnNode> assignments = this.fields.get(classParent);
                            if (assignments == null) {
                                assignments = new HashSet<InstAsgnNode>();
                                this.fields.put(classParent, assignments);
                            }
                            assignments.add((InstAsgnNode)each);
                            break;
                        }
                    }
                }
                break;
            }
            case LOCALASGNNODE: {
                boolean found;
                if (parent != null || AstUtilities.findMethod(path) != null) break;
                String name = AstUtilities.getName(node);
                boolean bl = found = this.findExistingVariable(name) != null;
                if (found) break;
                AstElement co = new AstNameElement(this.result, node, name, ElementKind.VARIABLE);
                assert (node instanceof LocalAsgnNode) : "LocalAsgnNode expected";
                co.setType(this.typeInferencer.inferTypesOfRHS(node));
                co.setIn(in);
                this.structure.add(co);
                break;
            }
            case ALIASNODE: {
                AliasNode aliasNode = (AliasNode)node;
                String aliasedMethodName = AstUtilities.getNameOrValue(aliasNode.getOldName());
                if (aliasedMethodName == null) break;
                this.addAliasedMethod(aliasedMethodName, (Node)aliasNode, parent, in);
                break;
            }
            case FCALLNODE: {
                ListNode args;
                Iterator<String> i$;
                SymbolNode method;
                SymbolNode[] symbols;
                Node newMethod;
                List<Node> values;
                ListNode args2;
                Node argsNode;
                AstElement co;
                String name = AstUtilities.getName(node);
                if (name.equals("require")) {
                    String require;
                    Node n;
                    argsNode = ((FCallNode)node).getArgsNode();
                    if (argsNode instanceof ListNode && (args2 = (ListNode)argsNode).size() > 0 && (n = args2.get(0)) instanceof StrNode && (require = ((StrNode)n).getValue()) != null && require.length() > 0) {
                        this.requires.add(require.toString());
                    }
                } else if (ALIAS_METHOD.equals(name)) {
                    values = AstUtilities.getChildValues(node);
                    if (values.size() == 2) {
                        newMethod = values.get(0);
                        String aliasedMethodName = AstUtilities.getNameOrValue(values.get(1));
                        this.addAliasedMethod(aliasedMethodName, newMethod, parent, in);
                    }
                } else if (DEFINE_METHOD.equals(name)) {
                    String newMethodName;
                    values = AstUtilities.getChildValues(node);
                    if (!values.isEmpty() && (newMethodName = AstUtilities.getNameOrValue(newMethod = values.get(0))) != null) {
                        Node iter;
                        AstDynamicMethodElement co2 = new AstDynamicMethodElement(this.result, newMethod);
                        co2.setIn(in);
                        if (values.size() == 1 && (iter = ((FCallNode)node).getIterNode()) != null) {
                            co2.setType(this.typeInferencer.inferType(iter));
                        }
                        co2.setHidden(true);
                        this.addToParent(parent, co2);
                    }
                } else if (AstUtilities.isNamedScope(node)) {
                    symbols = AstUtilities.getSymbols(node);
                    if (symbols.length > 0) {
                        method = symbols[0];
                        AstDynamicMethodElement co3 = new AstDynamicMethodElement(this.result, (Node)method);
                        co3.setIn(in);
                        co3.setModifiers(EnumSet.of(Modifier.PUBLIC, Modifier.STATIC));
                        if (in != null && in.length() > 0 && Character.isUpperCase(in.charAt(0))) {
                            co3.setType(new RubyType(ACTIVE_RECORD_NAMED_SCOPE, in));
                        }
                        co3.setHidden(true);
                        this.addToParent(parent, co3);
                    }
                } else if (AstUtilities.isActiveRecordAssociation(node)) {
                    symbols = AstUtilities.getSymbols(node);
                    if (symbols.length > 0) {
                        method = symbols[0];
                        method.getName();
                        AstDynamicMethodElement co4 = new AstDynamicMethodElement(this.result, (Node)method);
                        co4.setIn(in);
                        co4.setModifiers(EnumSet.of(Modifier.PUBLIC));
                        String type = ActiveRecordAssociationFinder.getClassNameFor(node, method);
                        if (type != null && type.length() > 0) {
                            co4.setType(RubyType.create(type));
                        }
                        co4.setHidden(true);
                        this.addToParent(parent, co4);
                    }
                } else if (includes != null && name.equals("include")) {
                    argsNode = ((FCallNode)node).getArgsNode();
                    if (argsNode instanceof ListNode) {
                        includes.addAll(AstUtilities.getValuesAsFqn((ListNode)argsNode));
                    }
                } else if (("private".equals(name) || "protected".equals(name)) && parent instanceof AstClassElement) {
                    this.haveAccessModifiers.add((AstClassElement)parent);
                } else if (AstUtilities.isAttr(node)) {
                    symbols = AstUtilities.getAttrSymbols(node);
                    if (symbols != null && symbols.length > 0) {
                        for (SymbolNode s : symbols) {
                            AstAttributeElement co5 = new AstAttributeElement(this.result, s, node);
                            if (parent instanceof AstClassElement) {
                                Set<AstAttributeElement> attrsInClass = this.attributes.get(parent);
                                if (attrsInClass == null) {
                                    attrsInClass = new HashSet<AstAttributeElement>();
                                    this.attributes.put((AstClassElement)parent, attrsInClass);
                                }
                                for (AstAttributeElement attr : attrsInClass) {
                                    if (!attr.getName().equals(s.getName())) continue;
                                    co5.setHidden(true);
                                }
                                attrsInClass.add(co5);
                            }
                            this.addToParent(parent, co5);
                        }
                    }
                } else if (name.equals("module_function")) {
                    argsNode = ((FCallNode)node).getArgsNode();
                    if (argsNode instanceof ListNode) {
                        args2 = (ListNode)argsNode;
                        int m = args2.size();
                        for (int j = 0; j < m; ++j) {
                            String func;
                            Node n = args2.get(j);
                            if (!(n instanceof SymbolNode) || (func = AstUtilities.getName(n)) == null || func.length() <= 0) continue;
                            AstElement method2 = null;
                            for (AstMethodElement o : this.methods) {
                                AstMethodElement jn;
                                if (!(o instanceof AstMethodElement) || !func.equals((jn = o).getName())) continue;
                                method2 = jn;
                                break;
                            }
                            if (method2 == null) continue;
                            Node dupeNode = method2.getNode();
                            AstMethodElement co6 = new AstMethodElement(this.result, dupeNode);
                            co6.setIn(in);
                            if (dupeNode instanceof DefnNode && "initialize".equals(AstUtilities.getName(dupeNode))) {
                                co6.setAccess(Modifier.PRIVATE);
                            }
                            co6.setModifiers(EnumSet.of(Modifier.STATIC));
                            this.addToParent(parent, co6);
                        }
                    }
                } else if (this.isTestFile && parent == null && TestNameResolver.isRspecDescribe(name)) {
                    String className = RubyUtils.underlinedNameToCamel(RubyUtils.getFileObject((Parser.Result)this.result).getName());
                    co = new AstClassElement(this.result, node);
                    co.setIn(in);
                    ((AstClassElement)co).setFqn(className);
                    ((AstClassElement)co).setName(className);
                    co.setHidden(false);
                    ((AstClassElement)co).setVirtual(true);
                    in = className;
                    this.addToParent(parent, co);
                    parent = co;
                }
                if (!this.isTestFile || !TestNameResolver.isTestMethodName(name)) break;
                String desc = name;
                FCallNode fc = (FCallNode)node;
                if (fc.getIterNode() == null && !"it".equals(name)) break;
                Node argsNode2 = fc.getArgsNode();
                if (argsNode2 instanceof ListNode && (i$ = AstUtilities.getNamesOrValues(args = (ListNode)argsNode2).iterator()).hasNext()) {
                    String descBl;
                    desc = descBl = i$.next();
                    if (TestNameResolver.isShouldaMethod(name)) {
                        String shouldaMethodName = TestNameResolver.getTestName(path);
                        AstDynamicMethodElement co7 = new AstDynamicMethodElement(this.result, node, shouldaMethodName);
                        co7.setHidden(true);
                        co7.setIn(in);
                        this.addToParent(this.lastClassElement, co7);
                    }
                    if (!name.equals("test")) {
                        desc = name + ": " + desc;
                    }
                }
                AstNameElement co8 = new AstNameElement(this.result, node, desc, ElementKind.TEST);
                this.addToParent(parent, co8);
                parent = co8;
            }
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            path.descend(child);
            this.scan(child, path, in, includes, parent);
            path.ascend();
        }
    }

    private AstClassElement findClassParent(AstElement candidate) {
        if (candidate instanceof AstClassElement) {
            return (AstClassElement)candidate;
        }
        if (this.isTestFile && this.lastClassElement instanceof AstClassElement) {
            return (AstClassElement)this.lastClassElement;
        }
        return null;
    }

    private void addAliasedMethod(String aliasedMethodName, Node newMethod, AstElement parent, String in) {
        AstMethodElement aliased;
        if (aliasedMethodName != null && aliasedMethodName.trim().length() > 0 && (aliased = this.findExistingMethod(aliasedMethodName)) != null) {
            AstDynamicMethodElement co = new AstDynamicMethodElement(this.result, newMethod);
            co.setModifiers(aliased.getModifiers());
            co.setParameters(aliased.getParameters());
            co.setIn(in);
            co.setType(aliased.getType());
            co.setHidden(true);
            this.addToParent(parent, co);
        }
    }

    private AstElement findExistingVariable(String name) {
        for (AstElement child : this.structure) {
            if (child.getKind() != ElementKind.VARIABLE || !name.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    private AstMethodElement findExistingMethod(String name) {
        for (AstMethodElement each : this.methods) {
            if (!each.getClass().equals(AstMethodElement.class) || !each.getName().equals(name)) continue;
            return each;
        }
        return null;
    }

    private String getExtendWith(MethodDefNode node) {
        ListNode args;
        List<String> argList = AstUtilities.getDefArgs(node, true);
        if (argList == null || argList.size() != 1) {
            return null;
        }
        String param = argList.get(0);
        CallNode call = this.findExtendCall((Node)node);
        if (call == null) {
            return null;
        }
        Node receiver = call.getReceiverNode();
        if (receiver == null || !(receiver instanceof INameNode)) {
            return null;
        }
        String receiverName = AstUtilities.getName(receiver);
        if (!param.equals(receiverName)) {
            return null;
        }
        Node argsNode = call.getArgsNode();
        if (argsNode instanceof ListNode && (args = (ListNode)argsNode).size() == 1) {
            Node n = args.get(0);
            String rn = null;
            if (n instanceof Colon2Node) {
                rn = AstUtilities.getName(n);
            } else if (n instanceof ConstNode) {
                rn = AstUtilities.getName(n);
            }
            return rn;
        }
        return null;
    }

    private CallNode findExtendCall(Node node) {
        CallNode call;
        if (node instanceof CallNode && "extend".equals((call = (CallNode)node).getName())) {
            return call;
        }
        List list = node.childNodes();
        for (Node child : list) {
            CallNode call2;
            if (child.isInvisible() || (call2 = this.findExtendCall(child)) == null) continue;
            return call2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AnalysisResult analyze(RubyParseResult result) {
        AnalysisResult scan = this.getCachedAnalysis(result);
        if (scan != null) {
            return scan;
        }
        boolean addedWithIndex = false;
        FileObject toAnalyze = RubyUtils.getFileObject((Parser.Result)result);
        try {
            addedWithIndex = currentlyAnalyzingWithIndex.add(toAnalyze);
            if (addedWithIndex && result != null) {
                this.index = RubyIndex.get((Parser.Result)result);
            }
            this.result = result;
            scan = this.scan(result);
            result.setStructure(scan);
            this.cacheAnalysis(result, scan);
            AnalysisResult analysisResult = scan;
            return analysisResult;
        }
        finally {
            if (addedWithIndex) {
                boolean removed = currentlyAnalyzingWithIndex.remove(toAnalyze);
                assert (removed) : "consistent state";
            }
        }
    }

    public void addComments(RubyParseResult result) {
        Node root = result.getRootNode();
        if (root == null) {
            return;
        }
        org.jrubyparser.parser.ParserResult r = result.getJRubyResult();
        List comments = r.getCommentNodes();
        for (CommentNode comment : comments) {
            SourcePosition pos = comment.getPosition();
            int start = pos.getStartOffset();
            int end = pos.getEndOffset();
            Node node = this.findClosest(root, start, end);
            assert (node != null);
            node.addComment(comment);
        }
    }

    private Node findClosest(Node node, int start, int end) {
        List list = node.childNodes();
        SourcePosition pos = node.getPosition();
        if (end < pos.getStartOffset()) {
            return node;
        }
        if (start > pos.getEndOffset()) {
            return null;
        }
        for (Node child : list) {
            Node closest;
            if (child.isInvisible() || (closest = this.findClosest(child, start, end)) == null) continue;
            return closest;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<? extends StructureItem> scanRhtml(ParserResult result) {
        ArrayList<RhtmlStructureItem> items = new ArrayList<RhtmlStructureItem>();
        BaseDocument doc = RubyUtils.getDocument((Parser.Result)result);
        if (doc == null) {
            return Collections.emptyList();
        }
        doc.readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            TokenSequence ts = th.tokenSequence();
            if (ts == null) {
                ArrayList<RhtmlStructureItem> arrayList = items;
                return arrayList;
            }
            ts.moveStart();
            while (ts.moveNext()) {
                TokenId id = ts.token().id();
                if (!id.name().equals("DELIMITER")) continue;
                int start = ts.offset();
                if (!ts.moveNext()) continue;
                Token token = ts.token();
                int end = ts.offset() + token.length();
                if (!token.id().name().equals("DELIMITER")) {
                    while (ts.moveNext()) {
                        if (!ts.token().id().name().equals("DELIMITER")) continue;
                        end = ts.offset() + token.length();
                        break;
                    }
                }
                String name = RubyStructureAnalyzer.navigatorName((Document)doc, th, start);
                items.add(new RhtmlStructureItem(name, start, end));
            }
        }
        finally {
            doc.readUnlock();
        }
        return items;
    }

    public static String navigatorName(Document doc, TokenHierarchy th, int offset) {
        TokenSequence t;
        TokenId id;
        TokenSequence ts = th.tokenSequence();
        ts.move(offset);
        if (ts.moveNext() && (id = ts.token().id()).name().equals("DELIMITER") && ts.moveNext() && (id = ts.token().id()).name().startsWith("RUBY") && (t = ts.embedded()) != null) {
            TokenId newId;
            t.moveStart();
            if (!t.moveNext()) {
                return DEFAULT_LABEL;
            }
            while (t.token().id() == RubyTokenId.WHITESPACE && t.moveNext()) {
            }
            int begin = t.offset();
            id = t.token().id();
            if (id == RubyTokenId.WHITESPACE) {
                return DEFAULT_LABEL;
            }
            if (id == RubyTokenId.IDENTIFIER && TokenUtilities.equals((CharSequence)t.token().text(), (Object)"h")) {
                if (!t.moveNext()) {
                    int end = t.offset() + t.token().length();
                    return RubyStructureAnalyzer.createName(doc, begin, end);
                }
                while (t.token().id() == RubyTokenId.WHITESPACE && t.moveNext()) {
                }
                id = t.token().id();
            }
            if (id == RubyTokenId.STRING_BEGIN || id == RubyTokenId.QUOTED_STRING_BEGIN || id == RubyTokenId.REGEXP_BEGIN) {
                while (t.moveNext()) {
                    id = t.token().id();
                    if (id != RubyTokenId.STRING_END && id != RubyTokenId.QUOTED_STRING_END && id != RubyTokenId.REGEXP_END) continue;
                    int end = t.offset() + t.token().length();
                    return RubyStructureAnalyzer.createName(doc, begin, end);
                }
            }
            int end = t.offset() + t.token().length();
            if (t.moveNext() && ((newId = t.token().id()) == RubyTokenId.DOT || id == RubyTokenId.LPAREN) && t.moveNext()) {
                end = t.offset() + t.token().length();
            }
            return RubyStructureAnalyzer.createName(doc, begin, end);
        }
        return DEFAULT_LABEL;
    }

    private static String createName(Document doc, int begin, int end) {
        try {
            String content;
            int newline;
            boolean truncated = false;
            int length = end - begin;
            if (begin + length > doc.getLength()) {
                length = doc.getLength() - begin;
                truncated = true;
            }
            if (length > 30) {
                length = 30;
                truncated = true;
            }
            if ((newline = (content = doc.getText(begin, length)).indexOf(10)) != -1) {
                if (content.startsWith("<%\n") || content.startsWith("<%#\n")) {
                    if ((newline = (content = content.substring(newline + 1)).indexOf(10)) != -1) {
                        content = content.substring(0, newline);
                    }
                } else {
                    boolean startsWithNewline = true;
                    for (int i = 0; i < newline; ++i) {
                        if (Character.isWhitespace(content.charAt(i))) continue;
                        startsWithNewline = false;
                        break;
                    }
                    content = startsWithNewline ? content.substring(newline + 1) : content.substring(0, newline);
                }
            }
            if (truncated) {
                return content + "...";
            }
            return content;
        }
        catch (BadLocationException badLocationException) {
            return DEFAULT_LABEL;
        }
    }

    public StructureScanner.Configuration getConfiguration() {
        return null;
    }

    static {
        DYNAMIC_METHODS = new String[]{ALIAS_METHOD, DEFINE_METHOD};
        currentlyAnalyzingWithIndex = new HashSet<FileObject>();
    }

    private static class RhtmlElementHandle
    implements ElementHandle {
        private final String name;

        public RhtmlElementHandle(String name) {
            this.name = name;
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getIn() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return this.name.equals(handle.getName());
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }
    }

    private static class RhtmlStructureItem
    implements StructureItem {
        private final String name;
        private final int start;
        private final int end;
        private final ElementHandle handle;

        public RhtmlStructureItem(String name, int start, int end) {
            this.name = name;
            this.start = start;
            this.end = end;
            this.handle = new RhtmlElementHandle(name);
        }

        public String getName() {
            return this.name;
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.appendText(this.name);
            return formatter.getText();
        }

        public ElementHandle getElementHandle() {
            return this.handle;
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return true;
        }

        public List<? extends StructureItem> getNestedItems() {
            return Collections.emptyList();
        }

        public long getPosition() {
            return this.start;
        }

        public long getEndPosition() {
            return this.end;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
            return hash;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof RubyStructureItem)) {
                return false;
            }
            RubyStructureItem d = (RubyStructureItem)o;
            return this.getName().equals(d.getName());
        }

        public ImageIcon getCustomIcon() {
            if (keywordIcon == null) {
                keywordIcon = ImageUtilities.loadImageIcon((String)RubyStructureAnalyzer.RUBY_KEYWORD, (boolean)false);
            }
            return keywordIcon;
        }

        public String getSortText() {
            return Integer.toHexString(10000 + (int)this.getPosition());
        }
    }

    private class RubyStructureItem
    implements StructureItem {
        AstElement node;
        ElementKind kind;
        ParserResult result;

        private RubyStructureItem(AstElement node, ParserResult result) {
            this.node = node;
            this.result = result;
            this.kind = node.getKind();
        }

        public String getName() {
            return this.node.getName();
        }

        public String getHtml(HtmlFormatter formatter) {
            RubyType type;
            AstMethodElement jn;
            List<String> parameters;
            formatter.reset();
            formatter.appendText(this.node.getName());
            if ((this.kind == ElementKind.METHOD || this.kind == ElementKind.CONSTRUCTOR) && (parameters = (jn = (AstMethodElement)this.node).getParameters()) != null && parameters.size() > 0) {
                formatter.appendHtml("(");
                formatter.parameters(true);
                Iterator it = parameters.iterator();
                while (it.hasNext()) {
                    String ve = (String)it.next();
                    formatter.appendText(ve);
                    if (!it.hasNext()) continue;
                    formatter.appendHtml(", ");
                }
                formatter.parameters(false);
                formatter.appendHtml(")");
            }
            if ((type = this.node.getType()).isKnown()) {
                formatter.appendHtml("<font color='#777777'>");
                formatter.appendHtml(" : ");
                formatter.appendText(this.typeAsString(type));
                formatter.appendHtml("</font>");
            }
            return formatter.getText();
        }

        private String typeAsString(RubyType type) {
            String types = type.asString(", ");
            if (type.hasUnknownMember()) {
                NbBundle.getMessage(RubyStructureAnalyzer.class, (String)"RubyUnknownType");
                types = types + ", " + NbBundle.getMessage(RubyStructureAnalyzer.class, (String)"RubyUnknownType");
            }
            return types;
        }

        public ElementHandle getElementHandle() {
            return this.node;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public Set<Modifier> getModifiers() {
            return this.node.getModifiers();
        }

        public boolean isLeaf() {
            switch (this.kind) {
                case METHOD: 
                case CONSTRUCTOR: 
                case ATTRIBUTE: 
                case CONSTANT: 
                case FIELD: 
                case KEYWORD: 
                case VARIABLE: 
                case GLOBAL: 
                case OTHER: {
                    return true;
                }
                case CLASS: 
                case MODULE: {
                    return false;
                }
                case TEST: {
                    List<AstElement> nested = this.node.getChildren();
                    return nested == null || nested.size() == 0;
                }
            }
            throw new RuntimeException("Unhandled kind: " + this.kind);
        }

        public List<? extends StructureItem> getNestedItems() {
            List<AstElement> nested = this.node.getChildren();
            if (nested != null && nested.size() > 0) {
                ArrayList<RubyStructureItem> children = new ArrayList<RubyStructureItem>(nested.size());
                for (AstElement co : nested) {
                    if (co.isHidden()) continue;
                    children.add(new RubyStructureItem(co, this.result));
                }
                return children;
            }
            return Collections.emptyList();
        }

        public long getPosition() {
            return this.node.getNode().getPosition().getStartOffset();
        }

        public long getEndPosition() {
            return this.node.getNode().getPosition().getEndOffset();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof RubyStructureItem)) {
                return false;
            }
            RubyStructureItem d = (RubyStructureItem)o;
            if (this.kind != d.kind) {
                return false;
            }
            if (!this.getName().equals(d.getName())) {
                return false;
            }
            if (this.kind == ElementKind.METHOD || this.kind == ElementKind.CONSTRUCTOR) {
                Arity darity;
                Arity arity = Arity.getDefArity(this.node.getNode());
                if (!arity.equals(darity = Arity.getDefArity(d.node.getNode()))) {
                    return false;
                }
                if (!((Object)this.getModifiers()).equals(d.getModifiers())) {
                    return false;
                }
                List<String> parameters = ((AstMethodElement)this.node).getParameters();
                List<String> dparameters = ((AstMethodElement)d.node).getParameters();
                if (parameters == null) {
                    return dparameters == null;
                }
                return ((Object)parameters).equals(dparameters);
            }
            return true;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
            hash = 29 * hash + (this.kind != null ? this.kind.hashCode() : 0);
            if (this.kind == ElementKind.METHOD || this.kind == ElementKind.CONSTRUCTOR) {
                Arity arity = Arity.getDefArity(this.node.getNode());
                hash = 37 * hash + arity.hashCode();
            }
            return hash;
        }

        public String toString() {
            return this.getName() + " (kind: " + this.kind + ')';
        }

        public ImageIcon getCustomIcon() {
            Node astNode;
            if (this.kind == ElementKind.TEST && (astNode = this.node.getNode()) instanceof INameNode && "test".equals(AstUtilities.getName(astNode))) {
                return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/csl/source/resources/icons/methodPublic.png", (boolean)false);
            }
            return null;
        }

        public String getSortText() {
            return this.getName();
        }
    }

    public static class AnalysisResult {
        private List<? extends AstElement> elements;
        private Map<AstClassElement, Set<AstAttributeElement>> attributes;
        private Set<String> requires;

        private AnalysisResult() {
        }

        public AstElement getElementFor(Node node) {
            for (AstElement astElement : this.getElements()) {
                AstElement result = this.findElement(astElement, node);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public AstElement findElement(AstElement element, Node node) {
            if (element.getNode() == node) {
                return element;
            }
            for (AstElement child : element.getChildren()) {
                if (child.getNode() == node) {
                    return child;
                }
                AstElement result = this.findElement(child, node);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public Set<String> getRequires() {
            return this.requires;
        }

        public void setRequires(Set<String> requires) {
            this.requires = requires;
        }

        private void setElements(List<? extends AstElement> elements) {
            this.elements = elements;
        }

        private void setAttributes(Map<AstClassElement, Set<AstAttributeElement>> attributes) {
            this.attributes = attributes;
        }

        public Map<AstClassElement, Set<AstAttributeElement>> getAttributes() {
            return this.attributes;
        }

        public List<? extends AstElement> getElements() {
            if (this.elements == null) {
                return Collections.emptyList();
            }
            return this.elements;
        }
    }
}

