/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.RubyBaseCompleter;
import org.netbeans.modules.ruby.RubyCodeCompleter;
import org.netbeans.modules.ruby.RubyCompletionItem;
import org.netbeans.modules.ruby.elements.CommentElement;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

final class RubyStringCompleter
extends RubyBaseCompleter {
    private static final String[] RUBY_PERCENT_WORDS = new String[]{"%q", "String (single-quoting rules)", "%Q", "String (double-quoting rules)", "%r", "Regular Expression", "%x", "Commands", "%W", "String Array (double quoting rules)", "%w", "String Array (single quoting rules)", "%s", "Symbol"};
    private static final String[] RUBY_REGEXP_WORDS = new String[]{"^", "Start of line", "$", "End of line", "\\A", "Beginning of string", "\\z", "End of string", "\\Z", "End of string (except \\n)", "\\w", "Letter or digit; same as [0-9A-Za-z]", "\\W", "Neither letter or digit", "\\s", "Space character; same as [ \\t\\n\\r\\f]", "\\S", "Non-space character", "\\d", "Digit character; same as [0-9]", "\\D", "Non-digit character", "\\b", "Backspace (0x08) (only if in a range specification)", "\\b", "Word boundary (if not in a range specification)", "\\B", "Non-word boundary", "*", "Zero or more repetitions of the preceding", "+", "One or more repetitions of the preceding", "{m,n}", "At least m and at most n repetitions of the preceding", "?", "At most one repetition of the preceding; same as {0,1}", "|", "Either preceding or next expression may match", "()", "Grouping", "[:alnum:]", "Alphanumeric character class", "[:alpha:]", "Uppercase or lowercase letter", "[:blank:]", "Blank and tab", "[:cntrl:]", "Control characters (at least 0x00-0x1f,0x7f)", "[:digit:]", "Digit", "[:graph:]", "Printable character excluding space", "[:lower:]", "Lowecase letter", "[:print:]", "Any printable letter (including space)", "[:punct:]", "Printable character excluding space and alphanumeric", "[:space:]", "Whitespace (same as \\s)", "[:upper:]", "Uppercase letter", "[:xdigit:]", "Hex digit (0-9, a-f, A-F)"};
    private static final String[] RUBY_STRING_PAIRS = new String[]{"(", "(delimiters)", "{", "{delimiters}", "[", "[delimiters]", "x", "<i>x</i>delimiters<i>x</i>"};
    private static final String[] RUBY_QUOTED_STRING_ESCAPES = new String[]{"\\a", "Bell/alert (0x07)", "\\b", "Backspace (0x08)", "\\x", "\\x<i>nn</i>: Hex <i>nn</i>", "\\e", "Escape (0x1b)", "\\c", "Control-<i>x</i>", "\\C-", "Control-<i>x</i>", "\\f", "Formfeed (0x0c)", "\\n", "Newline (0x0a)", "\\M-", "\\M-<i>x</i>: Meta-<i>x</i>", "\\r", "Return (0x0d)", "\\M-\\C-", "Meta-control-<i>x</i>", "\\s", "Space (0x20)", "\\", "\\nnn Octal <i>nnn</i>", "\\t", "Tab (0x09)", "#{", "#{expr}: Value of expr", "\\v", "Vertical tab (0x0b)"};

    static boolean complete(List<? super CompletionProposal> proposals, CompletionRequest request, int anchor, boolean caseSensitive) {
        RubyStringCompleter rsc = new RubyStringCompleter(proposals, request, anchor, caseSensitive);
        return rsc.complete();
    }

    private RubyStringCompleter(List<? super CompletionProposal> proposals, CompletionRequest request, int anchor, boolean caseSensitive) {
        super(proposals, request, anchor, caseSensitive);
    }

    private boolean complete() {
        String prefix = this.request.prefix;
        int lexOffset = this.request.lexOffset;
        TokenHierarchy<Document> th = this.request.th;
        TokenSequence ts = LexUtilities.getRubyTokenSequence(th, lexOffset);
        if (this.getIndex() != null && ts != null) {
            Token token;
            ts.move(lexOffset);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return false;
            }
            if (ts.offset() == lexOffset) {
                ts.movePrevious();
            }
            if ((token = ts.token()) != null) {
                int offset;
                TokenId id = token.id();
                if (id == RubyTokenId.LINE_COMMENT || id == RubyTokenId.DOCUMENTATION) {
                    BaseDocument doc;
                    OffsetRange commentBlock;
                    if (this.request.queryType == CodeCompletionHandler.QueryType.DOCUMENTATION && (commentBlock = LexUtilities.getCommentBlock(doc = this.request.doc, lexOffset)) != OffsetRange.NONE) {
                        try {
                            String text = doc.getText(commentBlock.getStart(), commentBlock.getLength());
                            if (text.startsWith("=begin\n") && text.endsWith("=end")) {
                                text = text.substring("=begin\n".length(), text.length() - "=end".length());
                            }
                            CommentElement element = new CommentElement(text);
                            RubyCompletionItem.ClassItem item = new RubyCompletionItem.ClassItem(element, this.anchor, this.request);
                            this.propose((CompletionProposal)item);
                            return true;
                        }
                        catch (BadLocationException ble) {
                            // empty catch block
                        }
                    }
                    return true;
                }
                if (id == RubyTokenId.EMBEDDED_RUBY) {
                    ts = ts.embedded();
                    assert (ts != null);
                    ts.move(lexOffset);
                    if (!ts.moveNext() && !ts.movePrevious()) {
                        return false;
                    }
                    token = ts.token();
                    id = token.id();
                }
                boolean inString = false;
                boolean isQuoted = false;
                boolean inRegexp = false;
                String tokenText = ((Object)token.text()).toString();
                if ((id == RubyTokenId.STRING_BEGIN || id == RubyTokenId.QUOTED_STRING_BEGIN || id == RubyTokenId.ERROR && tokenText.equals("%")) && (offset = ts.offset()) == lexOffset - 1 && tokenText.length() > 0 && tokenText.charAt(0) == '%' && this.completePercentWords()) {
                    return true;
                }
                if ((id == RubyTokenId.STRING_BEGIN || id == RubyTokenId.QUOTED_STRING_BEGIN || id == RubyTokenId.REGEXP_BEGIN) && token.length() == 3 && lexOffset == ts.offset() + 2 && Character.isLetter(tokenText.charAt(1))) {
                    this.completeStringBegins();
                    return true;
                }
                while (id == RubyTokenId.ERROR || id == RubyTokenId.STRING_LITERAL || id == RubyTokenId.QUOTED_STRING_LITERAL || id == RubyTokenId.REGEXP_LITERAL || id == RubyTokenId.EMBEDDED_RUBY) {
                    if (id == RubyTokenId.QUOTED_STRING_LITERAL) {
                        isQuoted = true;
                    }
                    if (!ts.movePrevious()) {
                        return false;
                    }
                    token = ts.token();
                    id = token.id();
                }
                if (id == RubyTokenId.STRING_BEGIN) {
                    inString = true;
                } else if (id == RubyTokenId.QUOTED_STRING_BEGIN) {
                    inString = true;
                    isQuoted = true;
                } else if (id == RubyTokenId.REGEXP_BEGIN) {
                    inRegexp = true;
                }
                if (inRegexp) {
                    if (this.completeRegexps()) {
                        this.request.completionResult.setFilterable(false);
                        return true;
                    }
                } else if (inString) {
                    while (ts.movePrevious()) {
                        token = ts.token();
                        if (token.id() == RubyTokenId.WHITESPACE || token.id() == RubyTokenId.LPAREN || token.id() == RubyTokenId.STRING_LITERAL || token.id() == RubyTokenId.QUOTED_STRING_LITERAL || token.id() == RubyTokenId.STRING_BEGIN || token.id() == RubyTokenId.QUOTED_STRING_BEGIN) continue;
                        if (token.id() != RubyTokenId.IDENTIFIER) break;
                        String text = ((Object)token.text()).toString();
                        if (text.equals("require") || text.equals("load")) {
                            Set<String[]> requires = this.getIndex().getRequires(prefix, this.caseSensitive ? QuerySupport.Kind.PREFIX : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
                            for (String[] require : requires) {
                                assert (require.length == 2);
                                RubyCompletionItem.KeywordItem item = new RubyCompletionItem.KeywordItem(require[0], require[1], this.anchor, this.request);
                                this.propose((CompletionProposal)item);
                            }
                            return true;
                        }
                        if (!"gem".equals(text)) break;
                        this.proposeGems(prefix);
                    }
                    if (inString && isQuoted) {
                        int n = RUBY_QUOTED_STRING_ESCAPES.length;
                        for (int i = 0; i < n; i += 2) {
                            String word = RUBY_QUOTED_STRING_ESCAPES[i];
                            String desc = RUBY_QUOTED_STRING_ESCAPES[i + 1];
                            if (!word.startsWith(prefix)) continue;
                            RubyCompletionItem.KeywordItem item = new RubyCompletionItem.KeywordItem(word, desc, this.anchor, this.request);
                            this.propose((CompletionProposal)item);
                        }
                        return true;
                    }
                    if (inString) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void proposeGems(String prefix) {
        Project owner = FileOwnerQuery.getOwner((FileObject)this.request.fileObject);
        if (owner == null) {
            return;
        }
        GemManager gemManager = RubyPlatform.gemManagerFor((Project)owner);
        if (gemManager == null) {
            return;
        }
        List gems = gemManager.getLocalGems();
        for (Gem gem : gems) {
            if (!gem.getName().startsWith(prefix)) continue;
            String versions = NbBundle.getMessage(RubyStringCompleter.class, (String)"InstalledVersions", (Object)gem.getInstalledVersionsAsString());
            RubyCompletionItem.KeywordItem item = new RubyCompletionItem.KeywordItem(gem.getName(), versions, this.anchor, this.request);
            this.propose((CompletionProposal)item);
        }
    }

    private boolean completePercentWords() {
        String prefix = this.request.prefix;
        int n = RUBY_PERCENT_WORDS.length;
        for (int i = 0; i < n; i += 2) {
            String word = RUBY_PERCENT_WORDS[i];
            String desc = RUBY_PERCENT_WORDS[i + 1];
            if (!RubyCodeCompleter.startsWith(word, prefix, this.caseSensitive)) continue;
            RubyCompletionItem.KeywordItem item = new RubyCompletionItem.KeywordItem(word, desc, this.anchor, this.request);
            this.propose((CompletionProposal)item);
        }
        return true;
    }

    private boolean completeRegexps() {
        String prefix = this.request.prefix;
        int n = RUBY_REGEXP_WORDS.length;
        for (int i = 0; i < n; i += 2) {
            String word = RUBY_REGEXP_WORDS[i];
            String desc = RUBY_REGEXP_WORDS[i + 1];
            if (!RubyCodeCompleter.startsWith(word, prefix, this.caseSensitive)) continue;
            RubyCompletionItem.KeywordItem item = new RubyCompletionItem.KeywordItem(word, desc, this.anchor, this.request);
            this.propose((CompletionProposal)item);
        }
        return true;
    }

    private boolean completeStringBegins() {
        int n = RUBY_STRING_PAIRS.length;
        for (int i = 0; i < n; i += 2) {
            String word = RUBY_STRING_PAIRS[i];
            String desc = RUBY_STRING_PAIRS[i + 1];
            RubyCompletionItem.KeywordItem item = new RubyCompletionItem.KeywordItem(word, desc, this.anchor, this.request);
            this.propose((CompletionProposal)item);
        }
        return true;
    }
}

