/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.ruby.RubyUtils;

final class Inflector {
    private final Set<String> uncountables = new HashSet<String>();
    private final Map<String, String> irregulars = new LinkedHashMap<String, String>();
    private final Map<Pattern, String> plurals = new LinkedHashMap<Pattern, String>();
    private final Map<Pattern, String> singulars = new LinkedHashMap<Pattern, String>();
    private static final Inflector INSTANCE = new Inflector();

    public static Inflector getDefault() {
        return INSTANCE;
    }

    private Inflector() {
        this.init();
    }

    public String pluralize(String word) {
        if (this.isEmpty(word)) {
            return word;
        }
        String lowerCaseWord = word.toLowerCase(Locale.ENGLISH);
        if (this.uncountables.contains(lowerCaseWord)) {
            return word;
        }
        if (this.irregulars.containsKey(lowerCaseWord)) {
            return this.irregulars.get(lowerCaseWord);
        }
        for (Pattern p : this.plurals.keySet()) {
            Matcher m = p.matcher(word);
            if (!m.find()) continue;
            return m.replaceAll(this.plurals.get(p));
        }
        return word;
    }

    public String singularize(String word) {
        if (this.isEmpty(word)) {
            return word;
        }
        String lowerCaseWord = word.toLowerCase(Locale.ENGLISH);
        if (this.uncountables.contains(lowerCaseWord)) {
            return word;
        }
        if (this.irregulars.containsValue(lowerCaseWord)) {
            for (Map.Entry entry : this.irregulars.entrySet()) {
                if (!((String)entry.getValue()).equals(lowerCaseWord)) continue;
                return (String)entry.getKey();
            }
        }
        for (Pattern pattern : this.singulars.keySet()) {
            Matcher m = pattern.matcher(word);
            if (!m.find()) continue;
            return m.replaceAll(this.singulars.get(pattern));
        }
        return word;
    }

    public String tableize(String word) {
        return this.pluralize(RubyUtils.camelToUnderlinedName(word));
    }

    public String demodulize(String classNameInModule) {
        int last = classNameInModule.lastIndexOf("::");
        if (last == -1) {
            return classNameInModule;
        }
        return classNameInModule.substring(last + 2, classNameInModule.length());
    }

    private boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    private void plural(String regex, String replacement) {
        this.plurals.put(this.compile(regex), replacement);
    }

    private void singular(String regex, String replacement) {
        this.singulars.put(this.compile(regex), replacement);
    }

    private void irregular(String singular, String plural) {
        this.irregulars.put(singular, plural);
    }

    private Pattern compile(String regex) {
        return Pattern.compile("(?i)" + regex);
    }

    void uncountable(String ... uncountable) {
        for (String each : uncountable) {
            this.uncountables.add(each);
        }
    }

    private void init() {
        this.plural("(ax|test)is$", "$1es");
        this.plural("(octop|vir)us$", "$1i");
        this.plural("(alias|status)$", "$1es");
        this.plural("(bu)s$", "$1ses");
        this.plural("(buffal|tomat)o$", "$1oes");
        this.plural("([ti])um$", "$1a");
        this.plural("sis$", "ses");
        this.plural("(?:([^f])fe|([lr])f)$", "$1$2ves");
        this.plural("(hive)$", "$1s");
        this.plural("([^aeiouy]|qu)y$", "$1ies");
        this.plural("(matr|vert|ind)ix|ex$", "$1ices");
        this.plural("(x|ch|ss|sh)$", "$1es");
        this.plural("([m|l])ouse$", "$1ice");
        this.plural("^(ox)$", "$1en");
        this.plural("(quiz)$", "$1zes");
        this.plural("(.*p)erson$", "$1eople");
        this.plural("(.*c)riterion$", "$1riteria");
        this.plural("(.*m)an$", "$1en");
        this.plural("s$", "s");
        this.plural("$", "s");
        this.singular("(ax|test)es$", "$1is");
        this.singular("(n)ews$", "$1ews");
        this.singular("([ti])a$", "$1um");
        this.singular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis");
        this.singular("(^analy)ses$", "$1sis");
        this.singular("([^f])ves$", "$1fe");
        this.singular("(hive)s$", "$1");
        this.singular("(tive)s$", "$1");
        this.singular("([lr])ves$", "$1f");
        this.singular("([^aeiouy]|qu)ies$", "$1y");
        this.singular("(s)eries$", "$1eries");
        this.singular("(m)ovies$", "$1ovie");
        this.singular("(x|ch|ss|sh)es$", "$1");
        this.singular("([m|l])ice$", "$1ouse");
        this.singular("(bus)es$", "$1");
        this.singular("(o)es$", "$1");
        this.singular("(shoe)s$", "$1");
        this.singular("(cris|ax|test)es$", "$1is");
        this.singular("(octop|vir)i$", "$1us");
        this.singular("(octop|vir)us$", "$1us");
        this.singular("(alias|status)es$", "$1");
        this.singular("^(ox)en", "$1");
        this.singular("(vert|ind)ices$", "$1ex");
        this.singular("(matr)ices$", "$1ix");
        this.singular("(quiz)zes$", "$1");
        this.singular("(database)s$", "$1");
        this.singular("(.*p)eople$", "$1erson");
        this.plural("(.*c)riteria$", "$1riterion");
        this.singular("(.*m)en$", "$1an");
        this.singular("s$", "");
        this.irregular("person", "people");
        this.irregular("man", "men");
        this.irregular("child", "children");
        this.irregular("sex", "sexes");
        this.irregular("move", "moves");
        this.irregular("cow", "kine");
        this.irregular("criterion", "criteria");
        this.uncountable("equipment", "information", "rice", "money", "species", "series", "fish", "sheep");
    }
}

