/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.ui.options;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.toolchain.ui.options.ToolsPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public final class DownloadUtils {
    private DownloadUtils() {
    }

    public static boolean showDownloadConfirmation(CompilerSet cs) {
        String selected = cs.getCompilerFlavor().toString();
        String name = cs.getDisplayName();
        String uc = cs.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterUrl();
        String message = ToolsPanel.getString("ToolsPanel.UpdateCenterMessageConformation", selected, name, uc);
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, ToolsPanel.getString("ToolsPanel.UpdateCenterTitle"), 0);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (ret == NotifyDescriptor.YES_OPTION) {
            DownloadUtils.downloadCompilerSet(cs);
            return true;
        }
        return false;
    }

    private static UpdateUnit findKnownUnit(CompilerSet cs) {
        for (UpdateUnitProvider provider : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(false)) {
            if (provider.getProviderURL() == null) continue;
            List list = provider.getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
            for (UpdateUnit unit : list) {
                if (!cs.getCompilerFlavor().getToolchainDescriptor().getModuleID().equals(unit.getCodeName())) continue;
                return unit;
            }
        }
        return null;
    }

    private static UpdateUnitProvider findKnownProvider(CompilerSet cs) throws MalformedURLException {
        URL url = new URL(cs.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterUrl());
        for (UpdateUnitProvider provider : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(false)) {
            String f2;
            String f1;
            URL u = provider.getProviderURL();
            if (u == null || !(f1 = u.getFile()).equalsIgnoreCase(f2 = url.getFile())) continue;
            return provider;
        }
        return null;
    }

    static void downloadCompilerSet(CompilerSet cs) {
        String fail = null;
        try {
            UpdateUnitProvider provider;
            UpdateUnit unit = DownloadUtils.findKnownUnit(cs);
            if (unit == null && (provider = DownloadUtils.findKnownProvider(cs)) == null) {
                provider = UpdateUnitProviderFactory.getDefault().create(cs.getCompilerFlavor().getToolchainDescriptor().getModuleID(), cs.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterDisplayName(), new URL(cs.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterUrl()), UpdateUnitProvider.CATEGORY.COMMUNITY);
                try {
                    provider.refresh(null, true);
                    List list = provider.getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
                    for (UpdateUnit u : list) {
                        if (!cs.getCompilerFlavor().getToolchainDescriptor().getModuleID().equals(u.getCodeName())) continue;
                        unit = u;
                        break;
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    if (provider != null) {
                        UpdateUnitProviderFactory.getDefault().remove(provider);
                    }
                    fail = ToolsPanel.getString("ToolsPanel.UpdateCenterNotFound", cs.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterDisplayName(), cs.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterUrl());
                }
            }
            if (unit != null) {
                OperationContainer installContainer = OperationContainer.createForInstall();
                installContainer.add((Collection)unit.getAvailableUpdates());
                InstallSupport support = (InstallSupport)installContainer.getSupport();
                if (support != null) {
                    PluginManager.openInstallWizard((OperationContainer)installContainer);
                    return;
                }
            }
            if (fail == null) {
                fail = ToolsPanel.getString("ToolsPanel.ModuleNotFound", cs.getDisplayName(), cs.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterDisplayName(), cs.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterUrl());
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            fail = ToolsPanel.getString("ToolsPanel.UpdateCenterNotFound", cs.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterDisplayName(), cs.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterUrl());
        }
        if (fail != null) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)fail, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }
}

