/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import java.io.BufferedReader;
import java.io.IOException;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilers.CCCCompiler;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

abstract class GNUCCCCompiler
extends CCCCompiler {
    public GNUCCCCompiler(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        super(env, flavor, kind, name, displayName, path);
    }

    protected String getCompilerStderrCommand() {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null) {
            return " " + compiler.getIncludeFlags();
        }
        return "";
    }

    protected String getCompilerStdoutCommand() {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null) {
            return " " + compiler.getMacroFlags();
        }
        return "";
    }

    @Override
    protected CCCCompiler.Pair getFreshSystemIncludesAndDefines() {
        CCCCompiler.Pair res = new CCCCompiler.Pair();
        try {
            this.getSystemIncludesAndDefines(this.getCompilerStderrCommand(), false, res);
            this.getSystemIncludesAndDefines(this.getCompilerStdoutCommand(), true, res);
            if (!this.containsMacro(res.systemPreprocessorSymbolsList, "__STDC__")) {
                res.systemPreprocessorSymbolsList.add("__STDC__=1");
            }
        }
        catch (IOException ioe) {
            System.err.println("IOException " + ioe);
            String errormsg = this.getExecutionEnvironment().isLocal() ? NbBundle.getMessage(this.getClass(), (String)"CANTFINDCOMPILER", (Object)this.getPath()) : NbBundle.getMessage(this.getClass(), (String)"CANT_FIND_REMOTE_COMPILER", (Object)this.getPath(), (Object)this.getExecutionEnvironment().getDisplayName());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errormsg, 0));
        }
        return res;
    }

    private boolean startsWithPath(String line) {
        if ((line = line.trim()).startsWith("/")) {
            return true;
        }
        return line.length() > 2 && Character.isLetter(line.charAt(0)) && line.charAt(1) == ':';
    }

    protected String cutIncludePrefix(String line) {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && compiler.getRemoveIncludeOutputPrefix() != null) {
            String remove = compiler.getRemoveIncludeOutputPrefix();
            if (line.toLowerCase().startsWith(this.getIncludeFilePathPrefix().toLowerCase())) {
                line = line.substring(this.getIncludeFilePathPrefix().length());
            } else if (line.toLowerCase().startsWith(remove)) {
                line = line.substring(remove.length());
            }
        }
        return line;
    }

    @Override
    protected void parseCompilerOutput(BufferedReader reader, CCCCompiler.Pair pair) {
        try {
            String line;
            boolean startIncludes = false;
            while ((line = reader.readLine()) != null) {
                int i;
                if ((line = line.trim()).contains("#include <...>")) {
                    startIncludes = true;
                    continue;
                }
                if (startIncludes) {
                    if (line.startsWith("End of search") || !this.startsWithPath(line)) {
                        startIncludes = false;
                        continue;
                    }
                    if (line.length() > 2 && line.charAt(1) == ':') {
                        GNUCCCCompiler.addUnique(pair.systemIncludeDirectoriesList, this.normalizePath(line));
                        continue;
                    }
                    if ((line = this.cutIncludePrefix(line)).endsWith(" (framework directory)")) {
                        line = line.substring(0, line.lastIndexOf(40)).trim();
                    }
                    GNUCCCCompiler.addUnique(pair.systemIncludeDirectoriesList, this.applyPathPrefix(line));
                    if (this.getDescriptor().getRemoveIncludePathPrefix() == null || !line.startsWith("/usr/lib")) continue;
                    GNUCCCCompiler.addUnique(pair.systemIncludeDirectoriesList, this.applyPathPrefix(line.substring(4)));
                    continue;
                }
                this.parseUserMacros(line, pair.systemPreprocessorSymbolsList);
                if (!line.startsWith("#define ") || (i = line.indexOf(32, 8)) <= 0) continue;
                String token = line.substring(8, i) + "=" + line.substring(i + 1);
                GNUCCCCompiler.addUnique(pair.systemPreprocessorSymbolsList, token);
            }
            reader.close();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
        }
    }
}

