/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URIException;
import org.apache.tools.ant.BuildException;
import org.apache.webdav.ant.ResourceProperties;
import org.apache.webdav.ant.ScanException;
import org.apache.webdav.ant.Scanner;
import org.apache.webdav.ant.Utils;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.methods.PropFindMethod;
import org.apache.webdav.lib.properties.ResourceTypeProperty;

public class CollectionScanner
extends Scanner {
    private HttpURL baseURL = null;
    private HttpClient client = null;
    private ResourceProperties properties = null;
    private Vector propertyNames = new Vector();

    public CollectionScanner() {
        this.propertyNames.add(Utils.RESOURCETYPE);
        this.propertyNames.add(Utils.GETLASTMODIFIED);
    }

    public void scan() {
        if (this.baseURL == null) {
            throw new IllegalStateException("BaseURL must be set before calling the scan() method");
        }
        this.filesIncluded = new ArrayList();
        this.filesExcluded = new ArrayList();
        this.filesNotIncluded = new ArrayList();
        this.dirsIncluded = new ArrayList();
        this.dirsExcluded = new ArrayList();
        this.dirsNotIncluded = new ArrayList();
        this.properties = new ResourceProperties();
        try {
            this.readCollection(this.baseURL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void readCollection(HttpURL collURL) throws URIException {
        if (!collURL.getPath().endsWith("/")) {
            collURL = Utils.createHttpURL(collURL, "");
            collURL.setPath(collURL.getPath() + "/");
        }
        PropFindMethod propFind = new PropFindMethod(collURL.getURI(), 1, 0);
        propFind.setPropertyNames(this.propertyNames.elements());
        propFind.setFollowRedirects(true);
        try {
            this.client.executeMethod((HttpMethod)propFind);
        }
        catch (IOException e) {
            Utils.makeBuildException("Can't read collection content!", e);
        }
        ArrayList<HttpURL> subCollections = new ArrayList<HttpURL>();
        this.properties.storeProperties(propFind);
        this.addResource(collURL.getPath(), true);
        Enumeration e = propFind.getAllResponseURLs();
        while (e.hasMoreElements()) {
            String href = (String)e.nextElement();
            ResourceTypeProperty property = this.properties.getResourceType(collURL, href);
            if (property != null) {
                if (property.isCollection()) {
                    HttpURL sub;
                    if (!href.endsWith("/")) {
                        href = href + "/";
                    }
                    if ((sub = Utils.createHttpURL(collURL, href)).equals((Object)collURL)) continue;
                    subCollections.add(Utils.createHttpURL(collURL, href));
                    continue;
                }
                this.addResource(href, false);
                continue;
            }
            throw new BuildException("Can't determine resourcetype.");
        }
        Iterator i = subCollections.iterator();
        while (i.hasNext()) {
            this.readCollection((HttpURL)i.next());
        }
    }

    protected void addResource(String href, boolean isCollection) throws ScanException {
        try {
            String path = Utils.createHttpURL(this.getBaseURL(), href).getPath();
            String relPath = path.substring(this.getBaseURL().getPath().length());
            if (relPath.startsWith("/")) {
                relPath = relPath.substring(1);
            }
            if (isCollection) {
                if (this.isIncluded(relPath)) {
                    if (this.isExcluded(relPath)) {
                        this.dirsExcluded.add(relPath);
                    } else {
                        this.dirsIncluded.add(relPath);
                    }
                } else {
                    this.dirsNotIncluded.add(relPath);
                }
            } else if (this.isIncluded(relPath)) {
                if (this.isExcluded(relPath)) {
                    this.filesExcluded.add(relPath);
                } else {
                    this.filesIncluded.add(relPath);
                }
            } else {
                this.filesNotIncluded.add(relPath);
            }
        }
        catch (URIException e) {
            throw new ScanException("The XML response returned an invalid URL: " + e.getMessage(), e);
        }
    }

    public HttpURL getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(HttpURL baseURL) {
        this.baseURL = baseURL;
    }

    public void setHttpClient(HttpClient client) {
        this.client = client;
    }

    public ResourceProperties getProperties() {
        return this.properties;
    }

    public void addProperty(PropertyName property) {
        if (property == null) {
            throw new NullPointerException();
        }
        this.propertyNames.add(property);
    }
}

