/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class FatCopyLibs {
    private Path runtimePath;
    private File destFolder;

    public void setRuntimeClassPath(Path path) {
        assert (path != null);
        this.runtimePath = path;
    }

    public Path getRuntimeClassPath() {
        return this.runtimePath;
    }

    public void execute() throws BuildException {
        if (this.runtimePath == null) {
            throw new BuildException("RuntimeClassPath must be set.");
        }
        String[] pathElements = this.runtimePath.list();
        File[] filesToCopy = new File[pathElements.length];
        for (int i = 0; i < pathElements.length; ++i) {
            File f = new File(pathElements[i]);
            if (f.isDirectory() || !f.canRead()) {
                filesToCopy = null;
                break;
            }
            filesToCopy[i] = f;
        }
        assert (this.getDestFolder() != null && this.getDestFolder().canWrite());
        if (filesToCopy != null && filesToCopy.length > 0) {
            FileUtils utils = FileUtils.newFileUtils();
            for (File f : filesToCopy) {
                try {
                    File libFile = new File(this.getDestFolder(), f.getName());
                    utils.copyFile(f, libFile);
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe);
                }
            }
        }
    }

    public File getDestFolder() {
        return this.destFolder;
    }

    public void setDestFolder(File destFolder) {
        this.destFolder = destFolder;
    }
}

