/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Procedure;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProcedureNode
extends BaseNode {
    private static final String ICONBASE = "org/netbeans/modules/db/resources/procedure.gif";
    private static final String FOLDER = "Procedure";
    private String name = "";
    private final MetadataElementHandle<Procedure> procedureHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static ProcedureNode create(NodeDataLookup dataLookup, NodeProvider provider) {
        ProcedureNode node = new ProcedureNode(dataLookup, provider);
        node.setup();
        return node;
    }

    private ProcedureNode(NodeDataLookup lookup, NodeProvider provider) {
        super(new ChildNodeFactory((Lookup)lookup), lookup, FOLDER, provider);
        this.procedureHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    @Override
    protected void initialize() {
        boolean connected = !this.connection.getConnector().isDisconnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Procedure proc = (Procedure)ProcedureNode.this.procedureHandle.resolve(metaData);
                        ProcedureNode.this.name = proc.getName();
                        ProcedureNode.this.updateProperties(proc);
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, e, true);
            }
        }
    }

    private void updateProperties(Procedure proc) {
        PropertySupport.Name ps = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)ps);
        if (proc.getReturnValue() == null) {
            this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)"StoredProcedure"));
        } else {
            this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)"StoredFunction"));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getIconBase() {
        return ICONBASE;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ProcedureNode.class, (String)"ND_Procedure");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProcedureNode.class);
    }
}

