/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.tools.ProcDataProviderConfiguration;
import org.netbeans.modules.dlight.tools.impl.DataRowConsumer;
import org.netbeans.modules.dlight.tools.impl.ProcDataProviderLinux;
import org.netbeans.modules.dlight.tools.impl.ProcDataProviderSolaris;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.NativeProcessExecutionService;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.NbBundle;

public class ProcDataProvider
extends IndicatorDataProvider<ProcDataProviderConfiguration>
implements DataRowConsumer {
    private static final String NAME = "ProcReader";
    private static final DataTableMetadata TABLE = new DataTableMetadata("ProcReader", Arrays.asList(ProcDataProviderConfiguration.SYS_TIME, ProcDataProviderConfiguration.USR_TIME, ProcDataProviderConfiguration.THREADS), null);
    private List<ValidationListener> validationListeners = new CopyOnWriteArrayList<ValidationListener>();
    private ValidationStatus validationStatus = ValidationStatus.initialStatus();
    private Future<Integer> procReaderTask;

    public ProcDataProvider(ProcDataProviderConfiguration configuration) {
    }

    public Collection<DataTableMetadata> getDataTablesMetadata() {
        return Collections.singletonList(TABLE);
    }

    public String getName() {
        return NAME;
    }

    public void targetStateChanged(DLightTargetChangeEvent event) {
        switch (event.state) {
            case RUNNING: {
                this.targetStarted(event.target);
                break;
            }
            case DONE: 
            case FAILED: 
            case STOPPED: 
            case TERMINATED: {
                this.targetFinished(event.target);
            }
        }
    }

    public synchronized ValidationStatus validate(DLightTarget target) {
        if (this.validationStatus.isValid()) {
            return this.validationStatus;
        }
        ValidationStatus oldStatus = this.validationStatus;
        ValidationStatus newStatus = this.doValidation(target);
        this.notifyStatusChanged(oldStatus, newStatus);
        this.validationStatus = newStatus;
        return newStatus;
    }

    private ValidationStatus doValidation(DLightTarget target) {
        ExecutionEnvironment env = target.getExecEnv();
        if (!ConnectionManager.getInstance().isConnectedTo(env)) {
            AsynchronousAction connectAction = ConnectionManager.getInstance().getConnectToAction(env, new Runnable(){

                @Override
                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            });
            return ValidationStatus.unknownStatus((String)ProcDataProvider.getMessage("ValidationStatus.HostNotConnected"), (AsynchronousAction)connectAction);
        }
        HostInfo.OSFamily osFamily = HostInfo.OSFamily.UNKNOWN;
        try {
            osFamily = HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getOSFamily();
        }
        catch (IOException ex) {
        }
        catch (CancellationException ex) {
            // empty catch block
        }
        if (osFamily != HostInfo.OSFamily.LINUX && osFamily != HostInfo.OSFamily.SUNOS) {
            return ValidationStatus.invalidStatus((String)ProcDataProvider.getMessage("ValidationStatus.ProcReader.OSNotSupported"));
        }
        try {
            if (!HostInfoUtils.fileExists((ExecutionEnvironment)env, (String)"/proc")) {
                return ValidationStatus.invalidStatus((String)ProcDataProvider.getMessage("ValidationStatus.ProcNotFound"));
            }
        }
        catch (InterruptedException ex) {
            return ValidationStatus.invalidStatus((String)ProcDataProvider.getMessage("ValidationStatus.Interrupted"));
        }
        catch (IOException ex) {
            return ValidationStatus.invalidStatus((String)ex.getMessage());
        }
        return ValidationStatus.validStatus();
    }

    public synchronized void invalidate() {
        this.validationStatus = ValidationStatus.initialStatus();
    }

    public synchronized ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public void addValidationListener(ValidationListener listener) {
        if (!this.validationListeners.contains(listener)) {
            this.validationListeners.add(listener);
        }
    }

    public void removeValidationListener(ValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    private void notifyStatusChanged(ValidationStatus oldStatus, ValidationStatus newStatus) {
        if (oldStatus.equals((Object)newStatus)) {
            return;
        }
        for (ValidationListener validationListener : this.validationListeners) {
            validationListener.validationStateChanged((Validateable)this, oldStatus, newStatus);
        }
    }

    private synchronized void targetStarted(DLightTarget target) {
        Engine engine;
        ExecutionEnvironment env = target.getExecEnv();
        HostInfo hostInfo = null;
        try {
            hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
        }
        catch (IOException ex) {
        }
        catch (CancellationException ex) {
            // empty catch block
        }
        if (hostInfo == null) {
            return;
        }
        int pid = ((AttachableTarget)target).getPID();
        switch (hostInfo.getOSFamily()) {
            case LINUX: {
                engine = new ProcDataProviderLinux(this, this.getServiceInfoDataStorage());
                break;
            }
            case SUNOS: {
                engine = new ProcDataProviderSolaris(this, this.getServiceInfoDataStorage(), hostInfo.getCpuNum());
                break;
            }
            default: {
                DLightLogger.instance.severe("Called ProcDataProvider.targetStarted() on unsupported OS");
                return;
            }
        }
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)env);
        npb = npb.setExecutable("sh").setArguments(new String[]{"-c", engine.getCommand(pid)});
        this.procReaderTask = NativeProcessExecutionService.newService((NativeProcessBuilder)npb, (LineProcessor)engine, null, (String)"procreader").start();
    }

    private synchronized void targetFinished(DLightTarget target) {
        if (this.procReaderTask != null) {
            if (!this.procReaderTask.isDone()) {
                this.procReaderTask.cancel(true);
            }
            this.procReaderTask = null;
        }
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
    }

    @Override
    public void consume(DataRow row) {
        super.notifyIndicators(Collections.singletonList(row));
    }

    private static String getMessage(String name) {
        return NbBundle.getMessage(ProcDataProvider.class, (String)name);
    }

    static interface Engine
    extends LineProcessor {
        public String getCommand(int var1);
    }
}

