/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformConfigurator;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformDetector;
import org.netbeans.modules.j2me.cdc.platform.wizard.CDCWizardIterator;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class DetectPanel
extends JPanel {
    private ArrayList<ChangeListener> listeners;
    private static File lastFolder = null;
    private JButton addJavadocButton;
    private JButton addSourceButton;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JList javadocList;
    private JTextField jdkName;
    private JButton removeJavadocButton;
    private JButton removeSourceButton;
    private JList sourcesList;

    public DetectPanel(FileObject installed, CDCPlatformDetector detector) {
        this.initComponents();
        this.sourcesList.setModel(new DefaultListModel());
        this.javadocList.setModel(new DefaultListModel());
        this.postInitComponents();
        this.putClientProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(DetectPanel.class, (String)"TITLE_PlatformName")});
        this.setName(NbBundle.getMessage(DetectPanel.class, (String)"TITLE_PlatformName"));
        CDCPlatformConfigurator configurator = detector.getConfigurator(installed);
        if (configurator != null) {
            JPanel panel = configurator.getConfigurationTools();
            panel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DetectPanel.this.fireChange();
                }
            });
            this.jTabbedPane1.insertTab(NbBundle.getMessage(DetectPanel.class, (String)"TXT_Configuration"), null, panel, null, 0);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    private void postInitComponents() {
        this.jdkName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DetectPanel.this.handleNameChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DetectPanel.this.handleNameChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DetectPanel.this.handleNameChange();
            }
        });
        this.sourcesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DetectPanel.this.removeSourceButton.setEnabled(DetectPanel.this.sourcesList.getSelectedValue() != null);
            }
        });
        this.javadocList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DetectPanel.this.removeJavadocButton.setEnabled(DetectPanel.this.javadocList.getSelectedValue() != null);
            }
        });
    }

    protected void handleNameChange() {
        this.fireChange();
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jdkName = new JTextField();
        this.jPanel1 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.sourcesList = new JList();
        this.jPanel6 = new JPanel();
        this.addSourceButton = new JButton();
        this.removeSourceButton = new JButton();
        this.jPanel5 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.javadocList = new JList();
        this.jPanel7 = new JPanel();
        this.addJavadocButton = new JButton();
        this.removeJavadocButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_DetectPanel"));
        this.jLabel3.setLabelFor(this.jdkName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getBundle(DetectPanel.class).getString("LBL_DetailsPanel_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jdkName, gridBagConstraints);
        this.jdkName.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_PlatformName"));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.sourcesList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.sourcesList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel6.setLayout(new GridLayout(2, 0, 6, 6));
        Mnemonics.setLocalizedText((AbstractButton)this.addSourceButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"TXT_AddSources"));
        this.addSourceButton.setEnabled(false);
        this.addSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetectPanel.this.addSourceButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.addSourceButton);
        Mnemonics.setLocalizedText((AbstractButton)this.removeSourceButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"TXT_RemoveSources"));
        this.removeSourceButton.setEnabled(false);
        this.removeSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetectPanel.this.removeSourceButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.removeSourceButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(DetectPanel.class, (String)"TXT_Sources"), this.jPanel4);
        this.jPanel5.setLayout(new GridBagLayout());
        this.javadocList.setSelectionMode(0);
        this.javadocList.setEnabled(false);
        this.jScrollPane2.setViewportView(this.javadocList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.jPanel5.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel7.setLayout(new GridLayout(2, 0, 0, 6));
        Mnemonics.setLocalizedText((AbstractButton)this.addJavadocButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"TXT_AddJavadoc"));
        this.addJavadocButton.setEnabled(false);
        this.addJavadocButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetectPanel.this.addJavadocButtonActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.addJavadocButton);
        Mnemonics.setLocalizedText((AbstractButton)this.removeJavadocButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"TXT_RemoveJavadoc"));
        this.removeJavadocButton.setEnabled(false);
        this.removeJavadocButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetectPanel.this.removeJavadocButtonActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.removeJavadocButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel5.add((Component)this.jPanel7, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(DetectPanel.class, (String)"TXT_JavaDoc"), this.jPanel5);
        this.jPanel1.add((Component)this.jTabbedPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void removeJavadocButtonActionPerformed(ActionEvent evt) {
        int index = this.javadocList.getSelectedIndex();
        ((DefaultListModel)this.javadocList.getModel()).remove(index);
        int size = this.javadocList.getModel().getSize();
        if (size != 0) {
            this.javadocList.setSelectedIndex(0);
        }
    }

    private void addJavadocButtonActionPerformed(ActionEvent evt) {
        this.addResource("javadoc");
    }

    private void addSourceButtonActionPerformed(ActionEvent evt) {
        this.addResource("src");
    }

    private void removeSourceButtonActionPerformed(ActionEvent evt) {
        int index = this.sourcesList.getSelectedIndex();
        ((DefaultListModel)this.sourcesList.getModel()).remove(index);
        int size = this.sourcesList.getModel().getSize();
        if (size != 0) {
            this.sourcesList.setSelectedIndex(0);
        }
    }

    public final synchronized void addChangeListener(ChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public final synchronized void removeChangeListener(ChangeListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public String getPlatformName() {
        return this.jdkName.getText().trim();
    }

    String getSources() {
        StringBuffer sb = new StringBuffer();
        int size = this.sourcesList.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            sb.append(this.sourcesList.getModel().getElementAt(i));
            if (i + 1 >= size) continue;
            sb.append(';');
        }
        String val = sb.toString();
        return val.length() == 0 ? null : val;
    }

    void setSources(String sources) {
        ((DefaultListModel)this.sourcesList.getModel()).removeAllElements();
        if (sources == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(sources, ";");
        while (st.hasMoreTokens()) {
            ((DefaultListModel)this.sourcesList.getModel()).addElement(st.nextToken());
        }
    }

    void setSources(ClassPath sources) {
        String srcPath = null;
        if (sources.entries().size() > 0) {
            URL folderRoot = ((ClassPath.Entry)sources.entries().get(0)).getURL();
            if ("jar".equals(folderRoot.getProtocol())) {
                folderRoot = FileUtil.getArchiveFile((URL)folderRoot);
            }
            srcPath = new File(URI.create(folderRoot.toExternalForm())).getAbsolutePath();
        }
        this.setSources(srcPath);
    }

    String getJavadoc() {
        StringBuffer sb = new StringBuffer();
        int size = this.javadocList.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            sb.append(this.javadocList.getModel().getElementAt(i));
            if (i + 1 >= size) continue;
            sb.append(';');
        }
        String val = sb.toString();
        return val.length() == 0 ? null : val;
    }

    void setJavadoc(String jdoc) {
        ((DefaultListModel)this.javadocList.getModel()).removeAllElements();
        if (jdoc == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(jdoc, ";");
        while (st.hasMoreTokens()) {
            ((DefaultListModel)this.javadocList.getModel()).addElement(st.nextToken());
        }
    }

    void setJavadoc(List jdocFolders) {
        ((DefaultListModel)this.javadocList.getModel()).removeAllElements();
        if (jdocFolders == null) {
            return;
        }
        Iterator it = jdocFolders.iterator();
        while (it.hasNext()) {
            ((DefaultListModel)this.javadocList.getModel()).addElement(FileUtil.toFile((FileObject)((FileObject)it.next())).getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChange() {
        Iterator it = null;
        DetectPanel detectPanel = this;
        synchronized (detectPanel) {
            if (this.listeners == null) {
                return;
            }
            it = ((ArrayList)this.listeners.clone()).iterator();
        }
        ChangeEvent event = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(event);
        }
    }

    void updateData(String platfromDisplayName) {
        if ("".equals(this.jdkName.getText())) {
            this.jdkName.setText(platfromDisplayName);
            this.jdkName.selectAll();
        }
    }

    private void addResource(String volumeType) {
        DefaultListModel model = null;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setAcceptAllFileFilterUsed(false);
        if (volumeType.equalsIgnoreCase("javadoc")) {
            chooser.setDialogTitle(NbBundle.getMessage(DetectPanel.class, (String)"TXT_OpenJavadoc"));
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter(new SimpleFileFilter(NbBundle.getMessage(DetectPanel.class, (String)"TXT_SelectJavadoc"), new String[]{"ZIP", "JAR"}));
            chooser.setApproveButtonText(NbBundle.getMessage(DetectPanel.class, (String)"CTL_SelectJD"));
            chooser.setApproveButtonMnemonic(NbBundle.getMessage(DetectPanel.class, (String)"MNE_SelectJD").charAt(0));
            model = (DefaultListModel)this.javadocList.getModel();
        } else if (volumeType.equalsIgnoreCase("src")) {
            chooser.setDialogTitle(NbBundle.getMessage(DetectPanel.class, (String)"TXT_OpenSources"));
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter(new SimpleFileFilter(NbBundle.getMessage(DetectPanel.class, (String)"TXT_SelectSources"), new String[]{"ZIP", "JAR"}));
            chooser.setApproveButtonText(NbBundle.getMessage(DetectPanel.class, (String)"CTL_SelectSRC"));
            chooser.setApproveButtonMnemonic(NbBundle.getMessage(DetectPanel.class, (String)"MNE_SelectSRC").charAt(0));
            model = (DefaultListModel)this.sourcesList.getModel();
        }
        if (lastFolder != null) {
            chooser.setCurrentDirectory(lastFolder);
        }
        if (chooser.showOpenDialog(this) == 0) {
            lastFolder = chooser.getCurrentDirectory();
            if (chooser.isMultiSelectionEnabled()) {
                this.addFiles(chooser.getSelectedFiles(), model);
            } else {
                this.addFiles(new File[]{chooser.getSelectedFile()}, model);
            }
        }
    }

    private void addFiles(File[] files, DefaultListModel model) {
        for (File f : files) {
            File parent;
            if (!f.exists() && (parent = f.getParentFile()) != null && f.getName().equals(parent.getName()) && parent.exists()) {
                f = parent;
            }
            model.addElement(f.toString());
        }
    }

    static class WizardPanel
    implements WizardDescriptor.Panel,
    TaskListener,
    ChangeListener {
        protected DetectPanel component;
        private RequestProcessor.Task task;
        private final CDCWizardIterator iterator;
        private Collection<ChangeListener> changeList = new ArrayList<ChangeListener>();
        protected boolean detected;
        private boolean valid;
        private boolean configured;
        private WizardDescriptor wiz;
        protected CDCPlatform platform;
        protected FileObject installedFolder;
        protected CDCPlatformDetector detector;
        protected DetectPlatformTask detectPlatformTask = new DetectPlatformTask();

        WizardPanel(CDCWizardIterator iterator, CDCPlatformDetector detector) {
            this.iterator = iterator;
            this.detector = detector;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeList.add(l);
        }

        public Component getComponent() {
            if (this.component == null) {
                this.installedFolder = this.iterator.getInstallFolder();
                this.component = new DetectPanel(this.installedFolder, this.detector);
                this.component.addChangeListener(this);
                this.configured = this.isConfigured();
                if (this.configured) {
                    this.task = RequestProcessor.getDefault().create((Runnable)this.detectPlatformTask);
                    this.task.addTaskListener((TaskListener)this);
                } else {
                    this.setValid(false);
                }
            }
            return this.component;
        }

        void setValid(boolean v) {
            if (v == this.valid) {
                return;
            }
            this.valid = v;
            this.fireStateChange();
        }

        public HelpCtx getHelp() {
            return new HelpCtx("cdc.detectPanel");
        }

        public boolean isValid() {
            return this.valid;
        }

        public void readSettings(Object settings) {
            this.wiz = (WizardDescriptor)settings;
            CDCPlatform platform = this.iterator.getPlatform();
            String srcPath = null;
            String jdocPath = null;
            if (platform != null) {
                List jdoc;
                ClassPath src = platform.getSourceFolders();
                if (src.entries().size() > 0) {
                    URL folderRoot = ((ClassPath.Entry)src.entries().get(0)).getURL();
                    if ("jar".equals(folderRoot.getProtocol())) {
                        folderRoot = FileUtil.getArchiveFile((URL)folderRoot);
                    }
                    srcPath = new File(URI.create(folderRoot.toExternalForm())).getAbsolutePath();
                }
                if ((jdoc = platform.getJavadocFolders()).size() > 0) {
                    URL folderRoot = (URL)jdoc.get(0);
                    if ("jar".equals(folderRoot.getProtocol())) {
                        folderRoot = FileUtil.getArchiveFile((URL)folderRoot);
                    }
                    jdocPath = new File(URI.create(folderRoot.toExternalForm())).getAbsolutePath();
                }
                this.component.setSources(srcPath);
                this.component.setJavadoc(jdocPath);
            }
            this.component.jdkName.setEditable(false);
            if (platform == null && this.task != null) {
                this.task.schedule(0);
            } else {
                this.checkValid();
                this.fireStateChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] ll;
            WizardPanel wizardPanel = this;
            synchronized (wizardPanel) {
                if (this.changeList.isEmpty()) {
                    return;
                }
                ll = this.changeList.toArray(new ChangeListener[0]);
            }
            ChangeEvent ev = new ChangeEvent(this);
            for (ChangeListener l : ll) {
                l.stateChanged(ev);
            }
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeList.remove(l);
        }

        public void storeSettings(Object settings) {
            if (this.isValid()) {
                String jdocPath;
                CDCPlatform p = this.platform;
                String name = this.component.getPlatformName();
                this.platform.setDisplayName(name);
                String antName = WizardPanel.createAntName(name);
                p.setAntName(antName);
                ArrayList<PathResourceImplementation> src = new ArrayList<PathResourceImplementation>();
                ArrayList<URL> jdoc = new ArrayList<URL>();
                String srcPath = this.component.getSources();
                if (srcPath != null) {
                    File f = new File(srcPath);
                    try {
                        URL url = f.toURI().toURL();
                        if (FileUtil.isArchiveFile((URL)url)) {
                            FileObject fo = URLMapper.findFileObject((URL)(url = FileUtil.getArchiveRoot((URL)url)));
                            if (fo != null && (fo = fo.getFileObject("src")) != null) {
                                url = fo.getURL();
                            }
                            src.add(ClassPathSupport.createResource((URL)url));
                        } else {
                            src.add(ClassPathSupport.createResource((URL)url));
                        }
                    }
                    catch (MalformedURLException mue) {
                        ErrorManager.getDefault().notify((Throwable)mue);
                    }
                    catch (FileStateInvalidException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                if ((jdocPath = this.component.getJavadoc()) != null) {
                    StringTokenizer st = new StringTokenizer(jdocPath, ";");
                    while (st.hasMoreTokens()) {
                        File f = new File(st.nextToken());
                        try {
                            URL url = f.toURI().toURL();
                            if (FileUtil.isArchiveFile((URL)url)) {
                                jdoc.add(FileUtil.getArchiveRoot((URL)url));
                                continue;
                            }
                            jdoc.add(url);
                        }
                        catch (MalformedURLException mue) {
                            ErrorManager.getDefault().notify((Throwable)mue);
                        }
                    }
                }
                p.setSourceFolders(ClassPathSupport.createClassPath(src));
                p.setJavadocFolders(jdoc);
                this.iterator.setPlatform(p);
            }
        }

        public void taskFinished(Task task) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WizardPanel.this.detected = WizardPanel.this.detectPlatformTask.isValid();
                    if (WizardPanel.this.detected) {
                        WizardPanel.this.component.setJavadoc(WizardPanel.this.platform.getJavadocFolders());
                        WizardPanel.this.component.setSources(WizardPanel.this.platform.getSourceFolders());
                        WizardPanel.this.component.updateData(WizardPanel.this.platform.getDisplayName());
                        WizardPanel.this.component.jdkName.setEditable(true);
                        WizardPanel.this.component.addSourceButton.setEnabled(true);
                        WizardPanel.this.component.addJavadocButton.setEnabled(true);
                        WizardPanel.this.component.sourcesList.setEnabled(true);
                        WizardPanel.this.component.javadocList.setEnabled(true);
                    }
                    WizardPanel.this.checkValid();
                }
            });
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.checkValid();
        }

        protected void checkValid() {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)"");
            boolean v = true;
            boolean usedDisplayName = false;
            String name = this.component.getPlatformName();
            boolean b = this.isConfigured();
            if (b && !this.configured) {
                this.task = RequestProcessor.getDefault().create((Runnable)this.detectPlatformTask);
                this.task.addTaskListener((TaskListener)this);
                this.task.schedule(0);
                this.configured = b;
            }
            if (!this.configured) {
                CDCPlatformConfigurator configurator = this.detector.getConfigurator(this.installedFolder);
                if (configurator != null) {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)configurator.getInfo());
                } else {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_PlatformNotSet"));
                }
                v = false;
            } else {
                boolean validDisplayName;
                boolean bl = validDisplayName = name.length() > 0;
                if (!this.detected) {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_NoSDKRegistry"));
                } else if (!validDisplayName) {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_InvalidDisplayName"));
                } else {
                    JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
                    for (int i = 0; i < platforms.length; ++i) {
                        if (!name.equals(platforms[i].getDisplayName())) continue;
                        usedDisplayName = true;
                        this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_UsedDisplayName"));
                        break;
                    }
                }
                v = this.detected && validDisplayName && !usedDisplayName;
            }
            this.setValid(v);
        }

        private static String createAntName(String name) {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException();
            }
            String antName = PropertyUtils.getUsablePropertyName((String)name);
            if (WizardPanel.platformExists(antName)) {
                String baseName = antName;
                int index = 1;
                antName = baseName + Integer.toString(index);
                while (WizardPanel.platformExists(antName)) {
                    antName = baseName + Integer.toString(++index);
                }
            }
            return antName;
        }

        private static boolean platformExists(String antName) {
            JavaPlatformManager mgr = JavaPlatformManager.getDefault();
            JavaPlatform[] platforms = mgr.getInstalledPlatforms();
            for (int i = 0; i < platforms.length; ++i) {
                String val;
                if (!(platforms[i] instanceof CDCPlatform) || !antName.equals(val = ((CDCPlatform)platforms[i]).getAntName())) continue;
                return true;
            }
            return false;
        }

        private boolean isConfigured() {
            CDCPlatformConfigurator configurator = this.detector.getConfigurator(this.installedFolder);
            if (configurator == null) {
                return true;
            }
            return configurator.isConfigured();
        }

        private class DetectPlatformTask
        implements Runnable {
            private boolean valid = false;

            private DetectPlatformTask() {
            }

            public boolean isValid() {
                return this.valid;
            }

            @Override
            public void run() {
                try {
                    WizardPanel.this.platform = WizardPanel.this.detector.detectPlatform(WizardPanel.this.installedFolder);
                    this.valid = WizardPanel.this.platform != null;
                }
                catch (IOException ex) {
                    this.valid = false;
                }
            }
        }
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            if (index <= 0 || index == name.length() - 1) {
                return false;
            }
            String extension = name.substring(index + 1).toUpperCase();
            return this.extensions.contains(extension);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

