/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LocationCustomizer
extends ValidityAwarePanel
implements ActionListener,
ChangeListener,
DocumentListener,
HierarchyListener {
    private static final String FILE_LABEL_TEXT = NbBundle.getMessage(LocationCustomizer.class, (String)"LocationCustomizer_FileLabelText");
    private static final String BROWSE_BUTTON_TEXT = NbBundle.getMessage(LocationCustomizer.class, (String)"LocationCustomizer_BrowseButtonText");
    private static final String CURRENT_LINE_BUTTON_TEXT = NbBundle.getMessage(LocationCustomizer.class, (String)"LocationCustomizer_CurrentLineButtonText");
    private static final String LINE_LABEL_TEXT = NbBundle.getMessage(LocationCustomizer.class, (String)"LocationCustomizer_LineLabelText");
    private static final String BEGIN_RADIO_TEXT = NbBundle.getMessage(LocationCustomizer.class, (String)"LocationCustomizer_BeginRadioText");
    private static final String END_RADIO_TEXT = NbBundle.getMessage(LocationCustomizer.class, (String)"LocationCustomizer_EndRadioText");
    private static final String OFFSET_RADIO_TEXT = NbBundle.getMessage(LocationCustomizer.class, (String)"LocationCustomizer_OffsetRadioText");
    private static final String CHOOSE_FILE_DIALOG_CAPTION = NbBundle.getMessage(LocationCustomizer.class, (String)"LocationCustomizer_ChooseFileDialogCaption");
    private static final String FILE_DIALOG_FILTER_NAME = NbBundle.getMessage(LocationCustomizer.class, (String)"LocationCustomizer_FileDialogFilterName");
    private static int defaultTextComponentHeight = -1;
    private static JFileChooser fileChooser;
    private JButton fileButton;
    private JButton fromEditorButton;
    private JLabel fileLabel;
    private JLabel lineLabel;
    private JPanel firstLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JPanel secondLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JRadioButton lineBeginRadio;
    private JRadioButton lineEndRadio;
    private JRadioButton lineOffsetRadio;
    private JSeparator fromEditorSeparator;
    private JSpinner lineNumberSpinner;
    private JSpinner lineOffsetSpinner;
    private JTextField fileTextField;

    public LocationCustomizer() {
        this.initComponents();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.fileLabel.setEnabled(bl);
        this.fileTextField.setEnabled(bl);
        this.fileButton.setEnabled(bl);
        this.lineLabel.setEnabled(bl);
        this.lineNumberSpinner.setEnabled(bl);
        this.lineBeginRadio.setEnabled(bl);
        this.lineEndRadio.setEnabled(bl);
        this.lineOffsetRadio.setEnabled(bl);
        this.lineOffsetSpinner.setEnabled(!bl ? false : this.lineOffsetRadio.isSelected());
        this.fromEditorButton.setEnabled(bl);
    }

    public void setPPLocation(CodeProfilingPoint.Location location) {
        this.fileTextField.setText(location.getFile());
        this.lineNumberSpinner.setValue(location.getLine());
        int n = location.getOffset();
        if (n == Integer.MIN_VALUE) {
            this.lineBeginRadio.setSelected(true);
        } else if (n == Integer.MAX_VALUE) {
            this.lineEndRadio.setSelected(true);
        } else {
            this.lineOffsetRadio.setSelected(true);
            this.lineOffsetSpinner.setValue(n);
        }
    }

    public CodeProfilingPoint.Location getPPLocation() {
        int n = (Integer)this.lineOffsetSpinner.getValue();
        if (this.lineBeginRadio.isSelected()) {
            n = Integer.MIN_VALUE;
        } else if (this.lineEndRadio.isSelected()) {
            n = Integer.MAX_VALUE;
        }
        return new CodeProfilingPoint.Location(this.fileTextField.getText(), (Integer)this.lineNumberSpinner.getValue(), n);
    }

    public int getPreferredCaptionAreaWidth() {
        return Math.max(this.fileLabel.getPreferredSize().width, this.lineLabel.getPreferredSize().width);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fileButton) {
            JFileChooser jFileChooser = this.getFileChooser();
            jFileChooser.setCurrentDirectory(new File(this.fileTextField.getText()));
            if (jFileChooser.showOpenDialog(null) == 0) {
                this.fileTextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        } else if (actionEvent.getSource() == this.fromEditorButton) {
            if (this.lineBeginRadio.isSelected()) {
                this.setPPLocation(Utils.getCurrentLocation(Integer.MIN_VALUE));
            } else if (this.lineEndRadio.isSelected()) {
                this.setPPLocation(Utils.getCurrentLocation(Integer.MAX_VALUE));
            } else {
                this.setPPLocation(Utils.getCurrentLocation((Integer)this.lineOffsetSpinner.getValue()));
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window instanceof Dialog && !((Dialog)window).isModal()) {
                this.showFromEditor();
            } else {
                this.hideFromEditor();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LocationCustomizer locationCustomizer = new LocationCustomizer();
        JFrame jFrame = new JFrame("Customize Profiling Point");
        jFrame.getContentPane().add(locationCustomizer);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void normalizeCaptionAreaWidth(int n) {
        int n2 = this.getPreferredCaptionAreaWidth();
        int n3 = n - n2;
        int n4 = n3 > 0 ? n3 : 0;
        this.firstLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, n4, 0, 0));
        this.secondLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, n4, 0, 0));
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public void resetMnemonic() {
        this.fileLabel.setDisplayedMnemonic(0);
        this.fileLabel.setDisplayedMnemonicIndex(-1);
        this.fileButton.setMnemonic(0);
        this.fileButton.setDisplayedMnemonicIndex(-1);
        this.fromEditorButton.setMnemonic(0);
        this.fromEditorButton.setDisplayedMnemonicIndex(-1);
        this.lineLabel.setDisplayedMnemonic(0);
        this.lineLabel.setDisplayedMnemonicIndex(-1);
        this.lineBeginRadio.setMnemonic(0);
        this.lineBeginRadio.setDisplayedMnemonicIndex(-1);
        this.lineEndRadio.setMnemonic(0);
        this.lineEndRadio.setDisplayedMnemonicIndex(-1);
        this.lineOffsetRadio.setMnemonic(0);
        this.lineOffsetRadio.setDisplayedMnemonicIndex(-1);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.lineOffsetRadio) {
            this.lineOffsetSpinner.setEnabled(this.lineOffsetRadio.isSelected());
        }
    }

    private JFileChooser getFileChooser() {
        if (fileChooser == null) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setDialogType(0);
            jFileChooser.setDialogTitle(CHOOSE_FILE_DIALOG_CAPTION);
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".java");
                }

                @Override
                public String getDescription() {
                    return FILE_DIALOG_FILTER_NAME;
                }
            });
            fileChooser = jFileChooser;
        }
        return fileChooser;
    }

    private boolean isFileValid() {
        File file = new File(this.fileTextField.getText());
        return file.exists() && file.isFile();
    }

    private void hideFromEditor() {
        this.fromEditorSeparator.setVisible(false);
        this.fromEditorButton.setVisible(false);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.fileLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)FILE_LABEL_TEXT);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.fileLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.firstLineCaptionSpacer, gridBagConstraints);
        this.fileTextField = new JTextField(""){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.fileLabel.setLabelFor(this.fileTextField);
        this.fileTextField.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.fileButton, (String)BROWSE_BUTTON_TEXT);
        this.fileButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.fileButton, gridBagConstraints);
        this.fromEditorSeparator = new JSeparator(1){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.fromEditorSeparator, gridBagConstraints);
        this.fromEditorButton = new HTMLButton();
        Mnemonics.setLocalizedText((AbstractButton)this.fromEditorButton, (String)CURRENT_LINE_BUTTON_TEXT);
        this.fromEditorButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.fromEditorButton, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.lineLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.lineLabel, (String)LINE_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.lineLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.secondLineCaptionSpacer, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.lineNumberSpinner = new JExtendedSpinner(){

            public Dimension getPreferredSize() {
                return new Dimension(Math.max(super.getPreferredSize().width, 55), org.netbeans.modules.profiler.ui.stp.Utils.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.lineLabel.setLabelFor(this.lineNumberSpinner);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)this.lineNumberSpinner, gridBagConstraints);
        this.lineBeginRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.lineBeginRadio, (String)BEGIN_RADIO_TEXT);
        this.lineBeginRadio.getAccessibleContext().setAccessibleDescription(LINE_LABEL_TEXT + BEGIN_RADIO_TEXT);
        buttonGroup.add(this.lineBeginRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel.add((Component)this.lineBeginRadio, gridBagConstraints);
        this.lineEndRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.lineEndRadio, (String)END_RADIO_TEXT);
        this.lineEndRadio.getAccessibleContext().setAccessibleDescription(LINE_LABEL_TEXT + END_RADIO_TEXT);
        buttonGroup.add(this.lineEndRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel.add((Component)this.lineEndRadio, gridBagConstraints);
        this.lineOffsetRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.lineOffsetRadio, (String)OFFSET_RADIO_TEXT);
        this.lineOffsetRadio.getAccessibleContext().setAccessibleDescription(LINE_LABEL_TEXT + OFFSET_RADIO_TEXT);
        buttonGroup.add(this.lineOffsetRadio);
        this.lineOffsetRadio.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)new JPanel(new FlowLayout(3, 0, 0)){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(((LocationCustomizer)LocationCustomizer.this).lineOffsetRadio.getPreferredSize().width + ((LocationCustomizer)LocationCustomizer.this).lineOffsetSpinner.getPreferredSize().width, Math.max(((LocationCustomizer)LocationCustomizer.this).lineOffsetRadio.getPreferredSize().height, ((LocationCustomizer)LocationCustomizer.this).lineOffsetSpinner.getPreferredSize().height));
            }
        }, gridBagConstraints);
        this.lineOffsetSpinner = new JExtendedSpinner(){

            public Dimension getPreferredSize() {
                return new Dimension(Math.max(super.getPreferredSize().width, 55), org.netbeans.modules.profiler.ui.stp.Utils.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        this.addHierarchyListener(this);
    }

    private void showFromEditor() {
        this.fromEditorSeparator.setVisible(true);
        this.fromEditorButton.setVisible(true);
    }

    private void updateValidity() {
        boolean bl = this.isFileValid();
        this.fileTextField.setForeground(bl ? UIManager.getColor("TextField.foreground") : Color.RED);
        if (bl != this.areSettingsValid()) {
            this.fireValidityChanged(bl);
        }
    }

    private class HTMLButton
    extends JButton {
        private HTMLButton() {
        }

        @Override
        public void setEnabled(boolean bl) {
            this.setForeground(bl ? SystemColor.textText : SystemColor.textInactiveText);
            super.setEnabled(bl);
        }

        @Override
        public void setText(String string) {
            super.setText("<html><center><nobr>" + string.replace("\\n", "<br>") + "</nobr></center></html>");
            this.getAccessibleContext().setAccessibleName(string);
        }
    }
}

