/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaFrameGCRoot;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.ReferencesBrowserController;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.ui.FieldTreeCellRenderer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ReferencesBrowserControllerUI
extends JTitledPanel {
    private static final String VIEW_TITLE_REFERENCES = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ViewTitleReferences");
    private static final String NO_INSTANCE_SELECTED_MSG = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_NoInstanceSelectedMsg");
    private static final String SHOW_LOOP_ITEM_TEXT = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ShowLoopItemText");
    private static final String SHOW_INSTANCE_ITEM_TEXT = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ShowInstanceItemText");
    private static final String SHOW_IN_CLASSES_ITEM_TEXT = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ShowInClassesItemText");
    private static final String SHOW_GCROOT_ITEM_TEXT = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ShowGcRootItemText");
    private static final String GO_TO_SOURCE_ITEM_TEXT = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_GoToSourceItemText");
    private static final String SHOW_IN_THREADS_ITEM_TEXT = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ShowInThreadsItemText");
    private static final String SHOW_HIDE_COLUMNS_STRING = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ShowHideColumnsString");
    private static final String FIELD_COLUMN_NAME = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_FieldColumnName");
    private static final String FIELD_COLUMN_DESCR = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_FieldColumnDescr");
    private static final String TYPE_COLUMN_NAME = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_TypeColumnName");
    private static final String TYPE_COLUMN_DESCR = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_TypeColumnDescr");
    private static final String FULL_TYPE_COLUMN_NAME = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_FullTypeColumnName");
    private static final String FULL_TYPE_COLUMN_DESCR = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_FullTypeColumnDescr");
    private static final String VALUE_COLUMN_NAME = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ValueColumnName");
    private static final String VALUE_COLUMN_DESCR = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_ValueColumnDescr");
    private static final String SIZE_COLUMN_NAME = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_SizeColumnName");
    private static final String SIZE_COLUMN_DESCR = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_SizeColumnDescr");
    private static final String RETAINED_SIZE_COLUMN_NAME = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_RetainedSizeColumnName");
    private static final String RETAINED_SIZE_COLUMN_DESCR = NbBundle.getMessage(ReferencesBrowserControllerUI.class, (String)"ReferencesBrowserControllerUI_RetainedSizeColumnDescr");
    private static ImageIcon ICON_FIELDS = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/incomingRef.png", (boolean)false);
    private static final String DATA = "Data";
    private static final String NO_DATA = "No data";
    private int columnCount;
    private CardLayout contents;
    private FieldTreeCellRenderer treeCellRenderer = new FieldTreeCellRenderer();
    private FieldsListTreeTableModel realFieldsListTableModel;
    private ExtendedTreeTableModel fieldsListTableModel;
    private JMenuItem showGcRootItem;
    private JMenuItem showInstanceItem;
    private JMenuItem showLoopOriginItem;
    private JMenuItem showSourceItem;
    private JMenuItem showInThreadsItem;
    private JPanel dataPanel;
    private JPanel noDataPanel;
    private JPopupMenu cornerPopup;
    private JPopupMenu tablePopup;
    private JTreeTable fieldsListTable;
    private ReferencesBrowserController referencesBrowserController;
    private String filterValue = "";
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private int[] columnWidths;
    private boolean internalCornerButtonClick = false;
    private boolean needsUpdate = true;
    private boolean sortingOrder = true;
    private int sortingColumn = 0;
    private boolean retainedSizeSupported;
    private static final int MAX_STEP = 10;

    public ReferencesBrowserControllerUI(ReferencesBrowserController referencesBrowserController) {
        super(VIEW_TITLE_REFERENCES, (Icon)ICON_FIELDS, true);
        this.referencesBrowserController = referencesBrowserController;
        this.retainedSizeSupported = referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().getRetainedSizesStatus() != -1;
        this.columnCount = this.retainedSizeSupported ? 6 : 5;
        this.realFieldsListTableModel = new FieldsListTreeTableModel();
        this.fieldsListTableModel = new ExtendedTreeTableModel((AbstractTreeTableModel)this.realFieldsListTableModel);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && ReferencesBrowserControllerUI.this.isShowing() && ReferencesBrowserControllerUI.this.needsUpdate) {
                    ReferencesBrowserControllerUI.this.update();
                }
            }
        });
        this.initColumnsData();
        this.initData();
        this.initComponents();
        referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().addStateListener(new HeapFragmentWalker.StateListener(){

            @Override
            public void stateChanged(HeapFragmentWalker.StateEvent e) {
                if (e.getRetainedSizesStatus() == 3 && e.isMasterChange()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ReferencesBrowserControllerUI.this.fieldsListTableModel.setRealColumnVisibility(5, true);
                            ReferencesBrowserControllerUI.this.fieldsListTable.createDefaultColumnsFromModel();
                            ReferencesBrowserControllerUI.this.fieldsListTable.updateTreeTableHeader();
                            ReferencesBrowserControllerUI.this.setColumnsData();
                        }
                    });
                }
            }
        });
    }

    public void refreshView() {
        if (this.fieldsListTable != null) {
            this.fieldsListTable.updateTreeTable();
        }
    }

    public void selectNode(HeapWalkerNode node) {
        CCTNode[] pathArr = this.fieldsListTable.getPathToRoot((CCTNode)node);
        this.selectPath(pathArr, Math.min(pathArr.length, 10));
    }

    private void selectPath(final CCTNode[] path, final int length) {
        if (length >= path.length) {
            this.fieldsListTable.getTree().setSelectionPath(new TreePath(path));
        } else {
            Object[] shortPath = new Object[length];
            System.arraycopy(path, 0, shortPath, 0, length);
            final TreePath p = new TreePath(shortPath);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReferencesBrowserControllerUI.this.fieldsListTable.getTree().setSelectionPath(p);
                    ReferencesBrowserControllerUI.this.fieldsListTable.scrollRectToVisible(ReferencesBrowserControllerUI.this.fieldsListTable.getCellRect(ReferencesBrowserControllerUI.this.fieldsListTable.getSelectedRow(), 0, true));
                    ReferencesBrowserControllerUI.this.selectPath(path, length + 10);
                }
            });
        }
    }

    public void update() {
        if (this.isShowing()) {
            this.initData();
            if (this.contents != null) {
                if (this.fieldsListTableModel.getRoot() == null || this.fieldsListTableModel.getRoot() == ReferencesBrowserController.EMPTY_INSTANCE_NODE) {
                    this.contents.show(this.getContentPanel(), NO_DATA);
                } else {
                    this.contents.show(this.getContentPanel(), DATA);
                }
                this.fieldsListTable.resetTreeCellOffsetX();
            }
            this.needsUpdate = false;
        } else {
            this.needsUpdate = true;
        }
    }

    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.realFieldsListTableModel.getColumnCount(); ++i) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.realFieldsListTableModel.getColumnName(i));
            menuItem.setActionCommand(new Integer(i).toString());
            this.addMenuItemListener(menuItem);
            if (this.fieldsListTable != null) {
                menuItem.setState(this.fieldsListTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    menuItem.setEnabled(false);
                }
            } else {
                menuItem.setState(true);
            }
            this.cornerPopup.add(menuItem);
        }
        this.cornerPopup.pack();
    }

    private void setColumnsData() {
        TableColumnModel colModel = this.fieldsListTable.getColumnModel();
        this.fieldsListTable.setTreeCellRenderer((EnhancedTreeCellRenderer)this.treeCellRenderer);
        for (int i = 0; i < this.fieldsListTableModel.getColumnCount(); ++i) {
            int index = this.fieldsListTableModel.getRealColumn(i);
            if (index == 0) continue;
            colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private void addMenuItemListener(final JCheckBoxMenuItem menuItem) {
        final boolean[] internalChange = new boolean[1];
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (internalChange[0]) {
                    return;
                }
                final int column = Integer.parseInt(e.getActionCommand());
                if (column == 5 && !ReferencesBrowserControllerUI.this.fieldsListTableModel.isRealColumnVisible(column)) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            final int retainedSizesState = ReferencesBrowserControllerUI.this.referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().computeRetainedSizes(false);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (retainedSizesState != 3) {
                                        internalChange[0] = true;
                                        menuItem.setSelected(!menuItem.isSelected());
                                        internalChange[0] = false;
                                    } else {
                                        ReferencesBrowserControllerUI.this.fieldsListTableModel.setRealColumnVisibility(column, !ReferencesBrowserControllerUI.this.fieldsListTableModel.isRealColumnVisible(column));
                                        ReferencesBrowserControllerUI.this.fieldsListTable.createDefaultColumnsFromModel();
                                        ReferencesBrowserControllerUI.this.fieldsListTable.updateTreeTableHeader();
                                        ReferencesBrowserControllerUI.this.setColumnsData();
                                    }
                                }
                            });
                        }
                    });
                } else {
                    ReferencesBrowserControllerUI.this.fieldsListTableModel.setRealColumnVisibility(column, !ReferencesBrowserControllerUI.this.fieldsListTableModel.isRealColumnVisible(column));
                    ReferencesBrowserControllerUI.this.fieldsListTable.createDefaultColumnsFromModel();
                    ReferencesBrowserControllerUI.this.fieldsListTable.updateTreeTableHeader();
                    ReferencesBrowserControllerUI.this.setColumnsData();
                }
            }
        });
    }

    private JButton createHeaderPopupCornerButton(final JPopupMenu headerPopup) {
        final JButton cornerButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/lib/profiler/ui/resources/hideColumn.png", (boolean)false));
        cornerButton.setToolTipText(SHOW_HIDE_COLUMNS_STRING);
        cornerButton.setDefaultCapable(false);
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 2, 2));
        } else if (UIUtils.isWindowsXPLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 0, 1));
        } else if (UIUtils.isMetalLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 2, 1));
        }
        cornerButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 32) {
                    ReferencesBrowserControllerUI.this.showColumnSelectionPopup(headerPopup, cornerButton);
                }
            }
        });
        cornerButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (headerPopup.isVisible()) {
                    ReferencesBrowserControllerUI.this.internalCornerButtonClick = true;
                    cornerButton.getModel().setArmed(false);
                } else {
                    ReferencesBrowserControllerUI.this.internalCornerButtonClick = false;
                    if (mouseEvent.getModifiers() == 4) {
                        ReferencesBrowserControllerUI.this.showColumnSelectionPopup(headerPopup, cornerButton);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16 && !ReferencesBrowserControllerUI.this.internalCornerButtonClick) {
                    ReferencesBrowserControllerUI.this.showColumnSelectionPopup(headerPopup, cornerButton);
                }
            }
        });
        return cornerButton;
    }

    private JPopupMenu createTablePopup() {
        JPopupMenu popup = new JPopupMenu();
        this.showInstanceItem = new JMenuItem(SHOW_INSTANCE_ITEM_TEXT);
        this.showInstanceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferencesBrowserControllerUI.this.performDefaultAction();
            }
        });
        this.showInstanceItem.setFont(popup.getFont().deriveFont(1));
        this.showGcRootItem = new JMenuItem(SHOW_GCROOT_ITEM_TEXT);
        this.showGcRootItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceNode instanceNode;
                HeapWalkerNode node;
                int row = ReferencesBrowserControllerUI.this.fieldsListTable.getSelectedRow();
                if (row != -1 && (node = (HeapWalkerNode)ReferencesBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(row).getLastPathComponent()) instanceof InstanceNode && (instanceNode = (InstanceNode)node).hasInstance()) {
                    ReferencesBrowserControllerUI.this.referencesBrowserController.navigateToNearestGCRoot(instanceNode);
                }
            }
        });
        this.showLoopOriginItem = new JMenuItem(SHOW_LOOP_ITEM_TEXT);
        this.showLoopOriginItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapWalkerNode node;
                int row = ReferencesBrowserControllerUI.this.fieldsListTable.getSelectedRow();
                if (row != -1 && (node = (HeapWalkerNode)ReferencesBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(row).getLastPathComponent()) instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)node).isLoop()) {
                    ReferencesBrowserControllerUI.this.selectNode(((HeapWalkerInstanceNode)node).getLoopTo());
                }
            }
        });
        this.showSourceItem = new JMenuItem(GO_TO_SOURCE_ITEM_TEXT);
        this.showSourceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ReferencesBrowserControllerUI.this.fieldsListTable.getSelectedRow();
                if (row != -1) {
                    HeapWalkerNode node = (HeapWalkerNode)ReferencesBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(row).getLastPathComponent();
                    String className = node.getType();
                    while (className.endsWith("[]")) {
                        className = className.substring(0, className.length() - 2);
                    }
                    Project p = ReferencesBrowserControllerUI.this.referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().getHeapDumpProject();
                    NetBeansProfiler.getDefaultNB().openJavaSource(p, className, null, null);
                }
            }
        });
        this.showInThreadsItem = new JMenuItem(SHOW_IN_THREADS_ITEM_TEXT);
        this.showInThreadsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapWalkerNode node;
                int row = ReferencesBrowserControllerUI.this.fieldsListTable.getSelectedRow();
                if (row != -1 && (node = (HeapWalkerNode)ReferencesBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(row).getLastPathComponent()) instanceof HeapWalkerInstanceNode) {
                    Instance instance = ((HeapWalkerInstanceNode)node).getInstance();
                    ReferencesBrowserControllerUI.this.referencesBrowserController.showInThreads(instance);
                }
            }
        });
        popup.add(this.showInstanceItem);
        popup.add(this.showGcRootItem);
        popup.add(this.showInThreadsItem);
        popup.addSeparator();
        popup.add(this.showLoopOriginItem);
        popup.add(this.showSourceItem);
        return popup;
    }

    private void initColumnsData() {
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnToolTips = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnNames[0] = FIELD_COLUMN_NAME;
        this.columnToolTips[0] = FIELD_COLUMN_DESCR;
        this.columnNames[1] = TYPE_COLUMN_NAME;
        this.columnToolTips[1] = TYPE_COLUMN_DESCR;
        this.columnNames[2] = FULL_TYPE_COLUMN_NAME;
        this.columnToolTips[2] = FULL_TYPE_COLUMN_DESCR;
        this.columnNames[3] = VALUE_COLUMN_NAME;
        this.columnToolTips[3] = VALUE_COLUMN_DESCR;
        this.columnNames[4] = SIZE_COLUMN_NAME;
        this.columnToolTips[4] = SIZE_COLUMN_DESCR;
        if (this.retainedSizeSupported) {
            this.columnNames[5] = RETAINED_SIZE_COLUMN_NAME;
            this.columnToolTips[5] = RETAINED_SIZE_COLUMN_DESCR;
        }
        int unitWidth = this.getFontMetrics(this.getFont()).charWidth('W');
        FieldTreeCellRenderer treeCellRenderer = new FieldTreeCellRenderer();
        treeCellRenderer.setLeafIcon(null);
        treeCellRenderer.setClosedIcon(null);
        treeCellRenderer.setOpenIcon(null);
        LabelTableCellRenderer dataCellRenderer = new LabelTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = unitWidth * 18;
        this.columnRenderers[1] = dataCellRenderer;
        this.columnWidths[1] = unitWidth * 28;
        this.columnRenderers[2] = dataCellRenderer;
        this.columnWidths[2] = unitWidth * 14;
        this.columnRenderers[3] = dataCellRenderer;
        this.columnWidths[3] = unitWidth * 7;
        this.columnRenderers[4] = dataCellRenderer;
        if (this.retainedSizeSupported) {
            this.columnWidths[4] = unitWidth * 7;
            this.columnRenderers[5] = dataCellRenderer;
        }
    }

    private void initComponents() {
        this.treeCellRenderer.setLeafIcon(null);
        this.treeCellRenderer.setClosedIcon(null);
        this.treeCellRenderer.setOpenIcon(null);
        this.fieldsListTableModel.setRealColumnVisibility(2, false);
        this.fieldsListTableModel.setRealColumnVisibility(4, false);
        if (this.retainedSizeSupported) {
            this.fieldsListTableModel.setRealColumnVisibility(5, this.referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().getRetainedSizesStatus() == 3);
        }
        this.fieldsListTable = new JTreeTable((AbstractTreeTableModel)this.fieldsListTableModel){

            public void doLayout() {
                int columnsWidthsSum = 0;
                int realFirstColumn = -1;
                TableColumnModel colModel = this.getColumnModel();
                for (int i = 0; i < ReferencesBrowserControllerUI.this.fieldsListTableModel.getColumnCount(); ++i) {
                    if (ReferencesBrowserControllerUI.this.fieldsListTableModel.getRealColumn(i) == 0) {
                        realFirstColumn = i;
                        continue;
                    }
                    columnsWidthsSum += colModel.getColumn(i).getPreferredWidth();
                }
                if (realFirstColumn != -1) {
                    colModel.getColumn(realFirstColumn).setPreferredWidth(this.getWidth() - columnsWidthsSum);
                }
                super.doLayout();
            }
        };
        this.fieldsListTable.setSelectionMode(0);
        this.fieldsListTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.fieldsListTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.fieldsListTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.fieldsListTable.setShowHorizontalLines(false);
        this.fieldsListTable.setShowVerticalLines(true);
        this.fieldsListTable.setRowMargin(0);
        this.fieldsListTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.fieldsListTable.getTree().setLargeModel(true);
        this.fieldsListTable.getTree().setToggleClickCount(0);
        this.fieldsListTable.getColumnModel().getColumn(0).setMinWidth(150);
        this.fieldsListTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.fieldsListTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferencesBrowserControllerUI.this.performDefaultAction();
            }
        });
        HashSet<KeyStroke> keys = new HashSet<KeyStroke>(this.fieldsListTable.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.fieldsListTable.setFocusTraversalKeys(0, keys);
        keys = new HashSet(this.fieldsListTable.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.fieldsListTable.setFocusTraversalKeys(1, keys);
        this.setColumnsData();
        this.tablePopup = this.createTablePopup();
        this.cornerPopup = new JPopupMenu();
        JTreeTablePanel tablePanel = new JTreeTablePanel(this.fieldsListTable);
        tablePanel.setCorner("UPPER_RIGHT_CORNER", (Component)this.createHeaderPopupCornerButton(this.cornerPopup));
        this.dataPanel = new JPanel(new BorderLayout());
        this.dataPanel.add((Component)tablePanel, "Center");
        this.noDataPanel = new JPanel(new BorderLayout());
        this.noDataPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        HTMLTextArea hintArea = new HTMLTextArea();
        hintArea.setBorder(BorderFactory.createEmptyBorder(10, 8, 8, 8));
        String hintText = MessageFormat.format(NO_INSTANCE_SELECTED_MSG, "<img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/instances.png'>");
        hintArea.setText(hintText);
        this.noDataPanel.add((Component)hintArea, "Center");
        this.contents = new CardLayout();
        this.setLayout(this.contents);
        this.add(this.noDataPanel, NO_DATA);
        this.add(this.dataPanel, DATA);
        this.fieldsListTable.addMouseListener((MouseListener)new FieldsListTableMouseListener());
        this.fieldsListTable.addKeyListener((KeyListener)new FieldsListTableKeyListener());
    }

    private void initData() {
        this.fieldsListTableModel.setRoot((Object)this.referencesBrowserController.getFilteredSortedReferences(this.filterValue, this.sortingColumn, this.sortingOrder));
        this.refreshView();
    }

    private void navigateToInstance(Instance instance) {
        this.referencesBrowserController.navigateToInstance(instance);
    }

    private void performDefaultAction() {
        HeapWalkerNode node;
        int row = this.fieldsListTable.getSelectedRow();
        if (row != -1 && (node = (HeapWalkerNode)this.fieldsListTable.getTree().getPathForRow(row).getLastPathComponent()) instanceof HeapWalkerInstanceNode) {
            this.referencesBrowserController.createNavigationHistoryPoint();
            HeapWalkerInstanceNode instanceNode = (HeapWalkerInstanceNode)node;
            this.referencesBrowserController.navigateToInstance(instanceNode.getInstance());
        }
    }

    private void saveColumnsData() {
        TableColumnModel colModel = this.fieldsListTable.getColumnModel();
        for (int i = 0; i < this.fieldsListTableModel.getColumnCount(); ++i) {
            int index = this.fieldsListTableModel.getRealColumn(i);
            if (index == 0) continue;
            this.columnWidths[index - 1] = colModel.getColumn(i).getPreferredWidth();
        }
    }

    private void showColumnSelectionPopup(JPopupMenu headerPopup, JButton cornerButton) {
        this.initColumnSelectorItems();
        headerPopup.show(cornerButton, cornerButton.getWidth() - headerPopup.getPreferredSize().width, cornerButton.getHeight());
    }

    private void showPopupMenu(int row, int x, int y) {
        HeapWalkerNode node = (HeapWalkerNode)this.fieldsListTable.getTree().getPathForRow(row).getLastPathComponent();
        if (node instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)node).isLoop()) {
            this.showLoopOriginItem.setVisible(true);
        } else {
            this.showLoopOriginItem.setVisible(false);
        }
        if (node.isRoot()) {
            this.showInstanceItem.setEnabled(false);
        } else {
            this.showInstanceItem.setEnabled(node instanceof HeapWalkerInstanceNode && (!(node instanceof HeapWalkerFieldNode) || !((HeapWalkerFieldNode)node).isStatic()));
        }
        this.showGcRootItem.setEnabled(node instanceof HeapWalkerInstanceNode && (!node.currentlyHasChildren() || node.getNChildren() != 1 || !HeapWalkerNodeFactory.isMessageNode(node.getChild(0))));
        this.showSourceItem.setEnabled(node instanceof HeapWalkerInstanceNode);
        this.showInThreadsItem.setEnabled(false);
        if (node instanceof HeapWalkerInstanceNode) {
            JavaFrameGCRoot frameVar;
            Instance rootInstance = ((HeapWalkerInstanceNode)node).getInstance();
            Heap heap = this.referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().getHeapFragment();
            GCRoot gcRoot = heap.getGCRoot(rootInstance);
            if (gcRoot != null && "Java frame".equals(gcRoot.getKind()) && (frameVar = (JavaFrameGCRoot)gcRoot).getFrameNumber() != -1) {
                this.showInThreadsItem.setEnabled(true);
            }
        }
        if (x == -1 || y == -1) {
            Rectangle rowBounds = this.fieldsListTable.getCellRect(row, 0, true);
            if (x == -1) {
                x = rowBounds.x + rowBounds.width / 2;
            }
            if (y == -1) {
                y = rowBounds.y + rowBounds.height / 2;
            }
        }
        this.tablePopup.show((Component)this.fieldsListTable, x, y);
    }

    private class FieldsListTreeTableModel
    extends AbstractTreeTableModel {
        private FieldsListTreeTableModel() {
            super((CCTNode)ReferencesBrowserController.EMPTY_INSTANCE_NODE);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return Object.class;
        }

        public int getColumnCount() {
            return ReferencesBrowserControllerUI.this.columnCount;
        }

        public String getColumnName(int columnIndex) {
            return ReferencesBrowserControllerUI.this.columnNames[columnIndex];
        }

        public String getColumnToolTipText(int col) {
            return ReferencesBrowserControllerUI.this.columnToolTips[col];
        }

        public boolean isLeaf(Object node) {
            return ((HeapWalkerNode)node).isLeaf();
        }

        public Object getValueAt(Object object, int columnIndex) {
            HeapWalkerNode fieldNode = (HeapWalkerNode)object;
            switch (columnIndex) {
                case 0: {
                    return fieldNode;
                }
                case 1: {
                    return fieldNode.getSimpleType();
                }
                case 2: {
                    return fieldNode.getType();
                }
                case 3: {
                    return fieldNode.getValue();
                }
                case 4: {
                    return fieldNode.getSize();
                }
                case 5: {
                    return fieldNode.getRetainedSize();
                }
            }
            return null;
        }
    }

    private class FieldsListTableMouseListener
    extends MouseAdapter {
        private FieldsListTableMouseListener() {
        }

        private void updateSelection(int row) {
            ReferencesBrowserControllerUI.this.fieldsListTable.requestFocusInWindow();
            if (row != -1) {
                ReferencesBrowserControllerUI.this.fieldsListTable.setRowSelectionInterval(row, row);
            } else {
                ReferencesBrowserControllerUI.this.fieldsListTable.clearSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row = ReferencesBrowserControllerUI.this.fieldsListTable.rowAtPoint(e.getPoint());
            this.updateSelection(row);
            if (e.isPopupTrigger()) {
                ReferencesBrowserControllerUI.this.showPopupMenu(row, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int row = ReferencesBrowserControllerUI.this.fieldsListTable.rowAtPoint(e.getPoint());
            this.updateSelection(row);
            if (e.isPopupTrigger()) {
                ReferencesBrowserControllerUI.this.showPopupMenu(row, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                HeapWalkerNode node;
                int row = ReferencesBrowserControllerUI.this.fieldsListTable.rowAtPoint(e.getPoint());
                if (e.getX() >= ((ReferencesBrowserControllerUI)ReferencesBrowserControllerUI.this).fieldsListTable.getTree().getRowBounds((int)row).x - ReferencesBrowserControllerUI.this.fieldsListTable.getTreeCellOffsetX() && row != -1 && (node = (HeapWalkerNode)ReferencesBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(row).getLastPathComponent()) instanceof HeapWalkerInstanceNode) {
                    ReferencesBrowserControllerUI.this.performDefaultAction();
                }
            }
        }
    }

    private class FieldsListTableKeyListener
    extends KeyAdapter {
        private FieldsListTableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int selectedRow;
            if ((e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) && (selectedRow = ReferencesBrowserControllerUI.this.fieldsListTable.getSelectedRow()) != -1) {
                ReferencesBrowserControllerUI.this.showPopupMenu(selectedRow, -1, -1);
            }
        }
    }
}

