/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;
import org.netbeans.modules.profiler.heapwalk.ClassesController;
import org.netbeans.modules.profiler.heapwalk.LegendPanel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ClassesControllerUI
extends JPanel {
    private static final String CONTROLLER_NAME = NbBundle.getMessage(ClassesControllerUI.class, (String)"ClassesControllerUI_ControllerName");
    private static final String CONTROLLER_DESCR = NbBundle.getMessage(ClassesControllerUI.class, (String)"ClassesControllerUI_ControllerDescr");
    private AbstractButton presenter;
    private ClassesController classesController;
    private JSplitPane contentsSplit;

    public ClassesControllerUI(ClassesController classesController) {
        this.classesController = classesController;
        this.initComponents();
    }

    public AbstractButton getPresenter() {
        if (this.presenter == null) {
            this.presenter = new Presenter();
        }
        return this.presenter;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel jPanel = this.classesController.getStaticFieldsBrowserController().getPanel();
        jPanel.setPreferredSize(new Dimension(250, 500));
        jPanel.setVisible(false);
        this.contentsSplit = new JExtendedSplitPane(1, (Component)this.classesController.getClassesListController().getPanel(), (Component)jPanel);
        this.contentsSplit.setResizeWeight(1.0);
        final LegendPanel legendPanel = new LegendPanel(false);
        legendPanel.setVisible(false);
        this.tweakSplitPaneUI(this.contentsSplit);
        this.add((Component)this.contentsSplit, "Center");
        this.add((Component)legendPanel, "South");
        jPanel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                    legendPanel.setVisible(jPanel.isShowing());
                }
            }
        });
    }

    private void tweakSplitPaneUI(JSplitPane jSplitPane) {
        jSplitPane.setBorder(null);
        jSplitPane.setDividerSize(3);
        if (!(jSplitPane.getUI() instanceof BasicSplitPaneUI)) {
            return;
        }
        BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)jSplitPane.getUI()).getDivider();
        if (basicSplitPaneDivider != null) {
            basicSplitPaneDivider.setBorder(null);
        }
    }

    private static class Presenter
    extends JToggleButton {
        private static ImageIcon ICON_CLASS = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/class.png", (boolean)false);

        public Presenter() {
            this.setText(CONTROLLER_NAME);
            this.setToolTipText(CONTROLLER_DESCR);
            this.setIcon(ICON_CLASS);
            this.setMargin(new Insets(this.getMargin().top, this.getMargin().top, this.getMargin().bottom, this.getMargin().top));
        }
    }
}

