/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import org.netbeans.modules.profiler.CPUSnapshotPanel;
import org.netbeans.modules.profiler.FragmentSnapshotPanel;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.MemorySnapshotPanel;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public final class SnapshotResultsWindow
extends TopComponent
implements SnapshotsListener {
    private static final String SAVE_SNAPSHOT_DIALOG_MSG = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotResultsWindow_SaveSnapshotDialogMsg");
    private static final String CPU_SNAPSHOT_ACCESS_DESCR = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotResultsWindow_CpuSnapshotAccessDescr");
    private static final String FRAGMENT_SNAPSHOT_ACCESS_DESCR = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotResultsWindow_FragmentSnapshotAccessDescr");
    private static final String MEMORY_SNAPSHOT_ACCESS_DESCR = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotResultsWindow_MemorySnapshotAccessDescr");
    private static final Image WINDOW_ICON_CPU = ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/cpu.png");
    private static final Image WINDOWS_ICON_FRAGMENT = ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/fragment.png");
    private static final Image WINDOWS_ICON_MEMORY = ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/memory.png");
    private static final HashMap windowsList = new HashMap();
    private Component lastFocusOwner;
    private LoadedSnapshot snapshot;
    private SaveNode saveSupport = new SaveNode();
    private SavePerformer savePerformer = new SavePerformer();
    private SnapshotPanel displayedPanel;
    private String tabName = "";
    private boolean forcedClose = false;

    public SnapshotResultsWindow() {
        throw new InternalError("This constructor should never be called");
    }

    public SnapshotResultsWindow(LoadedSnapshot ls, int sortingColumn, boolean sortingOrder) {
        this.snapshot = ls;
        ResultsManager.getDefault().addSnapshotsListener(this);
        this.updateSaveState();
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        switch (ls.getType()) {
            case 1: {
                this.getAccessibleContext().setAccessibleDescription(CPU_SNAPSHOT_ACCESS_DESCR);
                this.displayCPUResults(ls, sortingColumn, sortingOrder);
                break;
            }
            case 2: {
                this.getAccessibleContext().setAccessibleDescription(FRAGMENT_SNAPSHOT_ACCESS_DESCR);
                this.displayCodeRegionResults(ls);
                break;
            }
            case 4: 
            case 8: {
                this.getAccessibleContext().setAccessibleDescription(MEMORY_SNAPSHOT_ACCESS_DESCR);
                this.displayMemoryResults(ls, sortingColumn, sortingOrder);
            }
        }
    }

    public static synchronized void closeAllWindows() {
        Collection windows = windowsList.values();
        if (!windows.isEmpty()) {
            SnapshotResultsWindow[] toClose = new SnapshotResultsWindow[windows.size()];
            windows.toArray(toClose);
            for (int i = 0; i < toClose.length; ++i) {
                SnapshotResultsWindow snapshotResultsWindow = toClose[i];
                snapshotResultsWindow.forcedClose();
            }
        }
    }

    public static synchronized void closeWindow(LoadedSnapshot snapshot) {
        SnapshotResultsWindow win = (SnapshotResultsWindow)windowsList.get(snapshot);
        if (win != null) {
            win.forcedClose();
        }
    }

    public static synchronized SnapshotResultsWindow get(LoadedSnapshot ls) {
        return SnapshotResultsWindow.get(ls, -1, false);
    }

    public static synchronized SnapshotResultsWindow get(LoadedSnapshot ls, int sortingColumn, boolean sortingOrder) {
        SnapshotResultsWindow win = (SnapshotResultsWindow)windowsList.get(ls);
        if (win == null) {
            win = new SnapshotResultsWindow(ls, sortingColumn, sortingOrder);
            windowsList.put(ls, win);
        }
        return win;
    }

    public static synchronized boolean hasSnapshotWindow(LoadedSnapshot ls) {
        return windowsList.get(ls) != null;
    }

    public int getPersistenceType() {
        return 2;
    }

    public boolean canClose() {
        if (this.forcedClose) {
            this.setActivatedNodes(new Node[0]);
            return true;
        }
        if (this.snapshot.isSaved()) {
            return true;
        }
        ProfilerDialogs.DNSAConfirmation dd = new ProfilerDialogs.DNSAConfirmation("org.netbeans.modules.profiler.SnapshotResultsWindow.canClose", (Object)SAVE_SNAPSHOT_DIALOG_MSG, 1);
        dd.setDNSADefault(false);
        Object ret = ProfilerDialogs.notify((NotifyDescriptor)dd);
        if (ret.equals(DialogDescriptor.CANCEL_OPTION) || ret.equals(DialogDescriptor.CLOSED_OPTION)) {
            return false;
        }
        if (ret.equals(DialogDescriptor.YES_OPTION)) {
            ResultsManager.getDefault().saveSnapshot(this.snapshot);
            this.setActivatedNodes(new Node[0]);
            return true;
        }
        this.setActivatedNodes(new Node[0]);
        return true;
    }

    public void componentActivated() {
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else if (this.displayedPanel != null) {
            this.displayedPanel.requestFocus();
        }
    }

    public void componentDeactivated() {
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    public void displayStacksForClass(int selectedClassId, int sortingColumn, boolean sortingOrder) {
        if (this.displayedPanel instanceof MemorySnapshotPanel) {
            ((MemorySnapshotPanel)this.displayedPanel).displayStacksForClass(selectedClassId, sortingColumn, sortingOrder);
        }
    }

    @Override
    public void snapshotLoaded(LoadedSnapshot snapshot) {
    }

    @Override
    public void snapshotRemoved(LoadedSnapshot snapshot) {
    }

    @Override
    public void snapshotSaved(LoadedSnapshot snapshot) {
        this.updateSaveState();
    }

    @Override
    public void snapshotTaken(LoadedSnapshot snapshot) {
    }

    public void updateTitle() {
        if (this.snapshot.isSaved()) {
            this.setName(this.tabName);
        } else {
            this.setName(this.tabName + " *");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentClosed() {
        Class<SnapshotResultsWindow> clazz = SnapshotResultsWindow.class;
        synchronized (SnapshotResultsWindow.class) {
            windowsList.remove(this.snapshot);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ResultsManager.getDefault().closeSnapshot(this.snapshot);
            ResultsManager.getDefault().removeSnapshotsListener(this);
            this.snapshot = null;
            return;
        }
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    private void setTabName(String innerName) {
        this.tabName = innerName;
        this.updateTitle();
    }

    private void displayCPUResults(LoadedSnapshot ls, int sortingColumn, boolean sortingOrder) {
        CPUSnapshotPanel cpuPanel = new CPUSnapshotPanel(ls, sortingColumn, sortingOrder);
        this.displayedPanel = cpuPanel;
        this.updateFind(true, cpuPanel);
        this.add(cpuPanel, "Center");
        this.setTabName(cpuPanel.getTitle());
        this.setIcon(WINDOW_ICON_CPU);
    }

    private void displayCodeRegionResults(LoadedSnapshot ls) {
        this.updateFind(false, null);
        FragmentSnapshotPanel codeRegionPanel = new FragmentSnapshotPanel(ls);
        this.displayedPanel = codeRegionPanel;
        this.add(codeRegionPanel, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setTabName(codeRegionPanel.getTitle());
        this.setIcon(WINDOWS_ICON_FRAGMENT);
    }

    private void displayMemoryResults(LoadedSnapshot ls, int sortingColumn, boolean sortingOrder) {
        MemorySnapshotPanel memoryPanel = new MemorySnapshotPanel(ls, sortingColumn, sortingOrder);
        this.displayedPanel = memoryPanel;
        this.updateFind(true, memoryPanel);
        this.add(memoryPanel, "Center");
        this.setTabName(memoryPanel.getTitle());
        this.setIcon(WINDOWS_ICON_MEMORY);
    }

    private void forcedClose() {
        this.forcedClose = true;
        this.close();
    }

    private void updateFind(boolean enabled, final FindPerformer performer) {
        CallbackSystemAction globalFindAction = (CallbackSystemAction)SystemAction.get(FindAction.class);
        Object findActionKey = globalFindAction.getActionMapKey();
        if (enabled) {
            this.getActionMap().put(findActionKey, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    performer.performFind();
                }
            });
        } else {
            this.getActionMap().remove(findActionKey);
        }
    }

    private void updateSaveState() {
        this.saveSupport.setSaveEnabled(!this.snapshot.isSaved());
        this.setActivatedNodes(new Node[]{this.saveSupport});
        if (this.displayedPanel != null) {
            this.displayedPanel.updateSavedState();
        }
    }

    private class SavePerformer
    implements SaveCookie {
        private SavePerformer() {
        }

        public void save() throws IOException {
            ResultsManager.getDefault().saveSnapshot(SnapshotResultsWindow.this.snapshot);
        }
    }

    private class SaveNode
    extends AbstractNode {
        public SaveNode() {
            super(Children.LEAF);
        }

        public void setSaveEnabled(boolean saveEnabled) {
            if (saveEnabled) {
                if (this.getCookie(SaveCookie.class) == null) {
                    this.getCookieSet().add((Node.Cookie)SnapshotResultsWindow.this.savePerformer);
                }
            } else if (this.getCookie(SaveCookie.class) != null) {
                this.getCookieSet().remove((Node.Cookie)SnapshotResultsWindow.this.savePerformer);
            }
        }
    }

    public static interface FindPerformer {
        public void performFind();

        public void performFindNext();

        public void performFindPrevious();
    }
}

