/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.openide.util.NbBundle;

class GestureSubmitter {
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.profiler");

    GestureSubmitter() {
    }

    static void logConfig(ProfilingSettings settings) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        GestureSubmitter.fillParamsForProfiling(settings, paramList);
        GestureSubmitter.logUsage("CONFIG", paramList);
    }

    static void logProfileApp(Project profiledProject, SessionSettings session) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        GestureSubmitter.fillProjectParam(profiledProject, paramList);
        GestureSubmitter.fillParamsForSession(session, paramList);
        GestureSubmitter.logUsage("PROFILE_APP", paramList);
    }

    static void logProfileClass(Project profiledProject, SessionSettings session) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        GestureSubmitter.fillProjectParam(profiledProject, paramList);
        GestureSubmitter.fillParamsForSession(session, paramList);
        GestureSubmitter.logUsage("PROFILE_CLASS", paramList);
    }

    static void logAttach(Project profiledProject, AttachSettings attach) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        GestureSubmitter.fillProjectParam(profiledProject, paramList);
        GestureSubmitter.fillParamsForAttach(attach, paramList);
        GestureSubmitter.logUsage("ATTACH", paramList);
    }

    private static void fillProjectParam(Project profiledProject, List<Object> paramList) {
        String param = "";
        if (profiledProject != null) {
            param = profiledProject.getClass().getName();
        }
        paramList.add(0, param);
    }

    private static void fillParamsForAttach(AttachSettings as, List<Object> paramList) {
        paramList.add("OS_" + as.getHostOS());
        paramList.add(as.isDirect() ? "ATTACH_DIRECT" : "ATTACH_DYNAMIC");
        paramList.add(as.isRemote() ? "ATTACH_REMOTE" : "ATTACH_LOCAL");
    }

    private static void fillParamsForProfiling(ProfilingSettings ps, List<Object> paramList) {
        switch (ps.getProfilingType()) {
            case 8: {
                paramList.add("TYPE_CPU_ENTIRE");
                break;
            }
            case 16: {
                paramList.add("TYPE_CPU_PART");
                break;
            }
            case 32: {
                paramList.add("TYPE_CPU_STOPWATCH");
                break;
            }
            case 2: {
                paramList.add("TYPE_MEM_ALLOC");
                break;
            }
            case 4: {
                paramList.add("TYPE_MEM_LIVENESS");
                break;
            }
            case 1: {
                paramList.add("TYPE_MONITOR");
            }
        }
        switch (ps.getInstrScheme()) {
            case 2: {
                paramList.add("INSTR_EAGER");
                break;
            }
            case 1: {
                paramList.add("INSTR_LAZY");
                break;
            }
            case 3: {
                paramList.add("INSTR_TOTAL");
            }
        }
        paramList.add(ps.getProfileUnderlyingFramework() ? "FRAMEWORK_YES" : "FRAMEWORK_NO");
        paramList.add(ps.getExcludeWaitTime() ? "WAIT_EXCLUDE" : "WAIT_INCLUDE");
        paramList.add(ps.getInstrumentMethodInvoke() ? "REFL_INVOKE_YES" : "REFL_INVOKE_NO");
        paramList.add(ps.getInstrumentSpawnedThreads() ? "SPAWNED_THREADS_YES" : "SPAWNED_THREADS_NO");
        paramList.add(ps.getThreadCPUTimerOn() ? "THREAD_CPU_YES" : "THREAD_CPU_NO");
        paramList.add(ps.useProfilingPoints() ? "PPOINTS_YES" : "PPOINTS_NO");
    }

    private static void fillParamsForSession(SessionSettings ss, List<Object> paramList) {
        paramList.add("JAVA_" + ss.getJavaVersionString());
    }

    private static void logUsage(String startType, List<Object> params) {
        LogRecord record = new LogRecord(Level.INFO, "USG_PROFILER_" + startType);
        record.setResourceBundle(NbBundle.getBundle(NetBeansProfiler.class));
        record.setResourceBundleName(NetBeansProfiler.class.getPackage().getName() + ".Bundle");
        record.setLoggerName(USG_LOGGER.getName());
        record.setParameters(params.toArray(new Object[params.size()]));
        USG_LOGGER.log(record);
    }
}

