/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.EditorView;

final class ViewReplace<V extends EditorBoxView, CV extends EditorView> {
    private static final Logger LOG = Logger.getLogger(ViewReplace.class.getName());
    final V view;
    int index;
    int removeCount;
    List<CV> added;

    ViewReplace(V view, int index) {
        assert (view != null);
        this.view = view;
        this.index = index;
    }

    void add(CV view) {
        if (this.added == null) {
            this.added = new ArrayList<CV>();
        }
        this.added.add(view);
    }

    int removeEndIndex() {
        return this.index + this.removeCount;
    }

    void removeTillEnd() {
        this.removeCount = ((EditorBoxView)this.view).getViewCount() - this.index;
    }

    private EditorView[] addedViews() {
        EditorView[] views;
        if (this.added != null) {
            views = new EditorView[this.added.size()];
            this.added.toArray(views);
        } else {
            views = new EditorView[]{};
        }
        return views;
    }

    EditorView childViewAtIndex() {
        return ((EditorBoxView)this.view).getEditorView(this.index);
    }

    EditorBoxView.ReplaceResult replaceViews(int offsetDelta, Shape alloc) {
        if (this.removeCount > 0 || this.added != null) {
            return ((EditorBoxView)this.view).replace(this.index, this.removeCount, this.addedViews(), offsetDelta, alloc);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("viewId=").append(((EditorView)this.view).getDumpId());
        sb.append(", index=").append(this.index);
        sb.append(", viewCount=").append(((EditorBoxView)this.view).getViewCount());
        sb.append(", removeCount=").append(this.removeCount);
        EditorView[] addedViews = this.addedViews();
        sb.append(", addedCount=").append(addedViews.length);
        if (addedViews.length > 0) {
            sb.append(", Added:\n");
            int maxDigitCount = ArrayUtilities.digitCount((int)addedViews.length);
            for (int i = 0; i < addedViews.length; ++i) {
                sb.append("    ");
                ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)maxDigitCount);
                sb.append(addedViews[i].toString());
                sb.append('\n');
            }
        } else {
            sb.append("\n");
        }
        return sb.toString();
    }
}

