/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.font.TextLayout;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.EditorBoxViewChildren;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.ParagraphViewChildren;
import org.netbeans.modules.editor.lib2.view.TextLayoutView;

public class ParagraphView
extends EditorBoxView<EditorView> {
    private static final Logger LOG = Logger.getLogger(ParagraphView.class.getName());
    private Position startPos;
    private int length;

    public ParagraphView(Position startPos) {
        super(null);
        this.startPos = startPos;
    }

    @Override
    public int getMajorAxis() {
        return 0;
    }

    @Override
    public int getStartOffset() {
        return this.startPos.getOffset();
    }

    @Override
    public int getEndOffset() {
        return this.getStartOffset() + this.getLength();
    }

    @Override
    public AttributeSet getAttributes() {
        return null;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public boolean setLength(int length) {
        this.length = length;
        return true;
    }

    @Override
    public int getRawOffset() {
        return -1;
    }

    @Override
    public void setRawOffset(int rawOffset) {
        throw new IllegalStateException("setRawOffset() must not be called on ParagraphView.");
    }

    @Override
    protected EditorBoxViewChildren<EditorView> createChildren(int capacity) {
        return new ParagraphViewChildren(capacity);
    }

    DocumentView getDocumentView() {
        return (DocumentView)this.getParent();
    }

    @Override
    public void setParent(View parent) {
        DocumentView documentView;
        super.setParent(parent);
        if (parent instanceof EditorBoxView && (documentView = this.getDocumentView()) != null) {
            this.setMinorAxisSpan(documentView.getDefaultLineHeight());
        }
    }

    @Override
    public TextLayout getTextLayout(TextLayoutView textLayoutView) {
        DocumentView documentView = this.getDocumentView();
        return documentView != null ? documentView.getTextLayoutCache().get(this, textLayoutView) : null;
    }

    void recomputeSpans() {
        if (this.children != null) {
            ((ParagraphViewChildren)this.children).recomputeSpans(this);
        }
    }

    @Override
    public String findIntegrityError() {
        String err = super.findIntegrityError();
        if (err == null && this.children != null) {
            int childrenLength = this.children.getLength();
            if (this.getLength() != childrenLength) {
                err = "length=" + this.getLength() + " != childrenLength=" + childrenLength;
            }
        }
        return err;
    }

    @Override
    protected String getDumpName() {
        return "PV";
    }
}

