/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public final class SyntaxHighlighting
extends AbstractHighlightsContainer
implements TokenHierarchyListener {
    private static final Logger LOG = Logger.getLogger(SyntaxHighlighting.class.getName());
    public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.SyntaxHighlighting";
    private final HashMap<String, WeakHashMap<TokenId, AttributeSet>> attribsCache = new HashMap();
    private final HashMap<String, FontColorSettings> fcsCache = new HashMap();
    private final Document document;
    private final String mimeTypeForHack;
    private TokenHierarchy<? extends Document> hierarchy = null;
    private long version = 0L;

    public SyntaxHighlighting(Document document) {
        this.document = document;
        String mimeType = (String)document.getProperty("mimeType");
        this.mimeTypeForHack = mimeType != null && mimeType.startsWith("test") ? mimeType : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        SyntaxHighlighting syntaxHighlighting = this;
        synchronized (syntaxHighlighting) {
            if (this.hierarchy == null) {
                this.hierarchy = TokenHierarchy.get((Document)this.document);
                this.hierarchy.addTokenHierarchyListener((TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)((Object)this), this.hierarchy));
            }
            if (this.hierarchy.isActive()) {
                return new HSImpl(this.version, this.hierarchy, startOffset, endOffset);
            }
            return HighlightsSequence.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
        if (evt.type() == TokenHierarchyEventType.LANGUAGE_PATHS) {
            return;
        }
        SyntaxHighlighting syntaxHighlighting = this;
        synchronized (syntaxHighlighting) {
            ++this.version;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder();
            TokenSequence ts = this.hierarchy.tokenSequence();
            sb.append("\n");
            sb.append("Tokens after change: <").append(evt.affectedStartOffset()).append(", ").append(evt.affectedEndOffset()).append(">\n");
            SyntaxHighlighting.dumpSequence(ts, sb);
            sb.append("--------------------------------------------\n\n");
            LOG.finest(sb.toString());
        }
        this.fireHighlightsChange(evt.affectedStartOffset(), evt.affectedEndOffset());
    }

    private static void dumpSequence(TokenSequence<?> seq, StringBuilder sb) {
        if (seq == null) {
            sb.append("Inactive TokenHierarchy");
        } else {
            seq.moveStart();
            while (seq.moveNext()) {
                TokenSequence emSeq = seq.embedded();
                if (emSeq != null) {
                    SyntaxHighlighting.dumpSequence(emSeq, sb);
                    continue;
                }
                Token token = seq.token();
                sb.append("<");
                sb.append(String.format("%3s", seq.offset())).append(", ");
                sb.append(String.format("%3s", seq.offset() + token.length())).append(", ");
                sb.append(String.format("%+3d", token.length())).append("> : ");
                sb.append(SyntaxHighlighting.tokenId(token.id(), true)).append(" : '");
                sb.append(SyntaxHighlighting.tokenText(token));
                sb.append("'\n");
            }
        }
    }

    private static String tokenId(TokenId tokenId, boolean format) {
        if (format) {
            return String.format("%20s.%-15s", tokenId.getClass().getSimpleName(), tokenId.name());
        }
        return tokenId.getClass().getSimpleName() + "." + tokenId.name();
    }

    private static String tokenText(Token<?> token) {
        CharSequence text = token.text();
        StringBuilder sb = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isISOControl(ch)) {
                switch (ch) {
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    default: {
                        sb.append("\\").append(Integer.toOctalString(ch));
                        break;
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static String attributeSet(AttributeSet as) {
        if (as == null) {
            return "AttributeSet is null";
        }
        StringBuilder sb = new StringBuilder();
        Enumeration<?> keys = as.getAttributeNames();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = as.getAttribute(key);
            if (key == null) {
                sb.append("null");
            } else {
                sb.append("'").append(key.toString()).append("'");
            }
            sb.append(" = ");
            if (value == null) {
                sb.append("null");
            } else {
                sb.append("'").append(value.toString()).append("'");
            }
            if (!keys.hasMoreElements()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static final class LogHelper {
        int tokenCount;
        long startTime;

        private LogHelper() {
        }
    }

    private final class HSImpl
    implements HighlightsSequence {
        private static final int S_NORMAL = 1;
        private static final int S_EMBEDDED_HEAD = 2;
        private static final int S_EMBEDDED_TAIL = 3;
        private static final int S_DONE = 4;
        private final long version;
        private final TokenHierarchy<? extends Document> scanner;
        private final int startOffset;
        private final int endOffset;
        private List<TokenSequence<?>> sequences;
        private int state = -1;
        private LogHelper logHelper;

        public HSImpl(long version, TokenHierarchy<? extends Document> scanner, int startOffset, int endOffset) {
            this.version = version;
            this.scanner = scanner;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.sequences = null;
            if (LOG.isLoggable(Level.FINE)) {
                this.logHelper = new LogHelper();
                this.logHelper.startTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean moveNext() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                TokenSequence seq;
                if (this.checkVersion()) {
                    if (this.sequences == null) {
                        this.sequences = new ArrayList();
                        seq = this.scanner.tokenSequence();
                        if (seq != null) {
                            try {
                                seq.move(this.startOffset);
                                this.sequences.add(seq);
                                this.state = 1;
                            }
                            catch (ConcurrentModificationException cme) {
                                this.state = 4;
                            }
                        } else {
                            this.state = 4;
                        }
                    }
                } else {
                    this.state = 4;
                }
                try {
                    switch (this.state) {
                        case 1: {
                            this.state = this.moveTheSequence();
                            break;
                        }
                        case 2: {
                            seq = this.sequences.get(this.sequences.size() - 1);
                            seq.moveStart();
                            if (seq.moveNext()) {
                                this.state = 1;
                                break;
                            }
                            throw new IllegalStateException("Invalid state");
                        }
                        case 3: {
                            this.sequences.remove(this.sequences.size() - 1);
                            this.state = this.moveTheSequence();
                            break;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Invalid state: " + this.state);
                        }
                    }
                }
                catch (ConcurrentModificationException cme) {
                    this.state = 4;
                }
                if (this.state == 1) {
                    try {
                        seq = this.sequences.get(this.sequences.size() - 1);
                        TokenSequence embeddedSeq = seq.embedded();
                        while (embeddedSeq != null && embeddedSeq.moveNext()) {
                            this.sequences.add(this.sequences.size(), embeddedSeq);
                            if (embeddedSeq.offset() + embeddedSeq.token().length() < this.startOffset) {
                                embeddedSeq.move(this.startOffset);
                                if (!embeddedSeq.moveNext()) {
                                    this.state = 3;
                                    break;
                                }
                            } else if (embeddedSeq.offset() > seq.offset()) {
                                this.state = 2;
                                break;
                            }
                            seq = embeddedSeq;
                            embeddedSeq = seq.embedded();
                        }
                    }
                    catch (ConcurrentModificationException cme) {
                        this.state = 4;
                    }
                }
                if (this.state == 4) {
                    SyntaxHighlighting.this.attribsCache.clear();
                }
                if (LOG.isLoggable(Level.FINE)) {
                    if (this.state != 4) {
                        ++this.logHelper.tokenCount;
                    } else {
                        LOG.fine("SyntaxHighlighting for " + this.scanner.inputSource() + ":\n-> returned " + this.logHelper.tokenCount + " token highlights for <" + this.startOffset + "," + this.endOffset + "> in " + (System.currentTimeMillis() - this.logHelper.startTime) + " ms.\n");
                    }
                }
                return this.state != 4;
            }
        }

        @Override
        public int getStartOffset() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                switch (this.state) {
                    case 1: {
                        TokenSequence<?> seq = this.sequences.get(this.sequences.size() - 1);
                        return Math.max(seq.offset(), this.startOffset);
                    }
                    case 2: {
                        TokenSequence<?> embeddingSeq = this.sequences.get(this.sequences.size() - 2);
                        return Math.max(embeddingSeq.offset(), this.startOffset);
                    }
                    case 3: {
                        TokenSequence<?> seq = this.sequences.get(this.sequences.size() - 1);
                        seq.moveEnd();
                        if (seq.movePrevious()) {
                            return Math.max(seq.offset() + seq.token().length(), this.startOffset);
                        }
                        throw new IllegalStateException("Invalid state");
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state " + this.state + ", call moveNext() first.");
            }
        }

        @Override
        public int getEndOffset() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                switch (this.state) {
                    case 1: {
                        TokenSequence<?> seq = this.sequences.get(this.sequences.size() - 1);
                        return Math.min(seq.offset() + seq.token().length(), this.endOffset);
                    }
                    case 2: {
                        TokenSequence<?> seq = this.sequences.get(this.sequences.size() - 1);
                        seq.moveStart();
                        if (seq.moveNext()) {
                            return Math.min(seq.offset(), this.endOffset);
                        }
                        TokenSequence<?> embeddingSeq = this.sequences.get(this.sequences.size() - 2);
                        return Math.min(embeddingSeq.offset() + embeddingSeq.token().length(), this.endOffset);
                    }
                    case 3: {
                        TokenSequence<?> embeddingSeq = this.sequences.get(this.sequences.size() - 2);
                        return Math.min(embeddingSeq.offset() + embeddingSeq.token().length(), this.endOffset);
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state " + this.state + ", call moveNext() first.");
            }
        }

        @Override
        public AttributeSet getAttributes() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                switch (this.state) {
                    case 1: {
                        return this.findAttribs(this.sequences.size() - 1);
                    }
                    case 2: 
                    case 3: {
                        return this.findAttribs(this.sequences.size() - 2);
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state " + this.state + ", call moveNext() first.");
            }
        }

        private AttributeSet findAttribs(int seqIdx) {
            AttributeSet tokenAttribs;
            TokenSequence<?> seq = this.sequences.get(seqIdx);
            TokenId tokenId = seq.token().id();
            String mimePath = SyntaxHighlighting.this.mimeTypeForHack != null ? this.languagePathToMimePathHack(seq.languagePath()) : seq.languagePath().mimePath();
            WeakHashMap<TokenId, AttributeSet> token2attribs = (WeakHashMap<TokenId, AttributeSet>)SyntaxHighlighting.this.attribsCache.get(mimePath);
            if (token2attribs == null) {
                token2attribs = new WeakHashMap<TokenId, AttributeSet>();
                SyntaxHighlighting.this.attribsCache.put(mimePath, token2attribs);
            }
            if ((tokenAttribs = (AttributeSet)token2attribs.get(tokenId)) == null) {
                tokenAttribs = this.findTokenAttribs(tokenId, mimePath, seq.languagePath().innerLanguage());
                token2attribs.put(tokenId, tokenAttribs);
            }
            if (LOG.isLoggable(Level.FINE)) {
                tokenAttribs = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, "<html><b>Token:</b> " + seq.token().text() + "<br><b>Id:</b> " + tokenId.name() + "<br><b>Category:</b> " + tokenId.primaryCategory() + "<br><b>Ordinal:</b> " + tokenId.ordinal() + "<br><b>Mimepath:</b> " + mimePath}), tokenAttribs});
            }
            return tokenAttribs;
        }

        private AttributeSet findTokenAttribs(TokenId tokenId, String mimePath, Language<?> innerLanguage) {
            AttributeSet attribs;
            FontColorSettings fcs = (FontColorSettings)SyntaxHighlighting.this.fcsCache.get(mimePath);
            if (fcs == null) {
                Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)mimePath));
                fcs = (FontColorSettings)lookup.lookup(FontColorSettings.class);
                SyntaxHighlighting.this.fcsCache.put(mimePath, fcs);
                if (fcs == null && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("No FontColorSettings for '" + mimePath + "' mime path.");
                }
            }
            AttributeSet attributeSet = attribs = fcs == null ? null : this.findFontAndColors(fcs, tokenId, innerLanguage);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(SyntaxHighlighting.tokenId(tokenId, false) + " -> {" + SyntaxHighlighting.attributeSet(attribs) + "}");
            }
            return attribs != null ? attribs : SimpleAttributeSet.EMPTY;
        }

        private String languagePathToMimePathHack(LanguagePath languagePath) {
            if (languagePath.size() == 1) {
                return SyntaxHighlighting.this.mimeTypeForHack;
            }
            if (languagePath.size() > 1) {
                return SyntaxHighlighting.this.mimeTypeForHack + "/" + languagePath.subPath(1).mimePath();
            }
            throw new IllegalStateException("LanguagePath should not be empty.");
        }

        private AttributeSet findFontAndColors(FontColorSettings fcs, TokenId tokenId, Language lang) {
            AttributeSet attribs;
            block2: {
                String c;
                String primary;
                String name = tokenId.name();
                attribs = fcs.getTokenFontColors(name);
                if (attribs == null && (primary = tokenId.primaryCategory()) != null) {
                    attribs = fcs.getTokenFontColors(primary);
                }
                if (attribs != null) break block2;
                List categories = lang.nonPrimaryTokenCategories(tokenId);
                Iterator i$ = categories.iterator();
                while (i$.hasNext() && (attribs = fcs.getTokenFontColors(c = (String)i$.next())) == null) {
                }
            }
            return attribs;
        }

        private int moveTheSequence() {
            TokenSequence<?> seq = this.sequences.get(this.sequences.size() - 1);
            if (seq.moveNext()) {
                if (seq.offset() < this.endOffset) {
                    return 1;
                }
                return 4;
            }
            if (this.sequences.size() > 1) {
                TokenSequence<?> embeddingSeq = this.sequences.get(this.sequences.size() - 2);
                seq.moveEnd();
                if (seq.movePrevious()) {
                    if (seq.offset() + seq.token().length() < embeddingSeq.offset() + embeddingSeq.token().length()) {
                        return 3;
                    }
                    this.sequences.remove(this.sequences.size() - 1);
                    return this.moveTheSequence();
                }
                throw new IllegalStateException("Invalid state");
            }
            this.sequences.clear();
            return 4;
        }

        private boolean checkVersion() {
            return this.version == SyntaxHighlighting.this.version;
        }
    }
}

