/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.api.classpath.GlobalPathRegistry;
import org.netbeans.modules.gsfret.source.usages.RepositoryUpdater;

public class SourceUtils {
    private SourceUtils() {
    }

    public static boolean isScanInProgress() {
        return RepositoryUpdater.getDefault().isScanInProgress();
    }

    public static void waitScanFinished() throws InterruptedException {
        RepositoryUpdater.getDefault().waitScanFinished();
    }

    public static Set<URL> getDependentRoots(URL root) {
        Map<URL, List<URL>> deps = RepositoryUpdater.getDefault().getDependencies();
        return SourceUtils.getDependentRootsImpl(root, deps);
    }

    static Set<URL> getDependentRootsImpl(URL root, Map<URL, List<URL>> deps) {
        HashMap<URL, ArrayList<URL>> inverseDeps = new HashMap<URL, ArrayList<URL>>();
        for (Map.Entry<URL, List<URL>> entry : deps.entrySet()) {
            URL u1 = entry.getKey();
            List<URL> l1 = entry.getValue();
            for (URL u2 : l1) {
                ArrayList<URL> l2 = (ArrayList<URL>)inverseDeps.get(u2);
                if (l2 == null) {
                    l2 = new ArrayList<URL>();
                    inverseDeps.put(u2, l2);
                }
                l2.add(u1);
            }
        }
        HashSet<URL> result = new HashSet<URL>();
        LinkedList<URL> todo = new LinkedList<URL>();
        todo.add(root);
        while (!todo.isEmpty()) {
            URL u = (URL)todo.removeFirst();
            if (result.contains(u)) continue;
            result.add(u);
            List ideps = (List)inverseDeps.get(u);
            if (ideps == null) continue;
            todo.addAll(ideps);
        }
        Set cps = GlobalPathRegistry.getDefault().getPaths("classpath/source");
        HashSet<URL> toRetain = new HashSet<URL>();
        for (ClassPath cp : cps) {
            for (ClassPath.Entry e : cp.entries()) {
                toRetain.add(e.getURL());
            }
        }
        result.retainAll(toRetain);
        return result;
    }
}

