/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.api.classpath.GlobalPathRegistry;
import org.netbeans.modules.gsfpath.api.classpath.GlobalPathRegistryEvent;
import org.netbeans.modules.gsfpath.api.classpath.GlobalPathRegistryListener;
import org.netbeans.modules.gsfpath.api.queries.SourceForBinaryQuery;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.PathResourceImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class GlobalSourcePath {
    public static final String PROP_INCLUDES = "includes";
    private static GlobalSourcePath instance;
    private final GlobalPathRegistry gpr;
    private List<? extends PathResourceImplementation> resources;
    private List<? extends PathResourceImplementation> unknownResources;
    private List<? extends PathResourceImplementation> binaryResources;
    private Set<ClassPath> activeCps;
    private Map<URL, SourceForBinaryQuery.Result> sourceResults;
    private Map<URL, URL[]> translatedRoots;
    private Map<URL, WeakValue> unknownRoots;
    private long timeStamp = -1L;
    private Runnable debugCallBack;
    private final SourcePathImplementation sourcePath;
    private final BinaryPathImplementation binaryPath;
    private final UnknownSourcePathImplementation unknownSourcePath;
    private final Listener listener = new Listener();
    private PropertyChangeListener excludesListener;

    private GlobalSourcePath() {
        this.sourcePath = new SourcePathImplementation();
        this.binaryPath = new BinaryPathImplementation();
        this.unknownSourcePath = new UnknownSourcePathImplementation();
        this.gpr = GlobalPathRegistry.getDefault();
        this.activeCps = Collections.emptySet();
        this.sourceResults = Collections.emptyMap();
        this.unknownRoots = new HashMap<URL, WeakValue>();
        this.translatedRoots = new HashMap<URL, URL[]>();
        this.gpr.addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create(GlobalPathRegistryListener.class, (EventListener)this.listener, (Object)this.gpr));
    }

    public void setExcludesListener(PropertyChangeListener listener) throws TooManyListenersException {
        if (this.excludesListener != null) {
            throw new TooManyListenersException();
        }
        this.excludesListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getSourceRootForBinaryRoot(URL binaryRoot, ClassPath definingClassPath, boolean fire) {
        URL[] result = this.translatedRoots.get(binaryRoot);
        if (result != null) {
            if (result.length > 0) {
                return result;
            }
            return null;
        }
        ArrayList<URL> cacheRoots = new ArrayList<URL>();
        Collection<? extends PathResourceImplementation> unknownRes = GlobalSourcePath.getSources(SourceForBinaryQuery.findSourceRoots((URL)binaryRoot).getRoots(), cacheRoots, null);
        if (unknownRes.isEmpty()) {
            return null;
        }
        result = new URL[cacheRoots.size()];
        GlobalSourcePath globalSourcePath = this;
        synchronized (globalSourcePath) {
            Iterator it = cacheRoots.iterator();
            int i = 0;
            while (it.hasNext()) {
                result[i] = (URL)it.next();
                this.unknownRoots.put(result[i], new WeakValue(definingClassPath, result[i]));
                ++i;
            }
        }
        if (fire) {
            this.resetCacheAndFire();
        }
        return result;
    }

    public ClassPathImplementation getSourcePath() {
        return this.sourcePath;
    }

    public ClassPathImplementation getUnknownSourcePath() {
        return this.unknownSourcePath;
    }

    public ClassPathImplementation getBinaryPath() {
        return this.binaryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCacheAndFire() {
        GlobalSourcePath globalSourcePath = this;
        synchronized (globalSourcePath) {
            this.resources = null;
            this.binaryResources = null;
            this.unknownResources = null;
            ++this.timeStamp;
        }
        this.sourcePath.firePropertyChange();
        this.binaryPath.firePropertyChange();
        this.unknownSourcePath.firePropertyChange();
    }

    /*
     * WARNING - void declaration
     */
    private static Result createResources(Request r) {
        boolean notContained;
        URL url;
        assert (r != null);
        HashSet<Object> result = new HashSet<Object>();
        HashSet<PathResourceImplementation> unknownResult = new HashSet<PathResourceImplementation>();
        HashSet<PathResourceImplementation> binaryResult = new HashSet<PathResourceImplementation>();
        HashMap<URL, URL[]> translatedRoots = new HashMap<URL, URL[]>();
        HashSet<ClassPath> newCps = new HashSet<ClassPath>();
        for (ClassPath cp : r.sourceCps) {
            boolean bl = !r.oldCps.remove(cp);
            for (ClassPath.Entry entry : cp.entries()) {
                try {
                    url = entry.getURL();
                    if (!url.toExternalForm().endsWith("/")) {
                        url = new URL(url.toExternalForm() + "/");
                    }
                    result.add(ClassPathSupport.createResource((URL)url));
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
            notContained = newCps.add(cp);
            if (!bl || !notContained) continue;
            cp.addPropertyChangeListener(r.propertyListener);
        }
        for (ClassPath cp : r.bootCps) {
            boolean bl = !r.oldCps.remove(cp);
            for (ClassPath.Entry entry : cp.entries()) {
                try {
                    url = entry.getURL();
                    if (!url.toExternalForm().endsWith("/")) {
                        url = new URL(url.toExternalForm() + "/");
                    }
                    result.add(ClassPathSupport.createResource((URL)url));
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
            notContained = newCps.add(cp);
            if (!bl || !notContained) continue;
            cp.addPropertyChangeListener(r.propertyListener);
        }
        HashMap<URL, SourceForBinaryQuery.Result> newSR = new HashMap<URL, SourceForBinaryQuery.Result>();
        for (ClassPath classPath : r.compileCps) {
            boolean isNew2 = !r.oldCps.remove(classPath);
            for (ClassPath.Entry entry : classPath.entries()) {
                boolean isNewSR;
                URL url2 = entry.getURL();
                if (translatedRoots.containsKey(url2)) continue;
                SourceForBinaryQuery.Result sr = r.oldSR.remove(url2);
                if (sr == null) {
                    sr = SourceForBinaryQuery.findSourceRoots((URL)url2);
                    isNewSR = true;
                } else {
                    isNewSR = false;
                }
                assert (!newSR.containsKey(url2));
                newSR.put(url2, sr);
                ArrayList<URL> cacheURLs = new ArrayList<URL>();
                Collection<? extends PathResourceImplementation> srcRoots = GlobalSourcePath.getSources(sr.getRoots(), cacheURLs, r.unknownRoots);
                if (srcRoots.isEmpty()) {
                    try {
                        if (!url2.toExternalForm().endsWith("/")) {
                            url2 = new URL(url2.toExternalForm() + "/");
                        }
                        binaryResult.add(ClassPathSupport.createResource((URL)url2));
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                } else {
                    result.addAll(srcRoots);
                }
                translatedRoots.put(url2, cacheURLs.toArray(new URL[cacheURLs.size()]));
                if (!isNewSR) continue;
                sr.addChangeListener(r.changeListener);
            }
            boolean notContained2 = newCps.add(classPath);
            if (!isNew2 || !notContained2) continue;
            classPath.addPropertyChangeListener(r.propertyListener);
        }
        for (ClassPath classPath : r.oldCps) {
            classPath.removePropertyChangeListener(r.propertyListener);
        }
        for (Map.Entry entry : r.oldSR.entrySet()) {
            ((SourceForBinaryQuery.Result)entry.getValue()).removeChangeListener(r.changeListener);
        }
        for (URL uRL : r.unknownRoots.keySet()) {
            try {
                void var8_15;
                if (!uRL.toExternalForm().endsWith("/")) {
                    URL uRL2 = new URL(uRL.toExternalForm() + "/");
                }
                unknownResult.add(ClassPathSupport.createResource((URL)var8_15));
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
        return new Result(r.timeStamp, new ArrayList(result), new ArrayList(binaryResult), new ArrayList(unknownResult), newCps, newSR, translatedRoots, r.unknownRoots);
    }

    void setDebugCallBack(Runnable callBack) {
        this.debugCallBack = callBack;
    }

    private static Collection<? extends PathResourceImplementation> getSources(FileObject[] roots, List<URL> cacheDirs, Map<URL, WeakValue> unknownRoots) {
        assert (roots != null);
        URL[] urls = new URL[roots.length];
        boolean add = true;
        for (int i = 0; i < roots.length; ++i) {
            try {
                URL url = roots[i].getURL();
                if (!"file".equals(url.getProtocol())) {
                    add = false;
                    break;
                }
                urls[i] = url;
                continue;
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        if (add) {
            ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>(roots.length);
            for (int i = 0; i < urls.length; ++i) {
                if (cacheDirs != null) {
                    cacheDirs.add(urls[i]);
                }
                if (unknownRoots != null) {
                    unknownRoots.remove(urls[i]);
                }
                try {
                    URL url = urls[i];
                    if (!url.toExternalForm().endsWith("/")) {
                        url = new URL(url.toExternalForm() + "/");
                    }
                    result.add(ClassPathSupport.createResource((URL)url));
                    continue;
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
            return result;
        }
        return Collections.emptySet();
    }

    private long getTimeStamp() {
        return this.timeStamp;
    }

    public static synchronized GlobalSourcePath getDefault() {
        if (instance == null) {
            instance = new GlobalSourcePath();
        }
        return instance;
    }

    private class Listener
    implements GlobalPathRegistryListener,
    PropertyChangeListener,
    ChangeListener {
        private Object lastPropagationId;

        private Listener() {
        }

        public void pathsAdded(GlobalPathRegistryEvent event) {
            GlobalSourcePath.this.resetCacheAndFire();
        }

        public void pathsRemoved(GlobalPathRegistryEvent event) {
            GlobalSourcePath.this.resetCacheAndFire();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("entries".equals(propName)) {
                GlobalSourcePath.this.resetCacheAndFire();
            } else if (GlobalSourcePath.PROP_INCLUDES.equals(propName) && GlobalSourcePath.this.excludesListener != null) {
                Object newPropagationId = evt.getPropagationId();
                if (newPropagationId == null || this.lastPropagationId != newPropagationId) {
                    PropertyChangeEvent event = new PropertyChangeEvent(this, GlobalSourcePath.PROP_INCLUDES, evt.getSource(), evt.getSource());
                    GlobalSourcePath.this.excludesListener.propertyChange(event);
                }
                this.lastPropagationId = newPropagationId;
            }
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            GlobalSourcePath.this.resetCacheAndFire();
        }
    }

    private class BinaryPathImplementation
    implements ClassPathImplementation {
        private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

        private BinaryPathImplementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            Request request;
            GlobalSourcePath globalSourcePath = GlobalSourcePath.this;
            synchronized (globalSourcePath) {
                if (GlobalSourcePath.this.binaryResources != null) {
                    return GlobalSourcePath.this.binaryResources;
                }
                request = new Request(GlobalSourcePath.this.getTimeStamp(), GlobalSourcePath.this.gpr.getPaths("classpath/source"), GlobalSourcePath.this.gpr.getPaths("classpath/boot"), GlobalSourcePath.this.gpr.getPaths("classpath/compile"), new HashSet<ClassPath>(GlobalSourcePath.this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result>(GlobalSourcePath.this.sourceResults), new HashMap<URL, WeakValue>(GlobalSourcePath.this.unknownRoots), GlobalSourcePath.this.listener, GlobalSourcePath.this.listener);
            }
            Result res = GlobalSourcePath.createResources(request);
            if (GlobalSourcePath.this.debugCallBack != null) {
                GlobalSourcePath.this.debugCallBack.run();
            }
            BinaryPathImplementation binaryPathImplementation = this;
            synchronized (binaryPathImplementation) {
                if (GlobalSourcePath.this.getTimeStamp() == res.timeStamp) {
                    if (GlobalSourcePath.this.binaryResources == null) {
                        GlobalSourcePath.this.resources = res.resources;
                        GlobalSourcePath.this.binaryResources = res.binaryResources;
                        GlobalSourcePath.this.unknownResources = res.unknownResources;
                        GlobalSourcePath.this.activeCps = res.newCps;
                        GlobalSourcePath.this.sourceResults = res.newSR;
                        GlobalSourcePath.this.translatedRoots = res.translatedRoots;
                        GlobalSourcePath.this.unknownRoots = res.unknownRoots;
                    }
                    return GlobalSourcePath.this.binaryResources;
                }
                return res.binaryResources;
            }
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            assert (listener != null);
            if (this.listeners == null) {
                this.listeners = new ArrayList<PropertyChangeListener>();
            }
            this.listeners.add(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            assert (listener != null);
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void firePropertyChange() {
            PropertyChangeListener[] _listeners;
            BinaryPathImplementation binaryPathImplementation = this;
            synchronized (binaryPathImplementation) {
                if (this.listeners == null) {
                    return;
                }
                _listeners = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
            }
            PropertyChangeEvent event = new PropertyChangeEvent(this, "resources", null, null);
            for (PropertyChangeListener l : _listeners) {
                l.propertyChange(event);
            }
        }
    }

    private class UnknownSourcePathImplementation
    implements ClassPathImplementation {
        private List<PropertyChangeListener> listeners = new CopyOnWriteArrayList<PropertyChangeListener>();

        private UnknownSourcePathImplementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            Request request;
            GlobalSourcePath globalSourcePath = GlobalSourcePath.this;
            synchronized (globalSourcePath) {
                if (GlobalSourcePath.this.unknownResources != null) {
                    return GlobalSourcePath.this.unknownResources;
                }
                request = new Request(GlobalSourcePath.this.getTimeStamp(), GlobalSourcePath.this.gpr.getPaths("classpath/source"), GlobalSourcePath.this.gpr.getPaths("classpath/boot"), GlobalSourcePath.this.gpr.getPaths("classpath/compile"), new HashSet<ClassPath>(GlobalSourcePath.this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result>(GlobalSourcePath.this.sourceResults), new HashMap<URL, WeakValue>(GlobalSourcePath.this.unknownRoots), GlobalSourcePath.this.listener, GlobalSourcePath.this.listener);
            }
            Result res = GlobalSourcePath.createResources(request);
            if (GlobalSourcePath.this.debugCallBack != null) {
                GlobalSourcePath.this.debugCallBack.run();
            }
            UnknownSourcePathImplementation unknownSourcePathImplementation = this;
            synchronized (unknownSourcePathImplementation) {
                if (GlobalSourcePath.this.getTimeStamp() == res.timeStamp) {
                    if (GlobalSourcePath.this.binaryResources == null) {
                        GlobalSourcePath.this.resources = res.resources;
                        GlobalSourcePath.this.binaryResources = res.binaryResources;
                        GlobalSourcePath.this.unknownResources = res.unknownResources;
                        GlobalSourcePath.this.activeCps = res.newCps;
                        GlobalSourcePath.this.sourceResults = res.newSR;
                        GlobalSourcePath.this.translatedRoots = res.translatedRoots;
                        GlobalSourcePath.this.unknownRoots = res.unknownRoots;
                    }
                    return GlobalSourcePath.this.unknownResources;
                }
                return res.unknownResources;
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            assert (listener != null);
            this.listeners.add(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            assert (listener != null);
            this.listeners.remove(listener);
        }

        void firePropertyChange() {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "resources", null, null);
            for (PropertyChangeListener l : this.listeners) {
                l.propertyChange(event);
            }
        }
    }

    private class SourcePathImplementation
    implements ClassPathImplementation {
        private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

        private SourcePathImplementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            Request request;
            GlobalSourcePath globalSourcePath = GlobalSourcePath.this;
            synchronized (globalSourcePath) {
                if (GlobalSourcePath.this.resources != null) {
                    return GlobalSourcePath.this.resources;
                }
                request = new Request(GlobalSourcePath.this.getTimeStamp(), GlobalSourcePath.this.gpr.getPaths("classpath/source"), GlobalSourcePath.this.gpr.getPaths("classpath/boot"), GlobalSourcePath.this.gpr.getPaths("classpath/compile"), new HashSet<ClassPath>(GlobalSourcePath.this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result>(GlobalSourcePath.this.sourceResults), new HashMap<URL, WeakValue>(GlobalSourcePath.this.unknownRoots), GlobalSourcePath.this.listener, GlobalSourcePath.this.listener);
            }
            Result res = GlobalSourcePath.createResources(request);
            if (GlobalSourcePath.this.debugCallBack != null) {
                GlobalSourcePath.this.debugCallBack.run();
            }
            SourcePathImplementation sourcePathImplementation = this;
            synchronized (sourcePathImplementation) {
                if (GlobalSourcePath.this.getTimeStamp() == res.timeStamp) {
                    if (GlobalSourcePath.this.resources == null) {
                        GlobalSourcePath.this.resources = res.resources;
                        GlobalSourcePath.this.binaryResources = res.binaryResources;
                        GlobalSourcePath.this.unknownResources = res.unknownResources;
                        GlobalSourcePath.this.activeCps = res.newCps;
                        GlobalSourcePath.this.sourceResults = res.newSR;
                        GlobalSourcePath.this.translatedRoots = res.translatedRoots;
                        GlobalSourcePath.this.unknownRoots = res.unknownRoots;
                    }
                    return GlobalSourcePath.this.resources;
                }
                return res.resources;
            }
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            assert (listener != null);
            if (this.listeners == null) {
                this.listeners = new ArrayList<PropertyChangeListener>();
            }
            this.listeners.add(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            assert (listener != null);
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void firePropertyChange() {
            PropertyChangeListener[] _listeners;
            SourcePathImplementation sourcePathImplementation = this;
            synchronized (sourcePathImplementation) {
                if (this.listeners == null) {
                    return;
                }
                _listeners = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
            }
            PropertyChangeEvent event = new PropertyChangeEvent(this, "resources", null, null);
            for (PropertyChangeListener l : _listeners) {
                l.propertyChange(event);
            }
        }
    }

    private static class Result {
        final long timeStamp;
        final List<? extends PathResourceImplementation> resources;
        final List<? extends PathResourceImplementation> binaryResources;
        final List<? extends PathResourceImplementation> unknownResources;
        final Set<ClassPath> newCps;
        final Map<URL, SourceForBinaryQuery.Result> newSR;
        final Map<URL, URL[]> translatedRoots;
        final Map<URL, WeakValue> unknownRoots;

        public Result(long timeStamp, List<? extends PathResourceImplementation> resources, List<? extends PathResourceImplementation> binaryResources, List<? extends PathResourceImplementation> unknownResources, Set<ClassPath> newCps, Map<URL, SourceForBinaryQuery.Result> newSR, Map<URL, URL[]> translatedRoots, Map<URL, WeakValue> unknownRoots) {
            assert (resources != null);
            assert (binaryResources != null);
            assert (unknownResources != null);
            assert (newCps != null);
            assert (newSR != null);
            assert (translatedRoots != null);
            this.timeStamp = timeStamp;
            this.resources = resources;
            this.binaryResources = binaryResources;
            this.unknownResources = unknownResources;
            this.newCps = newCps;
            this.newSR = newSR;
            this.translatedRoots = translatedRoots;
            this.unknownRoots = unknownRoots;
        }
    }

    private static class Request {
        final long timeStamp;
        final Set<ClassPath> sourceCps;
        final Set<ClassPath> bootCps;
        final Set<ClassPath> compileCps;
        final Set<ClassPath> oldCps;
        final Map<URL, SourceForBinaryQuery.Result> oldSR;
        final Map<URL, WeakValue> unknownRoots;
        final PropertyChangeListener propertyListener;
        final ChangeListener changeListener;

        public Request(long timeStamp, Set<ClassPath> sourceCps, Set<ClassPath> bootCps, Set<ClassPath> compileCps, Set<ClassPath> oldCps, Map<URL, SourceForBinaryQuery.Result> oldSR, Map<URL, WeakValue> unknownRoots, PropertyChangeListener propertyListener, ChangeListener changeListener) {
            assert (sourceCps != null);
            assert (bootCps != null);
            assert (compileCps != null);
            assert (oldCps != null);
            assert (oldSR != null);
            assert (unknownRoots != null);
            assert (propertyListener != null);
            assert (changeListener != null);
            this.timeStamp = timeStamp;
            this.sourceCps = sourceCps;
            this.bootCps = bootCps;
            this.compileCps = compileCps;
            this.oldCps = oldCps;
            this.oldSR = oldSR;
            this.unknownRoots = unknownRoots;
            this.propertyListener = propertyListener;
            this.changeListener = changeListener;
        }
    }

    private class WeakValue
    extends WeakReference<ClassPath>
    implements Runnable {
        private URL key;

        public WeakValue(ClassPath ref, URL key) {
            super(ref, Utilities.activeReferenceQueue());
            assert (key != null);
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean fire = false;
            GlobalSourcePath globalSourcePath = GlobalSourcePath.this;
            synchronized (globalSourcePath) {
                fire = GlobalSourcePath.this.unknownRoots.remove(this.key) != null;
            }
            if (fire) {
                GlobalSourcePath.this.resetCacheAndFire();
            }
        }
    }
}

