/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.hints.infrastructure;

import java.util.ArrayList;
import javax.swing.text.Document;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.gsfret.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.gsfret.hints.infrastructure.GsfHintsManager;
import org.netbeans.modules.gsfret.hints.infrastructure.SuggestionsTask;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.support.SelectionAwareSourceTaskFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

public class SelectionHintsTask
extends ScanningCancellableTask<CompilationInfo> {
    @Override
    public void run(CompilationInfo info) throws Exception {
        RuleContext ruleContext;
        this.resume();
        Document doc = info.getDocument();
        if (doc == null) {
            return;
        }
        if (GsfUtilities.isCodeTemplateEditing((Document)doc)) {
            return;
        }
        int[] range = SelectionAwareSourceTaskFactory.getLastSelection(info.getFileObject());
        if (range == null || range.length != 2 || range[0] == -1 || range[1] == -1) {
            return;
        }
        int start = range[0];
        int end = range[1];
        Language language = SuggestionsTask.getHintsProviderLanguage(doc, start);
        if (language == null) {
            return;
        }
        HintsProvider provider = language.getHintsProvider();
        assert (provider != null);
        GsfHintsManager manager = language.getHintsManager();
        if (manager == null) {
            return;
        }
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        ArrayList hints = new ArrayList();
        if (start != end && (ruleContext = manager.createRuleContext(info, language, -1, start, end)) != null) {
            provider.computeSelectionHints((HintsProvider.HintsManager)manager, ruleContext, hints, Math.min(start, end), Math.max(start, end));
            for (Hint hint : hints) {
                ErrorDescription desc = manager.createDescription(hint, ruleContext, false);
                result.add(desc);
            }
        }
        if (this.isCancelled()) {
            return;
        }
        HintsController.setErrors((FileObject)info.getFileObject(), (String)SelectionHintsTask.class.getName(), result);
    }
}

