/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.registration;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.modules.registration.RegisterAction;
import org.netbeans.modules.reglib.BrowserSupport;
import org.netbeans.modules.reglib.NbConnectionSupport;
import org.netbeans.modules.reglib.NbServiceTagSupport;
import org.netbeans.modules.reglib.StatusData;
import org.netbeans.modules.servicetag.RegistrationData;
import org.netbeans.modules.servicetag.ServiceTag;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.windows.WindowManager;

class NbConnection {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.registration.NbConnection");
    private static final String STATUS_FILE = "status.xml";
    private static StatusData status = new StatusData("unknown", 7);
    private static final RequestProcessor RP = new RequestProcessor("NetBeans Registration RP");

    private NbConnection() {
    }

    static void init() {
        if (!Boolean.getBoolean("netbeans.full.hack") && !Boolean.getBoolean("netbeans.close")) {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            NbConnection.checkStatus();
                        }
                    });
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkStatus() {
        LOG.log(Level.FINE, "Check registration status. Thread: " + Thread.currentThread().getName());
        File dir = NbServiceTagSupport.getServiceTagDirHome();
        File statusFile = new File(dir, STATUS_FILE);
        if (statusFile.exists() && statusFile.length() > 0L) {
            LOG.log(Level.FINE, "Load registration status from:" + statusFile);
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(statusFile));
                status = StatusData.loadFromXML((InputStream)in);
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Error: Bad registration data \"" + statusFile + "\"", ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, "Error: Cannot close reader", ex);
                    }
                }
            }
            if (status.getStatus().equals("registered")) {
                LOG.log(Level.FINE, "Status is STATUS_REGISTERED");
                NbConnection.checkProductRegistrationStatus();
            } else if (status.getStatus().equals("never")) {
                LOG.log(Level.FINE, "Status is STATUS_NEVER");
            } else if (status.getStatus().equals("later")) {
                LOG.log(Level.FINE, "Status is STATUS_LATER");
                Date next = new Date(status.getTimestamp().getTime() + (long)status.getDelay() * 24L * 60L * 60L * 1000L);
                LOG.log(Level.FINE, "      Date timestamp:" + status.getTimestamp());
                LOG.log(Level.FINE, "Date timestamp+delay:" + next);
                Date now = new Date();
                LOG.log(Level.FINE, "            Date now:" + now);
                if (now.after(next)) {
                    status.setDelay(7);
                    NbConnection.storeStatus();
                    NbConnection.showDialog();
                }
            } else {
                LOG.log(Level.FINE, "Status is unknown");
                NbConnection.showDialog();
            }
        } else {
            NbConnection.showDialog();
        }
    }

    private static void showDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LOG.log(Level.INFO, "Method showDialog. Thread: " + Thread.currentThread().getName());
                RegisterAction a = (RegisterAction)SharedClassObject.findObject(RegisterAction.class, (boolean)true);
                a.showDialog();
            }
        });
    }

    private static void checkProductRegistrationStatus() {
        String AU_PREF_NODE = "org/netbeans/modules/autoupdate";
        Preferences auPref = NbPreferences.root().node(AU_PREF_NODE);
        int period = auPref.getInt("period", 2);
        if (period == 5) {
            return;
        }
        RegistrationData regData = null;
        try {
            regData = NbServiceTagSupport.getRegistrationData();
        }
        catch (IOException exc) {
            LOG.log(Level.INFO, "Error: Cannot get registration data", exc);
            return;
        }
        Set svcTags = regData.getServiceTags();
        boolean registered = true;
        for (ServiceTag st : svcTags) {
            registered = NbConnectionSupport.isRegistered((String)NbConnectionSupport.getRegistrationQueryHost(), (String)st.getInstanceURN());
            if (registered) continue;
            NbConnection.showDialog();
            break;
        }
        ServiceTag gfST = null;
        for (ServiceTag st : svcTags) {
            if (!st.getProductName().startsWith("Sun Java System Application Server")) continue;
            gfST = st;
            break;
        }
        if (gfST != null && (registered = NbConnectionSupport.isRegistered2((String)NbConnectionSupport.getRegistrationQueryHost(), (String)gfST.getInstanceURN()))) {
            NbConnection.updateGFRegistrationStatus(gfST);
        }
    }

    private static void updateGFRegistrationStatus(ServiceTag st) {
        String id = st.getProductDefinedInstanceID();
        String[] arr = id.split(",");
        String gfHome = "";
        for (String s : arr) {
            if (!s.startsWith("glassfish.home")) continue;
            int pos = s.indexOf("=");
            if (pos != -1) {
                gfHome = s.substring(pos + 1);
                break;
            }
            return;
        }
        if (gfHome.length() == 0) {
            return;
        }
        File regFile = new File(gfHome + File.separator + "lib" + File.separator + "registration" + File.separator + "servicetag-registry.xml");
        if (!regFile.canWrite()) {
            return;
        }
        LOG.log(Level.INFO, "Update file: " + regFile);
        try {
            FileInputStream in = new FileInputStream(regFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            File f = File.createTempFile("nbt", null, regFile.getParentFile());
            PrintWriter pw = new PrintWriter(f, "UTF-8");
            String line = null;
            while ((line = reader.readLine()) != null) {
                String output = line;
                if (line.contains("NOT_REGISTERED")) {
                    output = line.replace("NOT_REGISTERED", "REGISTERED");
                } else if (line.contains("ASK_FOR_REGISTRATION")) {
                    output = line.replace("ASK_FOR_REGISTRATION", "DONT_ASK_FOR_REGISTRATION");
                }
                pw.println(output);
            }
            pw.flush();
            pw.close();
            ((InputStream)in).close();
            regFile.delete();
            boolean ret = f.renameTo(regFile);
            LOG.log(Level.FINE, "Did rename succeed: " + ret);
        }
        catch (IOException exc) {
            LOG.log(Level.INFO, "Cannot update: " + regFile, exc);
        }
    }

    static void updateStatus(String value) {
        LOG.log(Level.FINE, "updateStatus status:" + value);
        if (value != null) {
            status.setStatus(value);
        }
        status.setTimestamp(new Date());
        NbConnection.storeStatus();
        if ("registered".equals(status.getStatus())) {
            try {
                NbConnection.register(NbServiceTagSupport.getRegistrationData());
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Error: Cannot register product", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void storeStatus() {
        File dir = NbServiceTagSupport.getServiceTagDirHome();
        File statusFile = new File(dir, STATUS_FILE);
        LOG.log(Level.FINE, "Store registration status to: " + statusFile);
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(statusFile));
            status.storeToXML((OutputStream)out);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Error: Cannot save status data to \"" + statusFile, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "Error: Cannot close writer", ex);
                }
            }
        }
    }

    static void register(final RegistrationData regData) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                String product = NbServiceTagSupport.getProductId((RegistrationData)regData);
                LOG.log(Level.FINE, "Product registration");
                URL url = NbConnectionSupport.getRegistrationURL((String)regData.getRegistrationURN(), (String)product);
                LOG.log(Level.FINE, "POST registration data to:" + url);
                boolean succeed = NbConnectionSupport.postRegistrationData((URL)url, (RegistrationData)regData);
                if (succeed) {
                    LOG.log(Level.FINE, "Open browser with:" + url);
                    try {
                        NbConnection.openBrowser(url);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, "Error: Cannot open browser", ex);
                    }
                } else {
                    try {
                        NbConnection.openOfflineRegisterPage(product, NbServiceTagSupport.getProductNames((RegistrationData)regData));
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, "Error: Cannot open browser", ex);
                    }
                }
            }
        });
    }

    private static void openBrowser(URL url) throws IOException {
        if (BrowserSupport.isSupported()) {
            try {
                BrowserSupport.browse((URI)url.toURI());
            }
            catch (URISyntaxException ex) {
                InternalError x = new InternalError("Error in registering: " + ex.getMessage());
                x.initCause(ex);
                throw x;
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.FINE, "Cannot open browser:", ex);
            }
            catch (UnsupportedOperationException ex) {
                LOG.log(Level.FINE, "Cannot open browser:", ex);
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, "Cannot open browser:", ex);
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
        } else {
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
    }

    private static void openOfflineRegisterPage(String product, String[] productNames) throws IOException {
        File registerPage = NbServiceTagSupport.getRegistrationHtmlPage((String)product, (String[])productNames);
        if (BrowserSupport.isSupported()) {
            try {
                BrowserSupport.browse((URI)registerPage.toURI());
            }
            catch (FileNotFoundException ex) {
                InternalError x = new InternalError("Error in launching " + registerPage + ": " + ex.getMessage());
                x.initCause(ex);
                throw x;
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.FINE, "Cannot open browser:", ex);
            }
            catch (UnsupportedOperationException ex) {
                LOG.log(Level.FINE, "Cannot open browser:", ex);
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, "Cannot open browser:", ex);
                HtmlBrowser.URLDisplayer.getDefault().showURL(registerPage.toURI().toURL());
            }
        } else {
            HtmlBrowser.URLDisplayer.getDefault().showURL(registerPage.toURI().toURL());
        }
    }
}

