/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.spi.model.TypesProvider;
import org.openide.util.Lookup;

public final class CsmTypes {
    private static TypesProvider provider;

    private CsmTypes() {
    }

    public static CsmType createType(CsmClassifier cls, TypeDescriptor td, OffsetDescriptor offs) {
        return CsmTypes.getProvider().createType(cls, td, offs);
    }

    public static CsmType createType(CsmType orig, TypeDescriptor newTypeDescriptor) {
        return CsmTypes.getProvider().createType(orig, newTypeDescriptor);
    }

    public static CsmType createSimpleType(CsmClassifier cls, OffsetDescriptor offs) {
        return CsmTypes.getProvider().createType(cls, new TypeDescriptor(false, false, 0, 0), offs);
    }

    public static CsmType createConstType(CsmType orig) {
        return CsmTypes.getProvider().createType(orig, new TypeDescriptor(true, orig.isReference(), orig.getPointerDepth(), orig.getArrayDepth()));
    }

    public static CsmType createDereferencedType(CsmType type) {
        int arrDepth = type.getArrayDepth();
        int ptrDepth = type.getPointerDepth();
        if (ptrDepth > 0) {
            --ptrDepth;
        } else {
            arrDepth = Math.max(arrDepth - 1, 0);
        }
        return CsmTypes.getProvider().createType(type, new TypeDescriptor(type.isConst(), type.isReference(), ptrDepth, arrDepth));
    }

    private static TypesProvider getProvider() {
        if (ProviderInstanceHolder.provider == null) {
            throw new IllegalStateException("no any avaiable org.netbeans.modules.cnd.spi.model.TypesProvider instances");
        }
        return ProviderInstanceHolder.provider;
    }

    private static final class ProviderInstanceHolder {
        private static final TypesProvider provider = (TypesProvider)Lookup.getDefault().lookup(TypesProvider.class);

        private ProviderInstanceHolder() {
        }
    }

    public static final class TypeDescriptor {
        private final boolean _const;
        private final boolean _reference;
        private final int _ptrDepth;
        private final int _arrDepth;

        public TypeDescriptor(boolean _const, boolean _reference, int _ptrDepth, int _arrDepth) {
            this._const = _const;
            this._reference = _reference;
            this._ptrDepth = _ptrDepth;
            this._arrDepth = _arrDepth;
        }

        public int getArrDepth() {
            return this._arrDepth;
        }

        public boolean isConst() {
            return this._const;
        }

        public int getPtrDepth() {
            return this._ptrDepth;
        }

        public boolean isReference() {
            return this._reference;
        }
    }

    public static final class OffsetDescriptor {
        private final CsmFile container;
        private final int start;
        private final int end;

        public OffsetDescriptor(CsmFile container, int start, int end) {
            this.container = container;
            this.start = start;
            this.end = end;
        }

        public CsmFile getContainer() {
            return this.container;
        }

        public int getEndOffset() {
            return this.end;
        }

        public int getStartOffset() {
            return this.start;
        }
    }
}

