/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.struts.editor;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.web.struts.config.model.FormProperty;
import org.netbeans.modules.web.struts.config.model.Forward;
import org.netbeans.modules.web.struts.config.model.StrutsException;
import org.openide.util.Exceptions;

public class StrutsEditorUtilities {
    protected static int XML_ATTRIBUTE = 5;
    protected static int XML_ELEMENT = 4;
    protected static int XML_ATTRIBUTE_VALUE = 7;
    public static String END_LINE = System.getProperty("line.separator");

    public static String getActionPath(BaseDocument baseDocument, int n) {
        try {
            TokenItem tokenItem;
            ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
            for (tokenItem = extSyntaxSupport.getTokenChain(n, n + 1); tokenItem != null && (tokenItem.getTokenID().getNumericID() != XML_ELEMENT || tokenItem.getImage().equals("/>") || tokenItem.getImage().equals(">") || tokenItem.getImage().equals("<forward") || tokenItem.getImage().equals("<exception") || tokenItem.getImage().equals("</action") || tokenItem.getImage().equals("<description") || tokenItem.getImage().equals("<display-name") || tokenItem.getImage().equals("<set-property") || tokenItem.getImage().equals("<icon")); tokenItem = tokenItem.getPrevious()) {
            }
            if (tokenItem != null && tokenItem.getImage().equals("<action")) {
                for (tokenItem = tokenItem.getNext(); !(tokenItem == null || tokenItem.getTokenID().getNumericID() == XML_ELEMENT || tokenItem.getTokenID().getNumericID() == XML_ATTRIBUTE && tokenItem.getImage().equals("path")); tokenItem = tokenItem.getNext()) {
                }
                if (tokenItem != null && tokenItem.getImage().equals("path")) {
                    for (tokenItem = tokenItem.getNext(); tokenItem != null && tokenItem.getTokenID().getNumericID() != XML_ATTRIBUTE_VALUE && tokenItem.getTokenID().getNumericID() != XML_ELEMENT && tokenItem.getTokenID().getNumericID() != XML_ATTRIBUTE; tokenItem = tokenItem.getNext()) {
                    }
                    if (tokenItem != null && tokenItem.getTokenID().getNumericID() == XML_ATTRIBUTE_VALUE) {
                        String string = tokenItem.getImage().trim();
                        string = string.substring(1);
                        string = string.substring(0, string.length() - 1);
                        return string;
                    }
                }
            }
            return null;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return null;
        }
    }

    public static String getActionFormBeanName(BaseDocument baseDocument, int n) {
        try {
            TokenItem tokenItem;
            ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
            for (tokenItem = extSyntaxSupport.getTokenChain(n, n + 1); tokenItem != null && (tokenItem.getTokenID().getNumericID() != XML_ELEMENT || tokenItem.getImage().equals("/>") || tokenItem.getImage().equals(">") || tokenItem.getImage().equals("<form-property") || tokenItem.getImage().equals("</form-bean") || tokenItem.getImage().equals("<description") || tokenItem.getImage().equals("<display-name") || tokenItem.getImage().equals("<set-property") || tokenItem.getImage().equals("<icon")); tokenItem = tokenItem.getPrevious()) {
            }
            if (tokenItem != null && tokenItem.getImage().equals("<form-bean")) {
                for (tokenItem = tokenItem.getNext(); !(tokenItem == null || tokenItem.getTokenID().getNumericID() == XML_ELEMENT || tokenItem.getTokenID().getNumericID() == XML_ATTRIBUTE && tokenItem.getImage().equals("name")); tokenItem = tokenItem.getNext()) {
                }
                if (tokenItem != null && tokenItem.getImage().equals("name")) {
                    for (tokenItem = tokenItem.getNext(); tokenItem != null && tokenItem.getTokenID().getNumericID() != XML_ATTRIBUTE_VALUE && tokenItem.getTokenID().getNumericID() != XML_ELEMENT && tokenItem.getTokenID().getNumericID() != XML_ATTRIBUTE; tokenItem = tokenItem.getNext()) {
                    }
                    if (tokenItem != null && tokenItem.getTokenID().getNumericID() == XML_ATTRIBUTE_VALUE) {
                        String string = tokenItem.getImage().trim();
                        string = string.substring(1);
                        string = string.substring(0, string.length() - 1);
                        return string;
                    }
                }
            }
            return null;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return null;
        }
    }

    public static int writeForwardIntoAction(BaseDocument baseDocument, Forward forward, String string) throws IOException {
        return StrutsEditorUtilities.writeElementIntoFather(baseDocument, forward, "action", string, "forward");
    }

    public static int writeExceptionIntoAction(BaseDocument baseDocument, StrutsException strutsException, String string) throws IOException {
        return StrutsEditorUtilities.writeElementIntoFather(baseDocument, strutsException, "action", string, "exception");
    }

    public static int writePropertyIntoBean(BaseDocument baseDocument, FormProperty formProperty, String string) throws IOException {
        return StrutsEditorUtilities.writeElementIntoFather(baseDocument, formProperty, "form-bean", string, "form-property");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int writeElementIntoFather(BaseDocument baseDocument, BaseBean baseBean, String string, String string2, String string3) throws IOException {
        int n;
        block22: {
            n = -1;
            ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
            TokenItem tokenItem = null;
            try {
                int n2 = 0;
                do {
                    if ((tokenItem = extSyntaxSupport.getTokenChain(n2 = baseDocument.getText(0, baseDocument.getLength()).indexOf("\"" + string2 + "\"", n2 + 1), n2 + 1)) == null || tokenItem.getTokenID().getNumericID() != XML_ATTRIBUTE_VALUE) continue;
                    while (tokenItem != null && tokenItem.getTokenID().getNumericID() != XML_ELEMENT) {
                        tokenItem = tokenItem.getPrevious();
                    }
                } while (n2 > 0 && tokenItem != null && (tokenItem.getTokenID().getNumericID() != XML_ELEMENT || !tokenItem.getImage().equals("<" + string)));
                if (tokenItem == null || tokenItem.getTokenID().getNumericID() != XML_ELEMENT || !tokenItem.getImage().equals("<" + string)) break block22;
                for (tokenItem = tokenItem.getNext(); tokenItem != null && tokenItem.getTokenID().getNumericID() != XML_ELEMENT; tokenItem = tokenItem.getNext()) {
                }
                if (tokenItem != null && tokenItem.getImage().equals("/>")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    n2 = tokenItem.getOffset();
                    stringBuffer.append(">");
                    stringBuffer.append(END_LINE);
                    stringBuffer.append(StrutsEditorUtilities.addNewLines(baseBean));
                    stringBuffer.append(END_LINE);
                    stringBuffer.append("</");
                    stringBuffer.append(string);
                    stringBuffer.append(">");
                    Formatter formatter = baseDocument.getFormatter();
                    formatter.reformatLock();
                    try {
                        try {
                            baseDocument.atomicLock();
                            baseDocument.remove(n2, 2);
                            baseDocument.insertString(n2, stringBuffer.toString(), null);
                            n2 += baseDocument.getFormatter().reformat(baseDocument, n2, n2 + stringBuffer.length() - 1);
                            n = n2;
                        }
                        finally {
                            baseDocument.atomicUnlock();
                        }
                    }
                    finally {
                        formatter.reformatUnlock();
                    }
                }
                if (tokenItem != null && tokenItem.getImage().equals(">")) {
                    n2 = -1;
                    while (!(tokenItem == null || tokenItem.getTokenID().getNumericID() == XML_ELEMENT && tokenItem.getImage().equals("</" + string))) {
                        while (tokenItem != null && (tokenItem.getTokenID().getNumericID() != XML_ELEMENT || !tokenItem.getImage().equals("<" + string3) && !tokenItem.getImage().equals("</" + string))) {
                            tokenItem = tokenItem.getNext();
                        }
                        if (tokenItem != null && tokenItem.getImage().equals("<" + string3)) {
                            while (tokenItem != null && (tokenItem.getTokenID().getNumericID() != XML_ELEMENT || !tokenItem.getImage().equals("/>") && !tokenItem.getImage().equals("</" + string3))) {
                                tokenItem = tokenItem.getNext();
                            }
                            if (tokenItem != null && tokenItem.getImage().equals("</" + string3)) {
                                while (!(tokenItem == null || tokenItem.getTokenID().getNumericID() == XML_ELEMENT && tokenItem.getImage().equals(">"))) {
                                    tokenItem = tokenItem.getNext();
                                }
                            }
                            if (tokenItem != null) {
                                n2 = tokenItem.getOffset() + tokenItem.getImage().length() - 1;
                            }
                        }
                        if (tokenItem == null || !tokenItem.getImage().equals("</" + string) || n2 != -1) continue;
                        while (tokenItem != null && (tokenItem.getTokenID().getNumericID() != XML_ELEMENT || !tokenItem.getImage().equals("/>") && !tokenItem.getImage().equals(">"))) {
                            tokenItem = tokenItem.getPrevious();
                        }
                        n2 = tokenItem.getOffset() + tokenItem.getImage().length() - 1;
                    }
                    if (n2 > 0) {
                        n = StrutsEditorUtilities.writeString(baseDocument, StrutsEditorUtilities.addNewLines(baseBean), n2);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return n;
    }

    public static int writeBean(BaseDocument baseDocument, BaseBean baseBean, String string, String string2) throws IOException {
        int n = -1;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = StrutsEditorUtilities.addNewLines(baseBean);
        StringBuffer stringBuffer = new StringBuffer();
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
        try {
            String string4 = baseDocument.getText(0, baseDocument.getLength());
            String string5 = "</" + string;
            int n2 = string4.lastIndexOf(string5);
            if (n2 == -1) {
                n2 = StrutsEditorUtilities.findEndOfElement(baseDocument, "struts-config");
                if (n2 == -1) {
                    n2 = baseDocument.getLength();
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("<struts-config>");
                    stringBuffer.append(END_LINE);
                    if (string2 != null && string2.length() > 0) {
                        stringBuffer.append("<" + string2 + ">");
                        stringBuffer.append(END_LINE);
                        stringBuffer.append(string3);
                        stringBuffer.append(END_LINE);
                        stringBuffer.append("</" + string2 + ">");
                    } else {
                        stringBuffer.append(string3);
                    }
                    stringBuffer.append(END_LINE);
                    stringBuffer.append("</struts-config>");
                    stringBuffer.append(END_LINE);
                    n = StrutsEditorUtilities.writeString(baseDocument, stringBuffer.toString(), n2);
                } else {
                    if (string2 != null && string2.length() > 0) {
                        int n3 = StrutsEditorUtilities.findEndOfElement(baseDocument, string2);
                        if (n3 == -1) {
                            stringBuffer.append("<" + string2 + ">");
                            stringBuffer.append(END_LINE);
                            stringBuffer.append(string3);
                            stringBuffer.append(END_LINE);
                            stringBuffer.append("</" + string2 + ">");
                        } else {
                            stringBuffer.append(string3);
                            n2 = n3;
                        }
                    } else {
                        stringBuffer.append(string3);
                    }
                    TokenItem tokenItem = extSyntaxSupport.getTokenChain(n2, n2 + 1);
                    if (tokenItem != null) {
                        tokenItem = tokenItem.getPrevious();
                    }
                    while (!(tokenItem == null || tokenItem.getTokenID().getNumericID() == XML_ELEMENT && tokenItem.getImage().equals(">"))) {
                        tokenItem = tokenItem.getPrevious();
                    }
                    if (tokenItem != null) {
                        n2 = tokenItem.getOffset();
                    }
                    n = StrutsEditorUtilities.writeString(baseDocument, stringBuffer.toString(), n2);
                }
            } else {
                TokenItem tokenItem = extSyntaxSupport.getTokenChain(n2, n2 + 1);
                if (tokenItem != null && tokenItem.getTokenID().getNumericID() == XML_ELEMENT) {
                    while (!(tokenItem == null || tokenItem.getTokenID().getNumericID() == XML_ELEMENT && tokenItem.getImage().equals(">"))) {
                        tokenItem = tokenItem.getPrevious();
                    }
                    if (tokenItem != null) {
                        n = StrutsEditorUtilities.writeString(baseDocument, string3, tokenItem.getOffset());
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return n;
    }

    private static String addNewLines(BaseBean baseBean) throws IOException {
        StringWriter stringWriter = new StringWriter();
        baseBean.writeNode((Writer)stringWriter);
        String string = stringWriter.toString();
        string = string.replaceAll("><", ">" + END_LINE + "<");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int writeString(BaseDocument baseDocument, String string, int n) throws BadLocationException {
        int n2 = 0;
        Formatter formatter = baseDocument.getFormatter();
        formatter.indentLock();
        try {
            formatter.reformatLock();
            try {
                try {
                    baseDocument.atomicLock();
                    n = baseDocument.getFormatter().indentNewLine((Document)baseDocument, n + 1);
                    baseDocument.insertString(Math.min(n, baseDocument.getLength()), string, null);
                    n2 = baseDocument.getFormatter().reformat(baseDocument, n, n + string.length() - 1);
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
            finally {
                formatter.reformatUnlock();
            }
        }
        finally {
            formatter.indentUnlock();
        }
        return Math.min(n + n2 + 1, baseDocument.getLength());
    }

    private static int findStartOfElement(BaseDocument baseDocument, String string) throws BadLocationException {
        String string2 = baseDocument.getText(0, baseDocument.getLength());
        int n = baseDocument.getText(0, baseDocument.getLength()).indexOf("<" + string);
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
        while (n > 0) {
            TokenItem tokenItem = extSyntaxSupport.getTokenChain(n, n + 1);
            if (tokenItem != null && tokenItem.getTokenID().getNumericID() == XML_ELEMENT) {
                return tokenItem.getOffset();
            }
            n = baseDocument.getText(0, baseDocument.getLength()).indexOf("<" + string);
        }
        return -1;
    }

    private static int findEndOfElement(BaseDocument baseDocument, String string) throws BadLocationException {
        String string2 = baseDocument.getText(0, baseDocument.getLength());
        int n = baseDocument.getText(0, baseDocument.getLength()).indexOf("</" + string);
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
        while (n > 0) {
            TokenItem tokenItem = extSyntaxSupport.getTokenChain(n, n + 1);
            if (tokenItem != null && tokenItem.getTokenID().getNumericID() == XML_ELEMENT) {
                n = tokenItem.getOffset();
                for (tokenItem = tokenItem.getNext(); !(tokenItem == null || tokenItem.getTokenID().getNumericID() == XML_ELEMENT && tokenItem.getImage().equals(">")); tokenItem = tokenItem.getNext()) {
                }
                if (tokenItem != null) {
                    n = tokenItem.getOffset();
                }
                return n;
            }
            n = baseDocument.getText(0, baseDocument.getLength()).indexOf("</" + string);
        }
        return -1;
    }
}

