/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.options.AbbrevsMIMEProcessor;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.FontsColorsMIMEProcessor;
import org.netbeans.modules.editor.options.KeyBindingsMIMEProcessor;
import org.netbeans.modules.editor.options.MIMEProcessor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileSystem;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class MIMEOptionFile {
    private static final Logger LOG = Logger.getLogger(MIMEOptionFile.class.getName());
    protected BaseOptions base;
    protected MIMEProcessor processor;
    protected Document dom;
    protected Map properties;
    private boolean loaded = false;
    private boolean wasSaved = false;
    private ModuleInfo editorMI;
    private final FileChangeListener fileListener = new FileChangeAdapter(){

        public void fileChanged(FileEvent fe) {
            if (!(MIMEOptionFile.this.processor instanceof AbbrevsMIMEProcessor || MIMEOptionFile.this.processor instanceof FontsColorsMIMEProcessor || MIMEOptionFile.this.processor instanceof KeyBindingsMIMEProcessor)) {
                MIMEOptionFile.this.reloadSettings();
            }
        }
    };
    private final PropertyChangeListener moduleListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"enabled".endsWith(evt.getPropertyName())) {
                return;
            }
            if (!(evt.getSource() instanceof ModuleInfo)) {
                return;
            }
            if ((ModuleInfo)evt.getSource() != null && !((ModuleInfo)evt.getSource()).isEnabled()) {
                MIMEOptionFile.this.editorUninstalled();
            }
        }
    };
    private final ErrorCatcher ERROR_CATCHER = new ErrorCatcher();

    public MIMEOptionFile(BaseOptions base, Object proc) {
        this.base = base;
        this.processor = (MIMEProcessor)proc;
        try {
            this.properties = new HashMap();
            this.dom = this.processor.getXMLDataObject().getDocument();
            this.processor.getXMLDataObject().getPrimaryFile().addFileChangeListener(this.fileListener);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.addEditorModuleListener();
    }

    private void addEditorModuleListener() {
        Lookup.Template templ = new Lookup.Template(ModuleInfo.class);
        Lookup.Result result = Lookup.getDefault().lookup(templ);
        Collection modules = result.allInstances();
        for (ModuleInfo curInfo : modules) {
            if (!"org.netbeans.modules.editor".equals(curInfo.getCodeNameBase())) continue;
            curInfo.addPropertyChangeListener(this.moduleListener);
            this.editorMI = curInfo;
            break;
        }
    }

    private void editorUninstalled() {
        this.processor.getXMLDataObject().getPrimaryFile().removeFileChangeListener(this.fileListener);
        try {
            this.processor.getXMLDataObject().setValid(false);
        }
        catch (PropertyVetoException pve) {
            LOG.log(Level.INFO, null, pve);
        }
        this.editorMI.removePropertyChangeListener(this.moduleListener);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean load) {
        this.loaded = load;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadSettings() {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            if (this.wasSaved) {
                this.wasSaved = false;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Document oldDoc = this.dom;
            this.setLoaded(false);
            try {
                String loc = this.processor.getXMLDataObject().getPrimaryFile().getURL().toExternalForm();
                this.dom = XMLUtil.parse((InputSource)new InputSource(loc), (boolean)true, (boolean)false, (ErrorHandler)this.ERROR_CATCHER, (EntityResolver)EntityCatalog.getDefault());
                this.loadSettings();
            }
            catch (SAXException saxe) {
                this.dom = oldDoc;
                saxe.printStackTrace();
            }
            catch (IOException ioe) {
                this.dom = oldDoc;
                ioe.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveSettings(Document doc) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            try {
                FileLock lock = this.processor.getXMLDataObject().getPrimaryFile().lock();
                try {
                    OutputStream os = this.processor.getXMLDataObject().getPrimaryFile().getOutputStream(lock);
                    try {
                        this.wasSaved = true;
                        XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
                        os.flush();
                    }
                    catch (IOException ioe1) {
                        this.wasSaved = false;
                        LOG.log(Level.WARNING, null, ioe1);
                    }
                    finally {
                        os.close();
                    }
                }
                catch (IOException ioe2) {
                    LOG.log(Level.WARNING, null, ioe2);
                }
                finally {
                    lock.releaseLock();
                }
            }
            catch (IOException ioe3) {
                LOG.log(Level.WARNING, null, ioe3);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected abstract void loadSettings(boolean var1);

    protected void loadSettings() {
        this.loadSettings(true);
    }

    protected abstract void updateSettings(Map var1);

    public Map getAllProperties() {
        if (!this.isLoaded()) {
            this.loadSettings(false);
        }
        return this.properties;
    }

    final void setAllProperties(final Map properties) {
        try {
            FileSystem fs = this.processor.getXMLDataObject().getPrimaryFile().getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    MIMEOptionFile.this.updateSettings(properties);
                }
            });
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Can't save settings by " + this.processor, ioe);
        }
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String level, SAXParseException e) {
            System.err.println("Error level:" + level);
            System.err.println("Line number:" + e.getLineNumber());
            System.err.println("Column number:" + e.getColumnNumber());
            System.err.println("Public ID:" + e.getPublicId());
            System.err.println("System ID:" + e.getSystemId());
            System.err.println("Error message:" + e.getMessage());
        }

        @Override
        public void error(SAXParseException e) {
            this.message("ERROR", e);
        }

        @Override
        public void warning(SAXParseException e) {
            this.message("WARNING", e);
        }

        @Override
        public void fatalError(SAXParseException e) {
            this.message("FATAL", e);
        }
    }
}

